/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SqlQuerySystemViewsIntegrationTest
extends AbstractIndexingCommonTest {
    private static final int TBL_SIZE = 100;
    private static final int QUERY_WAIT_TIMEOUT = 5000;
    private static final Semaphore SEMAPHORE = new Semaphore(0);
    @Parameterized.Parameter(value=1)
    public boolean lazy;
    @Parameterized.Parameter
    public boolean loc;
    private static final AtomicInteger LOC_QRY_ID_GEN = new AtomicInteger();

    @Parameterized.Parameters(name="loc={0}, lazy={1}")
    public static Collection<?> parameters() {
        return Arrays.asList({true, true}, {false, true}, {true, false}, {false, false});
    }

    @Before
    public void before() {
        SEMAPHORE.drainPermits();
    }

    @After
    public void after() throws IgniteInterruptedCheckedException {
        SEMAPHORE.release(100);
        this.waitUntilQueriesCompletes();
    }

    private void waitUntilQueriesCompletes() throws IgniteInterruptedCheckedException {
        SqlQuerySystemViewsIntegrationTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> (Long)this.runSql("select count(*) from " + QueryUtils.sysSchemaName() + ".sql_queries", -1L).get(0).get(0) == 1L, (long)5000L));
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(new CacheConfiguration[]{SqlQuerySystemViewsIntegrationTest.defaultCacheConfiguration()}).setSqlConfiguration(new SqlConfiguration().setSqlGlobalMemoryQuota("0").setSqlQueryMemoryQuota("0").setSqlOffloadingEnabled(true));
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.startGrid(0);
        CacheConfiguration personCache = SqlQuerySystemViewsIntegrationTest.defaultCacheConfiguration().setName("test_cache").setCacheMode(CacheMode.PARTITIONED).setSqlFunctionClasses(new Class[]{SqlQuerySystemViewsIntegrationTest.class}).setBackups(1);
        this.grid(0).addCacheConfiguration(personCache);
        this.prepareTable();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
    }

    @Test
    public void testMemoryMetricForRunningQuery() throws Exception {
        String locQryId = "locQryId_" + LOC_QRY_ID_GEN.incrementAndGet();
        SEMAPHORE.release(1);
        IgniteInternalFuture fut = this.multithreadedAsync(() -> this.runSql("select delay('" + locQryId + "') as qryId, id, value from test_table", -1L), 1);
        long prevSize = -1L;
        SqlQuerySystemViewsIntegrationTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> SEMAPHORE.availablePermits() == 0, (long)5000L));
        for (int i = 0; i < 3; ++i) {
            List<List<?>> res = this.runSql("select memory_current, disk_allocation_total from " + QueryUtils.sysSchemaName() + ".sql_queries where sql like '%" + locQryId + "%' order by start_time", -1L);
            SqlQuerySystemViewsIntegrationTest.assertEquals((int)2, (int)res.size());
            SqlQuerySystemViewsIntegrationTest.assertTrue((prevSize <= (Long)res.get(0).get(0) ? 1 : 0) != 0);
            SqlQuerySystemViewsIntegrationTest.assertEquals((Object)0L, res.get(0).get(1));
            prevSize = (Long)res.get(0).get(0);
            SEMAPHORE.release(25);
            SqlQuerySystemViewsIntegrationTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> SEMAPHORE.availablePermits() == 0, (long)5000L));
        }
        SEMAPHORE.release(100);
        fut.get(this.getTestTimeout());
    }

    @Test
    public void testDiskMetricForRunningQuery() throws Exception {
        String locQryId = "locQryId_" + LOC_QRY_ID_GEN.incrementAndGet();
        SEMAPHORE.release(1);
        IgniteInternalFuture fut = this.multithreadedAsync(() -> this.runSql("select delay('" + locQryId + "') as qryId, id, value from test_table", 10L), 1);
        long prevCurrSize = -1L;
        long prevTotalSize = -1L;
        SqlQuerySystemViewsIntegrationTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> SEMAPHORE.availablePermits() == 0, (long)5000L));
        for (int i = 0; i < 3; ++i) {
            List<List<?>> res = this.runSql("select disk_allocation_current, disk_allocation_total from " + QueryUtils.sysSchemaName() + ".sql_queries where sql like '%" + locQryId + "%' order by start_time", -1L);
            SqlQuerySystemViewsIntegrationTest.assertEquals((int)2, (int)res.size());
            SqlQuerySystemViewsIntegrationTest.assertTrue((prevCurrSize <= (Long)res.get(0).get(0) ? 1 : 0) != 0);
            SqlQuerySystemViewsIntegrationTest.assertTrue((prevTotalSize <= (Long)res.get(0).get(1) ? 1 : 0) != 0);
            prevCurrSize = (Long)res.get(0).get(0);
            prevTotalSize = (Long)res.get(0).get(1);
            SEMAPHORE.release(25);
            SqlQuerySystemViewsIntegrationTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> SEMAPHORE.availablePermits() == 0, (long)5000L));
        }
        SEMAPHORE.release(100);
        fut.get(this.getTestTimeout());
    }

    @Test
    public void testMemoryAndDiskMetricForQueryHistory() {
        String locQryId = "locQryId_" + LOC_QRY_ID_GEN.incrementAndGet();
        for (int i = 0; i < 3; ++i) {
            this.runSql("select '" + locQryId + "' as qryId, id, value from test_table", (long)Math.pow(2.0, i + 10));
        }
        List<List<?>> res = this.runSql("select memory_min, memory_max, disk_allocation_min, disk_allocation_max from " + QueryUtils.sysSchemaName() + ".sql_queries_history where sql like '%" + locQryId + "%'", -1L);
        SqlQuerySystemViewsIntegrationTest.assertEquals((int)1, (int)res.size());
        if (this.lazy) {
            SqlQuerySystemViewsIntegrationTest.assertEquals((Object)0L, res.get(0).get(0));
            SqlQuerySystemViewsIntegrationTest.assertEquals((Object)0L, res.get(0).get(1));
            SqlQuerySystemViewsIntegrationTest.assertEquals((Object)0L, res.get(0).get(2));
            SqlQuerySystemViewsIntegrationTest.assertEquals((Object)0L, res.get(0).get(3));
        } else {
            SqlQuerySystemViewsIntegrationTest.assertTrue((0L < (Long)res.get(0).get(0) ? 1 : 0) != 0);
            SqlQuerySystemViewsIntegrationTest.assertTrue(((Long)res.get(0).get(0) < (Long)res.get(0).get(1) ? 1 : 0) != 0);
            SqlQuerySystemViewsIntegrationTest.assertTrue((0L < (Long)res.get(0).get(2) ? 1 : 0) != 0);
            SqlQuerySystemViewsIntegrationTest.assertTrue(((Long)res.get(0).get(2) <= (Long)res.get(0).get(3) ? 1 : 0) != 0);
        }
    }

    private void prepareTable() {
        IgniteCache cache = this.grid(0).cache("default");
        cache.query(new SqlFieldsQuery("CREATE TABLE test_table (id INT PRIMARY KEY, value VARCHAR) WITH \"TEMPLATE=test_cache\"")).getAll();
        for (int i = 0; i < 100; ++i) {
            cache.query(new SqlFieldsQuery("INSERT INTO test_table (id, value) VALUES (?, ?)").setArgs(new Object[]{i, "value_" + i})).getAll();
        }
    }

    protected List<List<?>> runSql(String sql, long memLimit) {
        IgniteEx node = this.grid(0);
        return node.cache("default").query(new SqlFieldsQueryEx(sql, null).setMaxMemory(memLimit).setLazy(this.lazy).setLocal(this.loc)).getAll();
    }

    @QuerySqlFunction
    public static String delay(String val) throws InterruptedException {
        SEMAPHORE.acquire();
        return val;
    }
}

