/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryHistory;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class SqlQueryHistorySelfTest
extends GridCommonAbstractTest {
    private static final int QUERY_HISTORY_SIZE = 3;
    private static TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    private final boolean activateLazyByDflt = (Boolean)GridTestUtils.getFieldValue(SqlFieldsQuery.class, (String[])new String[]{"DFLT_LAZY"});

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startTestGrid();
        IgniteCache cacheA = this.grid(0).cache("A");
        IgniteCache cacheB = this.grid(0).cache("B");
        for (int i = 0; i < 100; ++i) {
            cacheA.put((Object)i, (Object)String.valueOf(i));
            cacheB.put((Object)i, (Object)String.valueOf(i));
        }
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
    }

    protected void beforeTest() throws Exception {
        ((IgniteH2Indexing)this.queryNode().context().query().getIndexing()).runningQueryManager().resetQueryHistoryMetrics();
    }

    private CacheConfiguration<Integer, String> configureCache(String cacheName) {
        CacheConfiguration ccfg = SqlQueryHistorySelfTest.defaultCacheConfiguration();
        ccfg.setName(cacheName);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setIndexedTypes(new Class[]{Integer.class, String.class});
        ccfg.setSqlFunctionClasses(new Class[]{Functions.class});
        return ccfg;
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.configureCache("A"), this.configureCache("B")});
        cfg.setSqlConfiguration(new SqlConfiguration().setSqlQueryHistorySize(3));
        return cfg;
    }

    @Test
    public void testJdbcSelectQueryHistory() throws Exception {
        String qry = "select * from A.String";
        this.checkQueryMetrics(qry);
    }

    @Test
    public void testJdbcSelectNotFullyFetchedQueryHistory() throws Exception {
        String qry = "select * from A.String";
        try (Connection conn = GridTestUtils.connect((IgniteEx)this.queryNode(), null);
             Statement stmt = conn.createStatement();){
            stmt.setFetchSize(1);
            ResultSet rs = stmt.executeQuery(qry);
            SqlQueryHistorySelfTest.assertTrue((boolean)rs.next());
            this.checkMetrics(0, 0, 0, 0, true);
        }
    }

    @Test
    public void testJdbcQueryHistoryFailed() {
        try (Connection conn = GridTestUtils.connect((IgniteEx)this.queryNode(), null);
             Statement stmt = conn.createStatement();){
            stmt.executeQuery("select * from A.String where A.fail()=1");
            SqlQueryHistorySelfTest.fail((String)"Query should be failed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkMetrics(1, 0, 1, 1, true);
    }

    @Test
    public void testJdbcQueryHistoryForDmlAndDdl() throws Exception {
        List<String> cmds = Arrays.asList("create table TST(id int PRIMARY KEY, name varchar)", "insert into TST(id) values(1)", "commit");
        try (Connection conn = GridTestUtils.connect((IgniteEx)this.queryNode(), null);
             Statement stmt = conn.createStatement();){
            for (String cmd : cmds) {
                stmt.execute(cmd);
            }
        }
        this.checkSeriesCommand(cmds);
    }

    private void checkSeriesCommand(List<String> cmds) throws IgniteInterruptedCheckedException {
        this.waitingFor("size", 3);
        for (int i = 0; i < 3; ++i) {
            this.checkMetrics(3, i, 1, 0, false);
        }
        Collection metrics = ((IgniteH2Indexing)this.queryNode().context().query().getIndexing()).runningQueryManager().queryHistoryMetrics().values();
        SqlQueryHistorySelfTest.assertEquals((int)3, (int)metrics.size());
        Set qries = metrics.stream().map(QueryHistory::query).collect(Collectors.toSet());
        for (int i = 0; i < cmds.size(); ++i) {
            SqlQueryHistorySelfTest.assertTrue((boolean)qries.contains(cmds.get(2 - i)));
        }
    }

    @Test
    public void testSqlFieldsQueryHistory() {
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from String");
        this.checkQueryMetrics((Query)qry);
    }

    @Test
    public void testSqlFieldsQueryHistoryNotFullyFetched() throws Exception {
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from String");
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((Query)qry, false);
    }

    @Test
    public void testSqlFieldsQueryHistoryFailed() {
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from String where fail()=1");
        this.checkQueryFailedMetrics((Query)qry);
    }

    @Test
    public void testQueryHistoryForDmlAndDdl() throws Exception {
        IgniteCacheProxy cache = this.queryNode().context().cache().jcache("A");
        List<String> cmds = Arrays.asList("create table TST(id int PRIMARY KEY, name varchar)", "insert into TST(id) values(1)", "commit");
        cmds.forEach(arg_0 -> SqlQueryHistorySelfTest.lambda$testQueryHistoryForDmlAndDdl$0((IgniteCache)cache, arg_0));
        this.checkSeriesCommand(cmds);
    }

    @Test
    public void testQueryHistoryEviction() throws Exception {
        IgniteCacheProxy cache = this.queryNode().context().cache().jcache("A");
        cache.query(new SqlFieldsQuery("select * from String")).getAll();
        cache.query(new SqlFieldsQuery("select count(*) from String")).getAll();
        cache.query(new SqlFieldsQuery("select * from String limit 1")).getAll();
        cache.query(new SqlFieldsQuery("select * from String limit 2")).getAll();
        cache.query((Query)new SqlQuery("String", "from String")).getAll();
        this.waitingFor("size", 3);
        for (int i = 0; i < 3; ++i) {
            this.checkMetrics(3, i, 1, 0, false);
        }
        Collection metrics = ((IgniteH2Indexing)this.queryNode().context().query().getIndexing()).runningQueryManager().queryHistoryMetrics().values();
        SqlQueryHistorySelfTest.assertEquals((int)3, (int)metrics.size());
        Set qries = metrics.stream().map(QueryHistory::query).collect(Collectors.toSet());
        SqlQueryHistorySelfTest.assertTrue((boolean)qries.contains("SELECT \"A\".\"STRING\"._KEY, \"A\".\"STRING\"._VAL from String"));
        SqlQueryHistorySelfTest.assertTrue((boolean)qries.contains("select * from String limit 2"));
        SqlQueryHistorySelfTest.assertTrue((boolean)qries.contains("select * from String limit 1"));
    }

    @Test
    public void testQueryHistoryMultithreaded() throws Exception {
        IgniteCacheProxy cache = this.queryNode().context().cache().jcache("A");
        ArrayList<Worker> workers = new ArrayList<Worker>();
        int repeat = 10;
        for (int k = 0; k < repeat; ++k) {
            for (int i = 1; i <= 3; ++i) {
                workers.add(new Worker((IgniteCache)cache, (Query)new SqlFieldsQuery("select * from String limit " + i)));
            }
        }
        for (Worker worker : workers) {
            worker.start();
        }
        for (Worker worker : workers) {
            worker.join();
        }
        for (int i = 0; i < 3; ++i) {
            this.checkMetrics(3, i, repeat, 0, false);
        }
    }

    @Test
    public void testScanQueryHistory() {
        ScanQuery qry = new ScanQuery();
        this.checkNoQueryMetrics((Query)qry);
    }

    @Test
    public void testSqlQueryHistory() {
        SqlQuery qry = new SqlQuery("String", "from String");
        this.checkQueryMetrics((Query)qry);
    }

    @Test
    public void testSqlQueryHistoryNotFullyFetched() throws Exception {
        SqlQuery qry = new SqlQuery("String", "from String");
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((Query)qry, true);
    }

    @Test
    public void testSqlQueryHistoryCheckQueryParamsDefaultValue() {
        IgniteCacheProxy cache = this.queryNode().context().cache().jcache("A");
        cache.query(new SqlFieldsQuery("select * from String")).getAll();
        this.checkQueryBooleanParams(false, false, this.activateLazyByDflt);
    }

    @Test
    public void testSqlQueryHistoryCheckQueryParams() {
        IgniteEx node = this.queryNode();
        IgniteCacheProxy cache = node.context().cache().jcache("A");
        cache.query(new SqlFieldsQuery("select * from String").setDistributedJoins(true).setEnforceJoinOrder(true).setLazy(true).setLocal(!node.localNode().isClient())).getAll();
        this.checkQueryBooleanParams(true, !node.localNode().isClient(), true);
    }

    @Test
    public void testTextQueryMetrics() {
        TextQuery qry = new TextQuery("String", "1");
        this.checkNoQueryMetrics((Query)qry);
    }

    @Test
    public void testTextQueryHistoryNotFullyFetched() throws Exception {
        TextQuery qry = new TextQuery("String", "1");
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((Query)qry, true);
    }

    @Test
    public void testSqlFieldsCrossCacheQueryHistory() {
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from \"B\".String");
        this.checkQueryMetrics((Query)qry);
    }

    @Test
    public void testSqlFieldsQueryHistoryCrossCacheQueryNotFullyFetched() throws Exception {
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from \"B\".String");
        qry.setPageSize(10);
        this.checkQueryNotFullyFetchedMetrics((Query)qry, false);
    }

    private void checkMetrics(int sz, int idx, int execs, int failures, boolean first) {
        Collection metrics = ((IgniteH2Indexing)this.queryNode().context().query().getIndexing()).runningQueryManager().queryHistoryMetrics().values();
        SqlQueryHistorySelfTest.assertNotNull(metrics);
        SqlQueryHistorySelfTest.assertEquals((int)sz, (int)metrics.size());
        if (sz == 0) {
            return;
        }
        QueryHistory m = (QueryHistory)new ArrayList(metrics).get(idx);
        this.info("Metrics: " + m);
        SqlQueryHistorySelfTest.assertEquals((String)"Executions", (long)execs, (long)m.executions());
        SqlQueryHistorySelfTest.assertEquals((String)"Failures", (long)failures, (long)m.failures());
        SqlQueryHistorySelfTest.assertTrue((m.maximumTime() >= 0L ? 1 : 0) != 0);
        SqlQueryHistorySelfTest.assertTrue((m.minimumTime() >= 0L ? 1 : 0) != 0);
        SqlQueryHistorySelfTest.assertTrue((m.lastStartTime() > 0L && m.lastStartTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
        if (first) {
            SqlQueryHistorySelfTest.assertEquals((String)"On first execution minTime == maxTime", (long)m.minimumTime(), (long)m.maximumTime());
        }
    }

    private void checkQueryMetrics(String qry) throws SQLException {
        this.runJdbcQuery(qry);
        this.checkMetrics(1, 0, 1, 0, true);
        this.runJdbcQuery(qry);
        this.checkMetrics(1, 0, 2, 0, false);
    }

    private void runJdbcQuery(String qry) throws SQLException {
        try (Connection conn = GridTestUtils.connect((IgniteEx)this.queryNode(), null);
             Statement stmt = conn.createStatement();){
            stmt.execute(qry);
        }
    }

    private void checkQueryBooleanParams(boolean exp, boolean loc, boolean lazy) {
        Collection metrics = ((IgniteH2Indexing)this.queryNode().context().query().getIndexing()).runningQueryManager().queryHistoryMetrics().values();
        SqlQueryHistorySelfTest.assertEquals((int)1, (int)metrics.size());
        QueryHistory hist = (QueryHistory)metrics.stream().findAny().get();
        SqlQueryHistorySelfTest.assertEquals((boolean)exp, (boolean)hist.distributedJoins());
        SqlQueryHistorySelfTest.assertEquals((boolean)exp, (boolean)hist.enforceJoinOrder());
        SqlQueryHistorySelfTest.assertEquals((boolean)loc, (boolean)hist.local());
        SqlQueryHistorySelfTest.assertEquals((boolean)lazy, (boolean)hist.lazy());
    }

    private void checkQueryMetrics(Query qry) {
        IgniteCacheProxy cache = this.queryNode().context().cache().jcache("A");
        cache.query(qry).getAll();
        this.checkMetrics(1, 0, 1, 0, true);
        cache.query(qry).getAll();
        this.checkMetrics(1, 0, 2, 0, false);
    }

    private void checkNoQueryMetrics(Query qry) {
        IgniteCacheProxy cache = this.queryNode().context().cache().jcache("A");
        cache.query(qry).getAll();
        this.checkMetrics(0, 0, 0, 0, true);
        cache.query(qry).getAll();
        this.checkMetrics(0, 0, 0, 0, false);
    }

    private void checkQueryNotFullyFetchedMetrics(Query qry, boolean waitingForCompletion) throws IgniteInterruptedCheckedException {
        IgniteCacheProxy cache = this.queryNode().context().cache().jcache("A");
        cache.query(qry).iterator().next();
        if (waitingForCompletion) {
            this.waitingFor("executions", 1);
        }
        this.checkMetrics(0, 0, 0, 0, true);
        cache.query(qry).iterator().next();
        if (waitingForCompletion) {
            this.waitingFor("executions", 2);
        }
        this.checkMetrics(0, 0, 0, 0, false);
    }

    private void checkQueryFailedMetrics(Query qry) {
        IgniteCacheProxy cache = this.queryNode().context().cache().jcache("A");
        try {
            cache.query(qry).getAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkMetrics(1, 0, 1, 1, true);
        try {
            cache.query(qry).getAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkMetrics(1, 0, 2, 2, false);
    }

    private void waitingFor(String cond, int exp) throws IgniteInterruptedCheckedException {
        GridTestUtils.waitForCondition(() -> {
            Collection metrics = ((IgniteH2Indexing)this.queryNode().context().query().getIndexing()).runningQueryManager().queryHistoryMetrics().values();
            switch (cond) {
                case "size": {
                    return metrics.size() == exp;
                }
                case "executions": {
                    int executions = 0;
                    for (QueryHistory m : metrics) {
                        executions = (int)((long)executions + m.executions());
                    }
                    return executions == exp;
                }
            }
            return true;
        }, (long)2000L);
    }

    protected IgniteEx queryNode() {
        IgniteEx node = this.grid(0);
        SqlQueryHistorySelfTest.assertFalse((boolean)node.context().clientNode());
        return node;
    }

    protected void startTestGrid() throws Exception {
        this.startGrids(2);
    }

    private static /* synthetic */ void lambda$testQueryHistoryForDmlAndDdl$0(IgniteCache cache, String cmd) {
        cache.query(new SqlFieldsQuery(cmd)).getAll();
    }

    private static class Worker
    extends Thread {
        private final IgniteCache cache;
        private final Query qry;

        Worker(IgniteCache cache, Query qry) {
            this.cache = cache;
            this.qry = qry;
        }

        @Override
        public void run() {
            this.cache.query(this.qry).getAll();
        }
    }

    public static class Functions {
        @QuerySqlFunction
        public static int fail() {
            throw new IgniteSQLException("SQL function fail for test purpuses");
        }
    }
}

