/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Iterator;
import java.util.List;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.junit.Test;

public class SqlLocalQueryConnectionAndStatementTest
extends AbstractIndexingCommonTest {
    public void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(1);
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicated() {
        this.sql("CREATE TABLE repl_tbl (id LONG PRIMARY KEY, val LONG) WITH \"template=replicated\"").getAll();
        try {
            for (int i = 0; i < 10; ++i) {
                this.sql("insert into repl_tbl(id,val) VALUES(" + i + "," + i + ")").getAll();
            }
            try (FieldsQueryCursor<List<?>> cur = this.sql(new SqlFieldsQuery("SELECT * FROM repl_tbl where id > ?").setArgs(new Object[]{1}));){
                Iterator it0 = cur.iterator();
                it0.next();
                this.sql(new SqlFieldsQuery("SELECT * FROM repl_tbl where id > ?").setArgs(new Object[]{1})).getAll();
                it0.next();
            }
        }
        finally {
            this.sql("DROP TABLE repl_tbl").getAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalQuery() {
        this.sql("CREATE TABLE tbl (id LONG PRIMARY KEY, val LONG)").getAll();
        try {
            for (int i = 0; i < 10; ++i) {
                this.sql("insert into tbl(id,val) VALUES(" + i + "," + i + ")").getAll();
            }
            try (FieldsQueryCursor<List<?>> cur = this.sql(new SqlFieldsQuery("SELECT * FROM tbl where id > ?").setArgs(new Object[]{1}).setLocal(true));){
                Iterator it0 = cur.iterator();
                it0.next();
                this.sql(new SqlFieldsQuery("SELECT * FROM tbl where id > ?").setArgs(new Object[]{1}).setLocal(true)).getAll();
                it0.next();
            }
        }
        finally {
            this.sql("DROP TABLE tbl").getAll();
        }
    }

    private FieldsQueryCursor<List<?>> sql(String sql) {
        return this.sql(new SqlFieldsQuery(sql));
    }

    private FieldsQueryCursor<List<?>> sql(SqlFieldsQuery qry) {
        GridQueryProcessor qryProc = this.grid(0).context().query();
        return qryProc.querySqlFields(qry, true);
    }
}

