/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.sql.SQLException;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.gridgain.internal.h2.value.Value;
import org.junit.Test;

public class IgniteSqlCustomFunctionTest
extends AbstractIndexingCommonTest {
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(2);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids(false);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setSqlFunctionClasses(new Class[]{CountSubqueryFunction.class});
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    @Test
    public void testFunctionAliasSupportsSubquery() throws Exception {
        IgniteCache cache = this.grid(0).cache("default");
        List rows = cache.query(new SqlFieldsQuery("SELECT COUNT_SUBQUERY(SELECT * FROM (SELECT * FROM VALUES (1), (2), (3)) as t limit 2)")).getAll();
        IgniteSqlCustomFunctionTest.assertEquals((int)1, (int)rows.size());
        IgniteSqlCustomFunctionTest.assertEquals((Object)2, ((List)rows.get(0)).get(0));
    }

    public static class CountSubqueryFunction {
        @QuerySqlFunction(alias="COUNT_SUBQUERY", deterministic=true)
        public static int countSubquery(Value ... values) throws SQLException {
            return values.length;
        }
    }
}

