/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Ignore;
import org.junit.Test;

public class HashJoinQueryTest
extends AbstractIndexingCommonTest {
    private static final int RIGHT_CNT = 100;
    private static final int MULT = 500;
    private static final int LEFT_CNT = 50000;

    protected void beforeTest() throws Exception {
        long i;
        super.beforeTest();
        this.startGrids(1);
        IgniteCache cacheA = this.grid(0).createCache(new CacheConfiguration().setName("A").setSqlSchema("TEST").setQueryEntities(Collections.singleton(new QueryEntity(Long.class.getTypeName(), "A_VAL").setTableName("A").addQueryField("ID", Long.class.getName(), null).addQueryField("JID", Long.class.getName(), null).addQueryField("VAL", Long.class.getName(), null).setKeyFieldName("ID"))));
        IgniteCache cacheB = this.grid(0).createCache(new CacheConfiguration().setCacheMode(CacheMode.REPLICATED).setName("B").setSqlSchema("TEST").setQueryEntities(Collections.singleton(new QueryEntity(Long.class.getName(), "B_VAL").setTableName("B").addQueryField("ID", Long.class.getName(), null).addQueryField("A_JID", Long.class.getName(), null).addQueryField("VAL0", String.class.getName(), null).setKeyFieldName("ID"))));
        IgniteCache cacheC = this.grid(0).createCache(new CacheConfiguration().setCacheMode(CacheMode.REPLICATED).setName("C").setSqlSchema("TEST").setQueryEntities(Collections.singleton(new QueryEntity(Long.class.getName(), "C_VAL").setTableName("C").addQueryField("ID", Long.class.getName(), null).addQueryField("A_JID", Long.class.getName(), null).addQueryField("VAL0", String.class.getName(), null).setKeyFieldName("ID"))));
        HashMap<Long, BinaryObject> batch = new HashMap<Long, BinaryObject>();
        for (i = 0L; i < 50000L; ++i) {
            batch.put(i, this.grid(0).binary().builder("A_VAL").setField("JID", (Object)(i % 100L)).setField("VAL", (Object)i).build());
            if (batch.size() <= 1000) continue;
            cacheA.putAll(batch);
            batch.clear();
        }
        if (batch.size() > 0) {
            cacheA.putAll(batch);
            batch.clear();
        }
        for (i = 0L; i < 100L; ++i) {
            cacheB.put((Object)i, (Object)this.grid(0).binary().builder("B_VAL").setField("A_JID", (Object)i).setField("VAL0", (Object)String.format("val%03d", i)).build());
        }
        for (i = 0L; i < 100L; ++i) {
            cacheC.put((Object)i, (Object)this.grid(0).binary().builder("C_VAL").setField("A_JID", (Object)i).setField("VAL0", (Object)String.format("val%03d", i)).build());
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-20800")
    public void testHashJoinPlanWithEnabledHashJoin() {
        GridTestUtils.setFieldValue(H2Utils.class, (String)"hashJoinMaxTableSize", (Object)1000);
        GridTestUtils.setFieldValue(H2Utils.class, (String)"enableHashJoin", (Object)true);
        try {
            this.assertPlanContains("HASH_JOIN_IDX [fillFromIndex=_key_PK_hash__SCAN_, hashedCols=[A_JID]]", true, "SELECT * FROM A, B USE INDEX(HASH_JOIN_IDX) WHERE A.JID = B.A_JID", new Object[0]);
            this.assertPlanContains("HASH_JOIN_IDX [fillFromIndex=_key_PK_hash__SCAN_, hashedCols=[A_JID]]", true, "SELECT * FROM A, B WHERE A.JID = B.A_JID", new Object[0]);
            this.sql(false, "CREATE INDEX IDX_B_JID ON B(A_JID)", new Object[0]);
            this.assertPlanContains("HASH_JOIN_IDX [fillFromIndex=_key_PK_hash__SCAN_, hashedCols=[A_JID]]", true, "SELECT * FROM A, B WHERE A.JID = B.A_JID", new Object[0]);
            this.assertPlanContains("HASH_JOIN_IDX [fillFromIndex=_key_PK_hash__SCAN_, hashedCols=[A_JID]]", false, "SELECT * FROM A, B WHERE A.JID = B.A_JID", new Object[0]);
            this.sql(false, "CREATE INDEX IDX_A_JID ON A(JID)", new Object[0]);
            this.assertPlanContains("HASH_JOIN_IDX [fillFromIndex=_key_PK_hash__SCAN_, hashedCols=[A_JID]]", true, "SELECT * FROM A, B WHERE A.JID = B.A_JID", new Object[0]);
            this.assertPlanDoesntContain("HASH_JOIN_IDX [fillFromIndex=_key_PK_hash__SCAN_, hashedCols=[A_JID]]", false, "SELECT * FROM A, B WHERE A.JID = B.A_JID", new Object[0]);
        }
        finally {
            this.sql(false, "DROP INDEX IF EXISTS IDX_B_JID", new Object[0]);
            this.sql(false, "DROP INDEX IF EXISTS IDX_A_JID", new Object[0]);
            GridTestUtils.setFieldValue(H2Utils.class, (String)"hashJoinMaxTableSize", (Object)100000);
            GridTestUtils.setFieldValue(H2Utils.class, (String)"enableHashJoin", (Object)false);
        }
    }

    @Test
    public void testHashJoin() {
        HashJoinQueryTest.assertEquals((int)50000, (int)this.sql(true, "SELECT * FROM A, B USE INDEX(HASH_JOIN_IDX) WHERE A.JID = B.A_JID", new Object[0]).getAll().size());
        HashJoinQueryTest.assertEquals((int)45000, (int)this.sql(true, "SELECT * FROM A, B USE INDEX(HASH_JOIN_IDX) WHERE A.JID = B.A_JID AND B.VAL0 > 'val009'", new Object[0]).getAll().size());
        HashJoinQueryTest.assertEquals((int)5000, (int)this.sql(true, "SELECT * FROM A, B USE INDEX(HASH_JOIN_IDX) WHERE A.JID = B.A_JID AND B.VAL0 > 'val009' and B.ID < 20", new Object[0]).getAll().size());
        HashJoinQueryTest.assertEquals((int)6000, (int)this.sql(true, "SELECT * FROM A, B USE INDEX(HASH_JOIN_IDX) WHERE A.JID = B.A_JID AND B.VAL0 >= 'val009' AND B.ID <= 20", new Object[0]).getAll().size());
        HashJoinQueryTest.assertEquals((int)500, (int)this.sql(true, "SELECT * FROM A, B USE INDEX(HASH_JOIN_IDX) WHERE A.JID = B.A_JID AND B.VAL0 = 'val009'", new Object[0]).getAll().size());
        HashJoinQueryTest.assertEquals((int)500, (int)this.sql(true, "SELECT * FROM A, B USE INDEX(HASH_JOIN_IDX) WHERE A.JID = B.A_JID AND B.VAL0 = 'val009'", new Object[0]).getAll().size());
    }

    @Test
    public void testSimpleBenchmarkJoinTwoTables() {
        long tHashJoin = this.sqlDuration(true, 10, "SELECT * FROM A, B USE INDEX(HASH_JOIN_IDX) WHERE A.JID = B.A_JID", new Object[0]);
        long tNestedLoops = this.sqlDuration(false, 3, "SELECT * FROM A USE INDEX(\"_key_PK__SCAN_\"), B USE INDEX(\"_key_PK__SCAN_\")WHERE A.JID = B.A_JID", new Object[0]);
        HashJoinQueryTest.assertTrue((String)("Hash join is slow than nested loops: [HJ time=" + tHashJoin + ", NL time=" + tNestedLoops + ']'), (tNestedLoops > tHashJoin ? 1 : 0) != 0);
        log.info("Query duration: [HJ time=" + tHashJoin + ", NL time=" + tNestedLoops + ']');
    }

    @Test
    public void testSimpleBenchmarkJoinThreeTables() {
        long tHashJoin = this.sqlDuration(true, 10, "SELECT * FROM A, B USE INDEX(HASH_JOIN_IDX), C USE INDEX(HASH_JOIN_IDX) WHERE A.JID = B.A_JID AND A.JID=C.A_JID", new Object[0]);
        long tNestedLoops = this.sqlDuration(false, 1, "SELECT * FROM A, B USE INDEX(\"_key_PK__SCAN_\"), C USE INDEX(\"_key_PK__SCAN_\") WHERE A.JID = B.A_JID AND A.JID=C.A_JID", new Object[0]);
        HashJoinQueryTest.assertTrue((String)("Hash join is slow than nested loops: [HJ time=" + tHashJoin + ", NL time=" + tNestedLoops + ']'), (tNestedLoops > tHashJoin ? 1 : 0) != 0);
        log.info("Query duration: [HJ time=" + tHashJoin + ", NL time=" + tNestedLoops + ']');
    }

    @Test
    public void testHashJoinMaxTableSizeLimit() {
        GridTestUtils.setFieldValue(H2Utils.class, (String)"hashJoinMaxTableSize", (Object)10);
        try {
            this.assertPlanDoesntContain("HASH_JOIN_IDX [fillFromIndex=", true, "SELECT * FROM A, B USE INDEX(HASH_JOIN_IDX) WHERE A.JID = B.A_JID", new Object[0]);
        }
        finally {
            GridTestUtils.setFieldValue(H2Utils.class, (String)"hashJoinMaxTableSize", (Object)100000);
        }
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-20800")
    public void testDisableHashJoin() {
        this.assertPlanDoesntContain("HASH_JOIN_IDX [fillFromIndex=_key_PK_hash__SCAN_, hashedCols=[A_JID]]", false, "SELECT * FROM A, B WHERE A.JID = B.A_JID", new Object[0]);
        this.assertPlanContains("HASH_JOIN_IDX [fillFromIndex=_key_PK_hash__SCAN_, hashedCols=[A_JID]]", false, "SELECT * FROM A, B USE INDEX (HASH_JOIN_IDX) WHERE A.JID = B.A_JID", new Object[0]);
    }

    public long sqlDuration(boolean enforceJoinOrder, int count, String sql, Object ... args) {
        long t0 = U.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            Iterator it = this.sql(enforceJoinOrder, sql, new Object[0]).iterator();
            while (it.hasNext()) {
                it.next();
            }
        }
        return (U.currentTimeMillis() - t0) / (long)count;
    }

    private FieldsQueryCursor<List<?>> sql(boolean enforceJoinOrder, String sql, Object ... args) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(sql).setSchema("TEST").setLazy(true).setEnforceJoinOrder(enforceJoinOrder).setArgs(args), false);
    }

    private String plan(boolean enforceJoinOrder, String sql, Object ... args) {
        return this.sql(enforceJoinOrder, "EXPLAIN " + sql, args).getAll().toString();
    }

    private void assertPlanContains(String expected, boolean enforceJoinOrder, String sql, Object ... args) {
        String plan = this.plan(enforceJoinOrder, sql, args);
        HashJoinQueryTest.assertTrue((String)("Unexpected plan: " + plan), (boolean)plan.contains(expected));
    }

    private void assertPlanDoesntContain(String unexpected, boolean enforceJoinOrder, String sql, Object ... args) {
        String plan = this.plan(enforceJoinOrder, sql, args);
        HashJoinQueryTest.assertFalse((String)("Unexpected plan: " + plan), (boolean)plan.contains(unexpected));
    }
}

