/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.database;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.maintenance.RebuildIndexAction;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.verify.ValidateIndexesClosure;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class RebuildIndexTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache_name";
    private ListeningTestLogger srvLog;
    private static final Pattern idxRebuildPattert = Pattern.compile("Details for cache rebuilding \\[name=cache_name, grpName=null].*Scanned rows 2, visited types \\[UserValue].*Type name=UserValue.*Index: name=_key_PK, size=2.*Index: name=IDX_2, size=2.*Index: name=IDX_1, size=2.*", 32);

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setConsistentId((Serializable)((Object)gridName));
        cfg.setGridLogger(log);
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("account", "java.lang.Integer");
        fields.put("balance", "java.lang.Integer");
        QueryEntity qryEntity0 = new QueryEntity().setTableName("TABLE_0").setKeyType(UserKey.class.getName()).setValueType(UserValue.class.getName()).setKeyFields(new HashSet<String>(Arrays.asList("account"))).setFields(fields);
        QueryEntity qryEntity1 = new QueryEntity().setTableName("TABLE_1").setKeyType(UserKey.class.getName()).setValueType(UserValue0.class.getName()).setKeyFields(new HashSet<String>(Arrays.asList("account"))).setFields(fields);
        LinkedHashMap<String, Boolean> idxFields = new LinkedHashMap<String, Boolean>();
        idxFields.put("account", false);
        idxFields.put("balance", false);
        QueryIndex idx1 = new QueryIndex(idxFields, QueryIndexType.SORTED).setName("IDX_1");
        QueryIndex idx2 = new QueryIndex("balance", QueryIndexType.SORTED, false, "IDX_2");
        QueryIndex idx3 = new QueryIndex(idxFields, QueryIndexType.SORTED).setName("IDX_3");
        QueryIndex idx4 = new QueryIndex("balance", QueryIndexType.SORTED, false, "IDX_4");
        qryEntity0.setIndexes(Arrays.asList(idx1, idx2));
        qryEntity1.setIndexes(Arrays.asList(idx3, idx4));
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName(CACHE_NAME).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.REPLICATED).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1)).setQueryEntities(Arrays.asList(qryEntity0, qryEntity1))});
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setCheckpointFrequency(10000000L).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        if (this.srvLog != null) {
            cfg.setGridLogger((IgniteLogger)this.srvLog);
        }
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.srvLog = null;
    }

    @Test
    @WithSystemProperty(key="IGNITE_ENABLE_EXTRA_INDEX_REBUILD_LOGGING", value="true")
    public void testRebuildIndexWithLogging() throws Exception {
        this.check(true);
    }

    @Test
    @WithSystemProperty(key="IGNITE_ENABLE_EXTRA_INDEX_REBUILD_LOGGING", value="false")
    public void testRebuildIndexWithoutLogging() throws Exception {
        this.check(false);
    }

    @Test
    public void testFindIndex() throws Exception {
        IgniteEx node = this.startGrid(0);
        node.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = node.getOrCreateCache(CACHE_NAME);
        cache.put((Object)new UserKey(1), (Object)new UserValue(333));
        cache.put((Object)new UserKey(2), (Object)new UserValue(555));
        this.checkFindIndex(node, CACHE_NAME, "TABLE_0", "IDX_1");
        this.checkFindIndex(node, CACHE_NAME, "TABLE_0", "IDX_2");
        this.checkFindIndex(node, CACHE_NAME, "TABLE_1", "IDX_3");
        this.checkFindIndex(node, CACHE_NAME, "TABLE_1", "IDX_4");
        this.checkMissingIndex(node, "IDX_5");
    }

    private void checkFindIndex(IgniteEx n, String cacheName, String tableName, String idxName) {
        IgniteH2Indexing indexing = (IgniteH2Indexing)n.context().query().getIndexing();
        H2TreeIndex idx = RebuildIndexAction.findIndex((String)CACHE_NAME, (String)idxName, (SchemaManager)indexing.schemaManager());
        RebuildIndexTest.assertEquals((String)cacheName, (String)idx.getTable().cacheName());
        RebuildIndexTest.assertEquals((String)tableName, (String)idx.getTable().getName());
        RebuildIndexTest.assertEquals((String)idxName, (String)idx.getIndexName());
    }

    private void checkMissingIndex(IgniteEx n, String idxName) {
        IgniteH2Indexing indexing = (IgniteH2Indexing)n.context().query().getIndexing();
        RebuildIndexTest.assertNull((Object)RebuildIndexAction.findIndex((String)CACHE_NAME, (String)idxName, (SchemaManager)indexing.schemaManager()));
    }

    private void check(boolean msgFound) throws Exception {
        this.srvLog = new ListeningTestLogger(false, log);
        LogListener idxRebuildLsnr = LogListener.matches((Pattern)idxRebuildPattert).build();
        this.srvLog.registerListener(idxRebuildLsnr);
        IgniteEx node = this.startGrids(2);
        node.cluster().active(true);
        IgniteCache cache = node.getOrCreateCache(CACHE_NAME);
        cache.put((Object)new UserKey(1), (Object)new UserValue(333));
        cache.put((Object)new UserKey(2), (Object)new UserValue(555));
        this.stopGrid(0);
        this.removeIndexBin(0);
        node = this.startGrid(0);
        this.awaitPartitionMapExchange();
        this.forceCheckpoint();
        this.enableCheckpoints(G.allGrids(), false);
        ValidateIndexesClosure clo = new ValidateIndexesClosure(() -> false, Collections.singleton(CACHE_NAME), 0, 0, false, true);
        node.context().resource().injectGeneric((Object)clo);
        RebuildIndexTest.assertFalse((boolean)clo.call().hasIssues());
        RebuildIndexTest.assertEquals((boolean)msgFound, (boolean)idxRebuildLsnr.check());
    }

    private void removeIndexBin(int nodeId) throws IgniteCheckedException {
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)("db/" + U.maskForFileName((CharSequence)this.getTestIgniteInstanceName(nodeId)) + "/cache-" + CACHE_NAME + "/" + "index.bin"), (boolean)false));
    }

    private static class UserValue0 {
        private int balance;

        public UserValue0(int balance) {
            this.balance = balance;
        }
    }

    private static class UserValue {
        private int balance;

        public UserValue(int balance) {
            this.balance = balance;
        }
    }

    private static class UserKey {
        private int account;

        public UserKey(int a) {
            this.account = a;
        }
    }
}

