/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.db;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.localtask.DurableBackgroundTaskState;
import org.apache.ignite.internal.processors.localtask.DurableBackgroundTasksProcessor;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_PDS_SKIP_CHECKPOINT_ON_NODE_STOP", value="true")
public class DestroyIndexWithoutCheckpointTest
extends GridCommonAbstractTest {
    private final ListeningTestLogger listeningLog = new ListeningTestLogger(log);

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration configuration = super.getConfiguration(gridName);
        DataStorageConfiguration cfg = new DataStorageConfiguration();
        cfg.setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true));
        configuration.setDataStorageConfiguration(cfg);
        configuration.setGridLogger((IgniteLogger)this.listeningLog);
        return configuration;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    static String tableName(String cacheName) {
        return cacheName + "_table";
    }

    static String createTable(String cacheName, boolean multipleSegments) {
        return "CREATE TABLE IF NOT EXISTS " + DestroyIndexWithoutCheckpointTest.tableName(cacheName) + " (\n    ID VARCHAR NOT NULL,\n    NAME VARCHAR NOT NULL,\n    PRIMARY KEY (ID)\n)\nWITH \"\n    CACHE_NAME=" + cacheName + "\n" + (multipleSegments ? ",PARALLELISM=2" : "") + "\";";
    }

    static String insertQuery(String cacheName) {
        return "INSERT INTO " + DestroyIndexWithoutCheckpointTest.tableName(cacheName) + "(ID, NAME) VALUES(?, ?)";
    }

    static SqlFieldsQuery insertQuery(String cacheName, int id) {
        return new SqlFieldsQuery(DestroyIndexWithoutCheckpointTest.insertQuery(cacheName)).setArgs(new Object[]{id, "name-" + id});
    }

    @Test
    public void testMultipleSegments() throws Exception {
        this.test(true);
    }

    @Test
    public void test() throws Exception {
        this.test(false);
    }

    private void test(boolean multipleSegments) throws Exception {
        LogListener lsnrBackgroundFailure = LogListener.matches((String)"Could not execute durable background task: drop-sql-index-test-").times(0).build();
        LogListener lsnrConcurrentDestruction = LogListener.matches((String)"Tree is being concurrently destroyed").times(0).build();
        this.listeningLog.registerListener(lsnrBackgroundFailure);
        this.listeningLog.registerListener(lsnrConcurrentDestruction);
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteCache queryCache = ignite.getOrCreateCache("queryCache");
        String cacheName = "test";
        IgniteCache cache = ignite.getOrCreateCache(cacheName);
        cache.put((Object)1, (Object)1);
        queryCache.query(new SqlFieldsQuery(DestroyIndexWithoutCheckpointTest.createTable(cacheName, multipleSegments))).getAll();
        queryCache.query(DestroyIndexWithoutCheckpointTest.insertQuery("test", 100)).getAll();
        this.stopGrid(0, true);
        ignite = this.startGrid(0);
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteEx finalIgnite = ignite;
        DestroyIndexWithoutCheckpointTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            Collection<DurableBackgroundTaskState<?>> tasks = this.tasks(finalIgnite.context().durableBackgroundTask()).values();
            return tasks.stream().allMatch(state -> state.state() == DurableBackgroundTaskState.State.COMPLETED);
        }, (long)TimeUnit.SECONDS.toMillis(5L)));
        DestroyIndexWithoutCheckpointTest.assertTrue((boolean)lsnrBackgroundFailure.check());
        DestroyIndexWithoutCheckpointTest.assertTrue((boolean)lsnrConcurrentDestruction.check());
    }

    private Map<String, DurableBackgroundTaskState<?>> tasks(DurableBackgroundTasksProcessor proc) {
        return (Map)GridTestUtils.getFieldValue((Object)proc, (String[])new String[]{"tasks"});
    }
}

