/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccSqlTxQueriesAbstractTest;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.MvccFeatureChecker;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionDuplicateKeyException;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;

public abstract class CacheMvccSqlTxQueriesWithReducerAbstractTest
extends CacheMvccAbstractTest {
    private static final int TIMEOUT = 3000;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        return super.getConfiguration(gridName).setTransactionConfiguration(new TransactionConfiguration().setDeadlockTimeout(0L));
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.ccfgs = null;
        this.ccfg = null;
    }

    @Test
    public void testQueryReducerInsert() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)2, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)3, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3)));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            String sqlText = "INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) SELECT DISTINCT _key + 3, idxVal1 + 3 FROM MvccTestSqlIndexValue";
            SqlFieldsQuery qry = new SqlFieldsQuery(sqlText);
            qry.setDistributedJoins(true);
            IgniteCache cache0 = updateNode.cache("default");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(4), (Object)cache.get((Object)4));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(5), (Object)cache.get((Object)5));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(6), (Object)cache.get((Object)6));
    }

    @Test
    public void testQueryReducerInsertDuplicateKey() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)2, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)3, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3)));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            String sqlText = "INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) SELECT DISTINCT _key, idxVal1 FROM MvccTestSqlIndexValue";
            final SqlFieldsQuery qry = new SqlFieldsQuery(sqlText);
            qry.setDistributedJoins(true);
            final IgniteCache cache0 = updateNode.cache("default");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    return cache0.query(qry);
                }
            }, TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
            tx.rollback();
        }
    }

    @Test
    public void testQueryReducerMerge() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)2, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)3, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3)));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            String sqlText = "MERGE INTO MvccTestSqlIndexValue (_key, idxVal1) SELECT DISTINCT _key * 2, idxVal1 FROM MvccTestSqlIndexValue";
            SqlFieldsQuery qry = new SqlFieldsQuery(sqlText);
            qry.setDistributedJoins(true);
            IgniteCache cache0 = updateNode.cache("default");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)cache.get((Object)4));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), (Object)cache.get((Object)6));
    }

    @Test
    public void testQueryReducerMultiBatchPerNodeServer() throws Exception {
        this.checkMultiBatchPerNode(false);
    }

    @Test
    public void testQueryReducerMultiBatchPerNodeClient() throws Exception {
        this.checkMultiBatchPerNode(true);
    }

    private void checkMultiBatchPerNode(boolean client) throws Exception {
        IgniteEx checkNode;
        IgniteEx updateNode;
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class});
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        if (client) {
            this.startGridsMultiThreaded(3);
            updateNode = this.grid(((Random)rnd).nextInt(3));
            this.client = true;
            checkNode = this.startGrid(4);
        } else {
            this.startGridsMultiThreaded(4);
            checkNode = this.grid(((Random)rnd).nextInt(4));
            updateNode = this.grid(((Random)rnd).nextInt(4));
        }
        IgniteCache cache = checkNode.cache("default");
        int count = 6;
        HashMap<Integer, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue> vals = new HashMap<Integer, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue>(6);
        for (int idx = 1; idx <= 6; ++idx) {
            vals.put(idx, new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(idx));
        }
        cache.putAll(vals);
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            String sqlText = "INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) SELECT DISTINCT _key + 6, idxVal1 + 6 FROM MvccTestSqlIndexValue";
            SqlFieldsQuery qry = new SqlFieldsQuery(sqlText);
            qry.setDistributedJoins(true);
            qry.setPageSize(1);
            IgniteCache cache0 = updateNode.cache("default");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)6L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
    }

    @Test
    public void testQueryReducerDelete() throws Exception {
        this.ccfgs = new CacheConfiguration[]{this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setName("int").setIndexedTypes(new Class[]{Integer.class, Integer.class}), this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class})};
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("int");
        cache.putAll(F.asMap((Object)1, (Object)1, (Object)3, (Object)3, (Object)5, (Object)5));
        int count = 6;
        HashMap<Integer, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue> vals = new HashMap<Integer, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue>(6);
        for (int idx = 1; idx <= 6; ++idx) {
            vals.put(idx, new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(idx));
        }
        IgniteCache cache0 = updateNode.cache("default");
        cache0.putAll(vals);
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            String sqlText = "DELETE FROM MvccTestSqlIndexValue t WHERE EXISTS (SELECT 1 FROM \"int\".Integer WHERE t._key = _key)";
            SqlFieldsQuery qry = new SqlFieldsQuery(sqlText);
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
    }

    @Test
    public void testQueryReducerUpdate() throws Exception {
        this.ccfgs = new CacheConfiguration[]{this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setName("int").setIndexedTypes(new Class[]{Integer.class, Integer.class}), this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class})};
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("int");
        cache.putAll(F.asMap((Object)1, (Object)5, (Object)3, (Object)1, (Object)5, (Object)3));
        int count = 6;
        HashMap<Integer, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue> vals = new HashMap<Integer, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue>(6);
        for (int idx = 1; idx <= 6; ++idx) {
            vals.put(idx, new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(idx));
        }
        IgniteCache cache0 = updateNode.cache("default");
        cache0.putAll(vals);
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            String sqlText = "UPDATE MvccTestSqlIndexValue t SET idxVal1=(SELECT _val FROM \"int\".Integer WHERE t._key = _key) WHERE EXISTS (SELECT 1 FROM \"int\".Integer WHERE t._key = _key)";
            SqlFieldsQuery qry = new SqlFieldsQuery(sqlText);
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            tx.commit();
        }
    }

    @Test
    public void testQueryReducerImplicitTxInsert() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)2, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)3, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3)));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
        String sqlText = "INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) SELECT DISTINCT _key + 3, idxVal1 + 3 FROM MvccTestSqlIndexValue";
        SqlFieldsQuery qry = new SqlFieldsQuery(sqlText);
        qry.setTimeout(3000, TimeUnit.MILLISECONDS);
        qry.setDistributedJoins(true);
        IgniteCache cache0 = updateNode.cache("default");
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(4), (Object)cache.get((Object)4));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(5), (Object)cache.get((Object)5));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(6), (Object)cache.get((Object)6));
    }

    @Test
    public void testQueryReducerRollbackInsert() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)2, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)3, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3)));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
        try (Transaction tx = updateNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(3000L);
            String sqlText = "INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) SELECT DISTINCT _key + 3, idxVal1 + 3 FROM MvccTestSqlIndexValue";
            SqlFieldsQuery qry = new SqlFieldsQuery(sqlText);
            qry.setDistributedJoins(true);
            IgniteCache cache0 = updateNode.cache("default");
            try (FieldsQueryCursor cur = cache0.query(qry);){
                CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
            }
            tx.rollback();
        }
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), this.sqlGet(1, cache).get(0).get(0));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), this.sqlGet(2, cache).get(0).get(0));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), this.sqlGet(3, cache).get(0).get(0));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertTrue((boolean)this.sqlGet(4, cache).isEmpty());
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertTrue((boolean)this.sqlGet(5, cache).isEmpty());
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertTrue((boolean)this.sqlGet(6, cache).isEmpty());
    }

    private List<List> sqlGet(int key, IgniteCache cache) {
        return cache.query(new SqlFieldsQuery("SELECT _val from MvccTestSqlIndexValue WHERE _key=" + key)).getAll();
    }

    @Test
    public void testQueryReducerDeadlockInsertWithTxTimeout() throws Exception {
        this.checkQueryReducerDeadlockInsert(TimeoutMode.TX);
    }

    @Test
    public void testQueryReducerDeadlockInsertWithStmtTimeout() throws Exception {
        this.checkQueryReducerDeadlockInsert(TimeoutMode.STMT);
    }

    public void checkQueryReducerDeadlockInsert(final TimeoutMode timeoutMode) throws Exception {
        this.ccfgs = new CacheConfiguration[]{this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setName("int").setIndexedTypes(new Class[]{Integer.class, Integer.class}), this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class})};
        this.startGridsMultiThreaded(2);
        this.client = true;
        this.startGridsMultiThreaded(2, 2);
        IgniteEx checkNode = this.grid(2);
        IgniteCache cache = checkNode.cache("int");
        HashMap<Integer, Integer> vals = new HashMap<Integer, Integer>(100);
        for (int idx = 0; idx < 100; ++idx) {
            vals.put(idx, idx);
        }
        cache.putAll(vals);
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final AtomicInteger idx = new AtomicInteger(2);
        final AtomicReference ex = new AtomicReference();
        this.multithreaded(new Runnable(){

            @Override
            public void run() {
                int id = idx.getAndIncrement();
                IgniteEx node = CacheMvccSqlTxQueriesWithReducerAbstractTest.this.grid(id);
                try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    if (timeoutMode == TimeoutMode.TX) {
                        tx.timeout(3000L);
                    }
                    String sqlText = "INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) SELECT DISTINCT _key, _val FROM \"int\".Integer ORDER BY _key";
                    String sqlAsc = sqlText + " ASC";
                    String sqlDesc = sqlText + " DESC";
                    SqlFieldsQuery qry = new SqlFieldsQuery(id % 2 == 0 ? sqlAsc : sqlDesc);
                    if (timeoutMode == TimeoutMode.STMT) {
                        qry.setTimeout(3000, TimeUnit.MILLISECONDS);
                    }
                    IgniteCache cache0 = node.cache("default");
                    cache0.query(qry).getAll();
                    barrier.await();
                    qry = new SqlFieldsQuery(id % 2 == 0 ? sqlDesc : sqlAsc);
                    if (timeoutMode == TimeoutMode.STMT) {
                        qry.setTimeout(3000, TimeUnit.MILLISECONDS);
                    }
                    cache0.query(qry).getAll();
                    tx.commit();
                }
                catch (Exception e) {
                    CacheMvccSqlTxQueriesWithReducerAbstractTest.this.onException(ex, e);
                }
            }
        }, 2);
        Exception ex0 = (Exception)ex.get();
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertNotNull((Object)ex0);
        GridTestUtils.assertThrowsWithCause(() -> {
            throw ex0;
        }, IgniteTxTimeoutCheckedException.class);
    }

    @Test
    public void testQueryReducerInsertVersionConflict() throws Exception {
        this.ccfgs = new CacheConfiguration[]{this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setName("int").setIndexedTypes(new Class[]{Integer.class, Integer.class}), this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class})};
        this.startGridsMultiThreaded(2);
        this.client = true;
        IgniteEx checkNode = this.startGrid(2);
        IgniteCache cache = checkNode.cache("int");
        HashMap<Integer, Integer> vals = new HashMap<Integer, Integer>(100);
        for (int idx = 0; idx < 10; ++idx) {
            vals.put(idx, idx);
        }
        cache.putAll(vals);
        this.awaitPartitionMapExchange();
        IgniteCache cache0 = checkNode.cache("default");
        cache0.query(new SqlFieldsQuery("INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) SELECT _key, _val FROM \"int\".Integer")).getAll();
        CyclicBarrier barrier = new CyclicBarrier(2);
        AtomicReference ex = new AtomicReference();
        GridTestUtils.runMultiThreaded((Runnable)new Runnable((Ignite)checkNode, barrier, cache0, ex){
            final /* synthetic */ Ignite val$checkNode;
            final /* synthetic */ CyclicBarrier val$barrier;
            final /* synthetic */ IgniteCache val$cache0;
            final /* synthetic */ AtomicReference val$ex;
            {
                this.val$checkNode = ignite;
                this.val$barrier = cyclicBarrier;
                this.val$cache0 = igniteCache;
                this.val$ex = atomicReference;
            }

            @Override
            public void run() {
                try (Transaction tx = this.val$checkNode.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    tx.timeout(3000L);
                    this.val$barrier.await();
                    SqlFieldsQuery qry = new SqlFieldsQuery("SELECT * FROM MvccTestSqlIndexValue");
                    this.val$cache0.query(qry).getAll();
                    this.val$barrier.await();
                    String sqlText = "UPDATE MvccTestSqlIndexValue t SET idxVal1=(SELECT _val FROM \"int\".Integer WHERE _key >= 5 AND _key <= 5 ORDER BY _key) WHERE _key = 5";
                    qry = new SqlFieldsQuery(sqlText);
                    this.val$cache0.query(qry).getAll();
                    tx.commit();
                }
                catch (Exception e) {
                    CacheMvccSqlTxQueriesWithReducerAbstractTest.this.onException(this.val$ex, e);
                }
            }
        }, (int)2, (String)"tx-thread");
        MvccFeatureChecker.assertMvccWriteConflict((Exception)((Exception)ex.get()));
    }

    @Test
    public void testQueryReducerInsertValues() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx node = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = node.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) values (1,?),(2,?),(3,?)");
        qry.setArgs(new Object[]{1, 2, 3});
        try (FieldsQueryCursor cur = cache.query(qry);){
            CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
        qry = new SqlFieldsQuery("INSERT INTO MvccTestSqlIndexValue (_key, idxVal1) values (4,4)");
        cur = cache.query(qry);
        var6_6 = null;
        try {
            CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (cur != null) {
                if (var6_6 != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    cur.close();
                }
            }
        }
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(4), (Object)cache.get((Object)4));
    }

    @Test
    public void testQueryReducerMergeValues() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx node = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = node.cache("default");
        cache.put((Object)1, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1));
        cache.put((Object)3, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3));
        SqlFieldsQuery qry = new SqlFieldsQuery("MERGE INTO MvccTestSqlIndexValue (_key, idxVal1) values (1,?),(2,?),(3,?)");
        qry.setArgs(new Object[]{1, 4, 6});
        try (FieldsQueryCursor cur = cache.query(qry);){
            CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)3L, ((List)cur.iterator().next()).get(0));
        }
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(4), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(6), (Object)cache.get((Object)3));
        qry = new SqlFieldsQuery("MERGE INTO MvccTestSqlIndexValue (_key, idxVal1) values (4,4)");
        cur = cache.query(qry);
        var6_6 = null;
        try {
            CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (cur != null) {
                if (var6_6 != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    cur.close();
                }
            }
        }
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(4), (Object)cache.get((Object)4));
    }

    @Test
    public void testQueryReducerFastUpdate() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)3));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)1, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)2, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
        IgniteCache cache0 = updateNode.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("UPDATE Integer SET _val = 8 WHERE _key = ?").setArgs(new Object[]{1});
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
        }
        qry = new SqlFieldsQuery("UPDATE Integer SET _val = 9 WHERE _key = 2");
        cur = cache0.query(qry);
        var8_8 = null;
        try {
            CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (cur != null) {
                if (var8_8 != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    cur.close();
                }
            }
        }
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)8, (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)9, (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)3, (Object)cache.get((Object)3));
    }

    @Test
    public void testQueryReducerFastDelete() throws Exception {
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 1024).setIndexedTypes(new Class[]{Integer.class, CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue.class});
        this.startGridsMultiThreaded(4);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteEx checkNode = this.grid(((Random)rnd).nextInt(4));
        IgniteEx updateNode = this.grid(((Random)rnd).nextInt(4));
        IgniteCache cache = checkNode.cache("default");
        cache.putAll(F.asMap((Object)1, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)2, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)3, (Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3)));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(1), (Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(2), (Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
        IgniteCache cache0 = updateNode.cache("default");
        SqlFieldsQuery qry = new SqlFieldsQuery("DELETE FROM MvccTestSqlIndexValue WHERE _key = ?").setArgs(new Object[]{1});
        try (FieldsQueryCursor cur = cache0.query(qry);){
            CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
        }
        qry = new SqlFieldsQuery("DELETE FROM MvccTestSqlIndexValue WHERE _key = 2");
        cur = cache0.query(qry);
        var8_8 = null;
        try {
            CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)1L, ((List)cur.iterator().next()).get(0));
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (cur != null) {
                if (var8_8 != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    cur.close();
                }
            }
        }
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertNull((Object)cache.get((Object)1));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertNull((Object)cache.get((Object)2));
        CacheMvccSqlTxQueriesWithReducerAbstractTest.assertEquals((Object)new CacheMvccSqlTxQueriesAbstractTest.MvccTestSqlIndexValue(3), (Object)cache.get((Object)3));
    }

    private void onException(AtomicReference<Exception> ex, Exception e) {
        if (!ex.compareAndSet(null, e)) {
            ex.get().addSuppressed(e);
        }
    }

    private static enum TimeoutMode {
        TX,
        STMT;

    }
}

