/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CacheMvccSelectForUpdateQueryBasicTest
extends CacheMvccAbstractTest {
    private static final int CACHE_SIZE = 100;
    private static Random RAND = new Random();
    @Parameterized.Parameter(value=0)
    public CacheMode cacheMode;
    @Parameterized.Parameter(value=1)
    public int backups;
    @Parameterized.Parameter(value=2)
    public boolean fromClient;
    @Parameterized.Parameter(value=3)
    public boolean segmented;

    @Parameterized.Parameters(name="cacheMode={0}, backups={1}, fromClient={2}, segmented={3}")
    public static Collection parameters() {
        return Arrays.asList({CacheMode.REPLICATED, 0, true, false}, {CacheMode.REPLICATED, 0, false, false}, {CacheMode.PARTITIONED, 0, true, false}, {CacheMode.PARTITIONED, 0, false, true}, {CacheMode.PARTITIONED, 1, true, true}, {CacheMode.PARTITIONED, 1, false, false}, {CacheMode.PARTITIONED, 2, true, false});
    }

    protected CacheMode cacheMode() {
        return null;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.startGridsMultiThreaded(3);
        this.client = true;
        this.startGrid(3);
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        super.afterTest();
    }

    public void afterTest() throws Exception {
        this.verifyOldVersionsCleaned();
        this.verifyCoordinatorInternalState();
        this.grid(3).destroyCache("SQL_PUBLIC_PERSON");
    }

    public void beforeTest() throws Exception {
        IgniteEx client = this.grid(3);
        CacheConfiguration dummyCfg = new CacheConfiguration("dummy").setSqlSchema("PUBLIC").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        client.getOrCreateCache(dummyCfg);
        String templateName = String.valueOf(this.cacheMode) + this.backups + this.fromClient + this.segmented;
        CacheConfiguration ccfg = new CacheConfiguration(templateName);
        ccfg.setCacheMode(this.cacheMode);
        ccfg.setBackups(this.backups);
        if (this.segmented) {
            ccfg.setQueryParallelism(4);
        }
        client.addCacheConfiguration(ccfg);
        this.runSql((Ignite)client, "CREATE TABLE person (id INT PRIMARY KEY, name VARCHAR, salary INT) WITH \"ATOMICITY=TRANSACTIONAL_SNAPSHOT, TEMPLATE=" + templateName + "\"", false, new Object[0]);
        this.runSql((Ignite)client, "CREATE INDEX salaryIdx ON person(salary)", false, new Object[0]);
        for (int i = 0; i < 100; ++i) {
            this.runSql((Ignite)client, "INSERT INTO person (id, name, salary) VALUES (" + i + ", 'name" + i + "', " + i * 10 + ")", false, new Object[0]);
        }
    }

    @Test
    public void testSingleLock() throws Exception {
        int key;
        List r;
        Iterator iterator;
        ArrayList<Integer> keys;
        Object res2;
        Ignite node = this.getNode();
        String sql = "SELECT id, name FROM person WHERE salary = 100";
        String sqlForUpdate = sql + " FOR UPDATE";
        Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        Object object = null;
        try {
            res2 = this.runSql(node, sqlForUpdate, false, new Object[0]).getAll();
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)1, (int)res2.size());
            keys = new ArrayList<Integer>();
            iterator = res2.iterator();
            while (iterator.hasNext()) {
                r = (List)iterator.next();
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r.size());
                key = (Integer)r.get(0);
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)10, (int)key);
                keys.add(key);
            }
            this.checkLocks(keys);
            tx.commit();
        }
        catch (Throwable res2) {
            object = res2;
            throw res2;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable res2) {
                        ((Throwable)object).addSuppressed(res2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkLocks(Collections.emptyList());
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        object = null;
        try {
            res2 = this.runSql(node, sqlForUpdate, false, new Object[0]).getAll();
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)1, (int)res2.size());
            keys = new ArrayList();
            iterator = res2.iterator();
            while (iterator.hasNext()) {
                r = (List)iterator.next();
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r.size());
                key = (Integer)r.get(0);
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)10, (int)key);
                keys.add(key);
            }
            this.checkLocks(keys);
            tx.rollback();
            this.checkLocks(Collections.emptyList());
        }
        catch (Throwable res3) {
            object = res3;
            throw res3;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable res3) {
                        ((Throwable)object).addSuppressed(res3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        List res4 = this.runSql(node, sqlForUpdate, false, new Object[0]).getAll();
        CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)1, (int)res4.size());
        ArrayList<Integer> keys2 = new ArrayList<Integer>();
        for (List r2 : res4) {
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r2.size());
            int key2 = (Integer)r2.get(0);
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)10, (int)key2);
            keys2.add(key2);
        }
        this.checkLocks(Collections.emptyList());
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        object = null;
        try {
            res2 = this.runSql(node, sqlForUpdate, false, new Object[0]).getAll();
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)1, (int)res2.size());
            keys = new ArrayList();
            Iterator key2 = res2.iterator();
            while (key2.hasNext()) {
                r = (List)key2.next();
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r.size());
                key = (Integer)r.get(0);
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)10, (int)key);
                keys.add(key);
            }
            this.runSql(node, "UPDATE Person SET name='test' WHERE id=" + keys.get(0), false, new Object[0]).getAll();
            this.checkLocks(keys);
            tx.commit();
        }
        catch (Throwable res5) {
            object = res5;
            throw res5;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable res5) {
                        ((Throwable)object).addSuppressed(res5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkLocks(Collections.emptyList());
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        object = null;
        try {
            res2 = this.runSql(node, sql, false, new Object[0]).getAll();
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)1, (int)res2.size());
            Iterator iterator2 = res2.iterator();
            while (iterator2.hasNext()) {
                List r3 = (List)iterator2.next();
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r3.size());
            }
            this.checkLocks(Collections.emptyList());
            tx.commit();
        }
        catch (Throwable res6) {
            object = res6;
            throw res6;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable res6) {
                        ((Throwable)object).addSuppressed(res6);
                    }
                } else {
                    tx.close();
                }
            }
        }
        res4 = this.runSql(node, sql, false, new Object[0]).getAll();
        CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)1, (int)res4.size());
        for (List r4 : res4) {
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r4.size());
        }
        this.checkLocks(Collections.emptyList());
    }

    @Test
    public void testSelectForUpdateLocal() throws Exception {
        this.checkSelectForUpdate(true);
    }

    @Test
    public void testSelectForUpdateDistributed() throws Exception {
        this.checkSelectForUpdate(false);
    }

    private void checkSelectForUpdate(boolean loc) throws Exception {
        List r;
        Iterator iterator;
        ArrayList<Integer> keys;
        Object res3;
        Ignite node = loc ? this.grid(0) : this.getNode();
        String sql = "SELECT name, id  FROM person WHERE MOD(salary, 3) = 0 ORDER BY id";
        String sqlForUpdate = sql + " FOR UPDATE";
        List res2 = this.runSql(node, sqlForUpdate, loc, new Object[0]).getAll();
        CacheMvccSelectForUpdateQueryBasicTest.assertTrue((boolean)(loc ? !res2.isEmpty() : res2.size() >= 25 && res2.size() <= 50));
        Serializable keys2 = new ArrayList<Integer>();
        for (List r2 : res2) {
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r2.size());
            keys2.add((Integer)r2.get(1));
        }
        this.checkLocks(Collections.emptyList());
        Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        keys2 = null;
        try {
            res3 = this.runSql(node, sqlForUpdate, loc, new Object[0]).getAll();
            CacheMvccSelectForUpdateQueryBasicTest.assertTrue((boolean)(loc ? !res3.isEmpty() : res3.size() >= 25 && res3.size() <= 50));
            keys = new ArrayList<Integer>();
            iterator = res3.iterator();
            while (iterator.hasNext()) {
                r = (List)iterator.next();
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r.size());
                keys.add((Integer)r.get(1));
            }
            this.runSql(node, "UPDATE Person SET name='test' WHERE id=" + keys.get(0), loc, new Object[0]).getAll();
            this.checkLocks(keys);
            tx.rollback();
            this.checkLocks(Collections.emptyList());
        }
        catch (Throwable res3) {
            keys2 = res3;
            throw res3;
        }
        finally {
            if (tx != null) {
                if (keys2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable res3) {
                        ((Throwable)keys2).addSuppressed(res3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        res2 = this.runSql(node, sqlForUpdate, loc, new Object[0]).getAll();
        CacheMvccSelectForUpdateQueryBasicTest.assertTrue((boolean)(loc ? !res2.isEmpty() : res2.size() >= 25 && res2.size() <= 50));
        keys2 = new ArrayList();
        for (List r2 : res2) {
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r2.size());
            keys2.add((Integer)r2.get(1));
        }
        this.checkLocks(Collections.emptyList());
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        Object object = null;
        try {
            res3 = this.runSql(node, sqlForUpdate, loc, new Object[0]).getAll();
            CacheMvccSelectForUpdateQueryBasicTest.assertTrue((boolean)(loc ? !res3.isEmpty() : res3.size() >= 25 && res3.size() <= 50));
            keys = new ArrayList();
            iterator = res3.iterator();
            while (iterator.hasNext()) {
                r = (List)iterator.next();
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r.size());
                keys.add((Integer)r.get(1));
            }
            this.runSql(node, "UPDATE Person SET name='test' WHERE id=" + keys.get(0), loc, new Object[0]).getAll();
            this.checkLocks(keys);
            tx.rollback();
            this.checkLocks(Collections.emptyList());
        }
        catch (Throwable res4) {
            object = res4;
            throw res4;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable res4) {
                        ((Throwable)object).addSuppressed(res4);
                    }
                } else {
                    tx.close();
                }
            }
        }
        res2 = this.runSql(node, sql, loc, new Object[0]).getAll();
        CacheMvccSelectForUpdateQueryBasicTest.assertTrue((boolean)(loc ? !res2.isEmpty() : res2.size() >= 25 && res2.size() <= 50));
        for (List r3 : res2) {
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r3.size());
        }
        this.checkLocks(Collections.emptyList());
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        object = null;
        try {
            res3 = this.runSql(node, sql, loc, new Object[0]).getAll();
            CacheMvccSelectForUpdateQueryBasicTest.assertTrue((boolean)(loc ? !res3.isEmpty() : res3.size() >= 25 && res3.size() <= 50));
            keys = new ArrayList();
            iterator = res3.iterator();
            while (iterator.hasNext()) {
                r = (List)iterator.next();
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r.size());
                keys.add((Integer)r.get(1));
            }
            this.checkLocks(Collections.emptyList());
            tx.rollback();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkLocks(Collections.emptyList());
    }

    @Test
    public void testJdbcAutoCommitFalseStartsTx() throws Exception {
        Ignite node = this.getNode();
        try (Connection c = AbstractSchemaSelfTest.connect((IgniteEx)node);){
            c.setAutoCommit(false);
            String sql = "SELECT name, id  FROM person WHERE MOD(salary, 3) = 0 ORDER BY id";
            String sqlForUpdate = sql + " FOR UPDATE";
            List<Integer> keys = this.runJdbcSql(c, sqlForUpdate, 2, 2);
            CacheMvccSelectForUpdateQueryBasicTest.assertTrue((keys.size() >= 25 && keys.size() <= 50 ? 1 : 0) != 0);
            this.checkLocks(keys);
            this.runJdbcSql(c, sql, 2, 2);
            this.checkLocks(keys);
            this.runJdbcSql(c, "COMMIT", -1, -1);
            this.checkLocks(Collections.emptyList());
        }
    }

    @Test
    public void testJdbcAutoCommitTrueKeysLocked() throws Exception {
        Ignite node = this.getNode();
        try (Connection c = AbstractSchemaSelfTest.connect((IgniteEx)node);){
            c.setAutoCommit(true);
            this.runJdbcSql(c, "BEGIN", -1, -1);
            String sql = "SELECT name, id  FROM person WHERE MOD(salary, 3) = 0 ORDER BY id";
            String sqlForUpdate = sql + " FOR UPDATE";
            List<Integer> keys = this.runJdbcSql(c, sqlForUpdate, 2, 2);
            CacheMvccSelectForUpdateQueryBasicTest.assertTrue((keys.size() >= 25 && keys.size() <= 50 ? 1 : 0) != 0);
            this.checkLocks(keys);
            this.runJdbcSql(c, sql, 2, 2);
            this.checkLocks(keys);
            this.runJdbcSql(c, "COMMIT", -1, -1);
            this.checkLocks(Collections.emptyList());
            this.runJdbcSql(c, sqlForUpdate, 2, 2);
            this.checkLocks(Collections.emptyList());
        }
    }

    @Test
    public void testSelectForUpdateLocalWithArgs() throws Exception {
        this.checkSelectForUpdateWithArgs(true);
    }

    @Test
    public void testSelectForUpdateDistributedWithArgs() throws Exception {
        this.checkSelectForUpdateWithArgs(false);
    }

    private void checkSelectForUpdateWithArgs(boolean loc) throws Exception {
        List r;
        Iterator iterator;
        ArrayList<Integer> keys;
        Object res3;
        Ignite node = loc ? this.grid(0) : this.getNode();
        String sql = "SELECT name, id  FROM person WHERE salary >= ? AND salary < ? ORDER BY id";
        String sqlForUpdate = sql + " FOR UPDATE";
        List res2 = this.runSql(node, sqlForUpdate, loc, 0, 200).getAll();
        CacheMvccSelectForUpdateQueryBasicTest.assertTrue((boolean)(loc ? !res2.isEmpty() : res2.size() == 20));
        Serializable keys2 = new ArrayList<Integer>();
        for (List r2 : res2) {
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r2.size());
            keys2.add((Integer)r2.get(1));
        }
        this.checkLocks(Collections.emptyList());
        Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        keys2 = null;
        try {
            res3 = this.runSql(node, sqlForUpdate, loc, 0, 200).getAll();
            CacheMvccSelectForUpdateQueryBasicTest.assertTrue((boolean)(loc ? !res3.isEmpty() : res3.size() == 20));
            keys = new ArrayList<Integer>();
            iterator = res3.iterator();
            while (iterator.hasNext()) {
                r = (List)iterator.next();
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r.size());
                keys.add((Integer)r.get(1));
            }
            this.runSql(node, "UPDATE Person SET name='test' WHERE id=" + keys.get(0), loc, new Object[0]).getAll();
            this.checkLocks(keys);
            tx.rollback();
            this.checkLocks(Collections.emptyList());
        }
        catch (Throwable res3) {
            keys2 = res3;
            throw res3;
        }
        finally {
            if (tx != null) {
                if (keys2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable res3) {
                        ((Throwable)keys2).addSuppressed(res3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        res2 = this.runSql(node, sqlForUpdate, loc, 0, 200).getAll();
        CacheMvccSelectForUpdateQueryBasicTest.assertTrue((boolean)(loc ? !res2.isEmpty() : res2.size() == 20));
        keys2 = new ArrayList();
        for (List r2 : res2) {
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r2.size());
            keys2.add((Integer)r2.get(1));
        }
        this.checkLocks(Collections.emptyList());
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        Object object = null;
        try {
            res3 = this.runSql(node, sqlForUpdate, loc, 0, 200).getAll();
            CacheMvccSelectForUpdateQueryBasicTest.assertTrue((boolean)(loc ? !res3.isEmpty() : res3.size() == 20));
            keys = new ArrayList();
            iterator = res3.iterator();
            while (iterator.hasNext()) {
                r = (List)iterator.next();
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r.size());
                keys.add((Integer)r.get(1));
            }
            this.runSql(node, "UPDATE Person SET name='test' WHERE id=" + keys.get(0), loc, new Object[0]).getAll();
            this.checkLocks(keys);
            tx.rollback();
            this.checkLocks(Collections.emptyList());
        }
        catch (Throwable res4) {
            object = res4;
            throw res4;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable res4) {
                        ((Throwable)object).addSuppressed(res4);
                    }
                } else {
                    tx.close();
                }
            }
        }
        res2 = this.runSql(node, sql, loc, 0, 200).getAll();
        CacheMvccSelectForUpdateQueryBasicTest.assertTrue((boolean)(loc ? !res2.isEmpty() : res2.size() == 20));
        for (List r3 : res2) {
            CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r3.size());
        }
        this.checkLocks(Collections.emptyList());
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        object = null;
        try {
            res3 = this.runSql(node, sql, loc, 0, 200).getAll();
            CacheMvccSelectForUpdateQueryBasicTest.assertTrue((boolean)(loc ? !res3.isEmpty() : res3.size() == 20));
            keys = new ArrayList();
            iterator = res3.iterator();
            while (iterator.hasNext()) {
                r = (List)iterator.next();
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)2, (int)r.size());
                keys.add((Integer)r.get(1));
            }
            this.checkLocks(Collections.emptyList());
            tx.rollback();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.checkLocks(Collections.emptyList());
    }

    private void checkLocks(List<Integer> lockedKeys) throws Exception {
        List allKeys = IntStream.range(0, 100).boxed().collect(Collectors.toList());
        ArrayList nonLockedKeys = new ArrayList(allKeys);
        nonLockedKeys.removeAll(lockedKeys);
        List nodes = Ignition.allGrids();
        final Ignite node = (Ignite)nodes.get(RAND.nextInt(nodes.size()));
        ArrayList<T2> calls = new ArrayList<T2>();
        Iterator<Object> iterator = allKeys.iterator();
        while (iterator.hasNext()) {
            final int key = (Integer)iterator.next();
            calls.add(new T2((Object)key, (Object)GridTestUtils.runAsync((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        node.cache("dummy").query(new SqlFieldsQuery("SELECT * FROM person WHERE id=" + key + " FOR UPDATE").setTimeout(1, TimeUnit.SECONDS)).getAll();
                        tx.rollback();
                        Void void_ = null;
                        return void_;
                    }
                }
            })));
        }
        for (T2 pair : calls) {
            if (nonLockedKeys.contains(pair.getKey())) {
                try {
                    ((IgniteInternalFuture)pair.getValue()).get(3000L);
                    continue;
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().contains("Failed to acquire lock within provided timeout")) {
                        throw new Exception("Key is locked, though it shouldn't be. Key: " + pair.getKey(), e);
                    }
                    throw e;
                }
            }
            try {
                ((IgniteInternalFuture)pair.getValue()).get();
                CacheMvccSelectForUpdateQueryBasicTest.fail((String)("Key is not locked: " + pair.getKey()));
            }
            catch (Exception e) {
                CacheException e0 = (CacheException)X.cause((Throwable)e, CacheException.class);
                assert (e0 != null);
                assert (e0.getMessage() != null && e0.getMessage().contains("Failed to acquire lock within provided timeout")) : X.getFullStackTrace((Throwable)e);
            }
        }
    }

    private Ignite getNode() {
        IgniteEx node;
        IgniteEx igniteEx = node = this.fromClient ? this.grid(3) : this.grid(RAND.nextInt(2));
        assert (this.fromClient == node.cluster().localNode().isClient());
        return node;
    }

    private FieldsQueryCursor<List<?>> runSql(Ignite node, String sql, boolean local, Object ... args) {
        return node.cache("dummy").query(new SqlFieldsQuery(sql).setLocal(local).setArgs(args));
    }

    private List<Integer> runJdbcSql(Connection c, String sql, int keyIdx, int colCnt) throws SQLException {
        try (Statement stmt = c.createStatement();){
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            if (rs == null) {
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)keyIdx, (int)-1);
                List<Integer> list = null;
                return list;
            }
            ArrayList<Integer> res = new ArrayList<Integer>();
            while (rs.next()) {
                CacheMvccSelectForUpdateQueryBasicTest.assertEquals((int)colCnt, (int)rs.getMetaData().getColumnCount());
                res.add(rs.getInt(keyIdx));
            }
            ArrayList<Integer> arrayList = res;
            return arrayList;
        }
    }
}

