/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.timeout.TimedQueryHelper;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCacheLocalQueryDefaultTimeoutSelfTest
extends GridCommonAbstractTest {
    private static final int CACHE_SIZE = 1000;
    private static final long DEFAULT_QUERY_TIMEOUT = 1000L;
    private static final String QUERY = "select a._val, b._val, longProcess(a._key, 5) from String a, String b";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, String.class}).setCacheMode(CacheMode.LOCAL).setSqlFunctionClasses(new Class[]{TimedQueryHelper.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        cfg.setSqlConfiguration(new SqlConfiguration().setDefaultQueryTimeout(1000L));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(0);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.grid(0).cache("default").removeAll();
    }

    private void loadCache(IgniteCache<Integer, String> cache) {
        int p = 1;
        for (int i = 1; i <= 1000; ++i) {
            char[] tmp = new char[256];
            Arrays.fill(tmp, ' ');
            cache.put((Object)i, (Object)new String(tmp));
            if (!((float)i / 1000.0f >= (float)p / 10.0f)) continue;
            this.log().info("Loaded " + i + " of " + 1000);
            ++p;
        }
    }

    @Test
    public void testQueryDefaultTimeout() {
        this.testQuery(false, 1, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testQueryTimeout() {
        this.testQuery(true, 1, TimeUnit.SECONDS);
    }

    private void testQuery(boolean timeout, int timeoutUnits, TimeUnit timeUnit) {
        FieldsQueryCursor cursor;
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.cache("default");
        this.loadCache((IgniteCache<Integer, String>)cache);
        SqlFieldsQuery qry = new SqlFieldsQuery(QUERY);
        if (timeout) {
            qry.setTimeout(timeoutUnits, timeUnit);
            cursor = cache.query(qry);
        } else {
            cursor = cache.query(qry);
            ignite.scheduler().runLocal(new Runnable((QueryCursor)cursor){
                final /* synthetic */ QueryCursor val$cursor;
                {
                    this.val$cursor = queryCursor;
                }

                @Override
                public void run() {
                    this.val$cursor.close();
                }
            }, (long)timeoutUnits, timeUnit);
        }
        try (FieldsQueryCursor ignored = cursor;){
            Iterator it = cursor.iterator();
            if (qry.isLazy()) {
                while (it.hasNext()) {
                    it.next();
                }
            }
            IgniteCacheLocalQueryDefaultTimeoutSelfTest.fail((String)"Expecting timeout");
        }
        catch (Exception e) {
            IgniteCacheLocalQueryDefaultTimeoutSelfTest.assertNotNull((String)"Must throw correct exception", (Object)X.cause((Throwable)e, QueryCancelledException.class));
        }
    }
}

