/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.Map;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.client.Person;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.index.AbstractRebuildIndexTest;
import org.apache.ignite.internal.processors.cache.index.IgniteH2IndexingEx;
import org.apache.ignite.internal.processors.cache.index.IndexingTestUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheCompoundFuture;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheFuture;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexOperationCancellationException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteThrowableConsumer;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class StopRebuildIndexTest
extends AbstractRebuildIndexTest {
    @Test
    public void testSchemaIndexCacheCompoundFeature() {
        SchemaIndexCacheCompoundFuture compoundFut = new SchemaIndexCacheCompoundFuture();
        StopRebuildIndexTest.assertFalse((boolean)compoundFut.isDone());
        GridFutureAdapter fut0 = new GridFutureAdapter();
        GridFutureAdapter fut1 = new GridFutureAdapter();
        GridFutureAdapter fut2 = new GridFutureAdapter();
        GridFutureAdapter fut3 = new GridFutureAdapter();
        compoundFut.add((IgniteInternalFuture)fut0).add((IgniteInternalFuture)fut1).add((IgniteInternalFuture)fut2).add((IgniteInternalFuture)fut3);
        StopRebuildIndexTest.assertFalse((boolean)compoundFut.isDone());
        fut0.onDone();
        StopRebuildIndexTest.assertFalse((boolean)compoundFut.isDone());
        fut1.onDone();
        StopRebuildIndexTest.assertFalse((boolean)compoundFut.isDone());
        fut2.onDone();
        StopRebuildIndexTest.assertFalse((boolean)compoundFut.isDone());
        fut3.onDone();
        StopRebuildIndexTest.assertFalse((boolean)compoundFut.isDone());
        compoundFut.markInitialized();
        StopRebuildIndexTest.assertTrue((boolean)compoundFut.isDone());
        StopRebuildIndexTest.assertNull((Object)compoundFut.error());
        compoundFut = new SchemaIndexCacheCompoundFuture();
        fut0 = new GridFutureAdapter();
        fut1 = new GridFutureAdapter();
        fut2 = new GridFutureAdapter();
        fut3 = new GridFutureAdapter();
        compoundFut.add((IgniteInternalFuture)fut0).add((IgniteInternalFuture)fut1).add((IgniteInternalFuture)fut2).add((IgniteInternalFuture)fut3).markInitialized();
        StopRebuildIndexTest.assertFalse((boolean)compoundFut.isDone());
        fut0.onDone();
        StopRebuildIndexTest.assertFalse((boolean)compoundFut.isDone());
        Exception err0 = new Exception();
        Exception err1 = new Exception();
        fut1.onDone((Throwable)err0);
        StopRebuildIndexTest.assertFalse((boolean)compoundFut.isDone());
        fut2.onDone((Throwable)err1);
        StopRebuildIndexTest.assertFalse((boolean)compoundFut.isDone());
        fut3.onDone((Throwable)err1);
        StopRebuildIndexTest.assertTrue((boolean)compoundFut.isDone());
        StopRebuildIndexTest.assertEquals((Object)err0, (Object)compoundFut.error().getCause());
    }

    @Test
    public void testStopRebuildIndexesOnDeactivation() throws Exception {
        this.stopRebuildIndexes((IgniteThrowableConsumer<IgniteEx>)(IgniteThrowableConsumer & Serializable)n -> n.cluster().state(ClusterState.INACTIVE), true);
        StopRebuildIndexTest.assertEquals((int)1, (int)G.allGrids().size());
    }

    @Test
    public void testStopRebuildIndexesOnStopNode() throws Exception {
        this.stopRebuildIndexes((IgniteThrowableConsumer<IgniteEx>)(IgniteThrowableConsumer & Serializable)n -> this.stopAllGrids(), false);
    }

    @Test
    public void testInternalIndexingRebuildFuture() throws Exception {
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IgniteEx n = this.startGrid(0);
        this.populate((IgniteCache<Integer, Person>)n.cache("default"), 10);
        GridCacheContext cacheCtx = n.cachex("default").context();
        IgniteH2IndexingEx.addCacheRebuildRunner(IndexingTestUtils.nodeName(n), cacheCtx.name(), () -> StopRebuildIndexTest.assertNull((Object)this.internalIndexRebuildFuture(n, cacheCtx.cacheId())));
        IndexingTestUtils.StopBuildIndexConsumer stopRebuildIdxConsumer = this.addStopRebuildIndexConsumer(n, cacheCtx.name());
        this.forceRebuildIndexes(n, new GridCacheContext[]{cacheCtx});
        IgniteInternalFuture rebFut0 = this.indexRebuildFuture(n, cacheCtx.cacheId());
        StopRebuildIndexTest.assertNotNull((Object)rebFut0);
        SchemaIndexCacheFuture rebFut1 = this.internalIndexRebuildFuture(n, cacheCtx.cacheId());
        StopRebuildIndexTest.assertNotNull((Object)rebFut1);
        stopRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        StopRebuildIndexTest.assertFalse((boolean)rebFut0.isDone());
        StopRebuildIndexTest.assertFalse((boolean)rebFut1.isDone());
        StopRebuildIndexTest.assertFalse((boolean)rebFut1.cancelToken().isCancelled());
        stopRebuildIdxConsumer.finishBuildIdxFut.onDone();
        rebFut0.get(this.getTestTimeout());
        rebFut1.get(this.getTestTimeout());
        StopRebuildIndexTest.assertFalse((boolean)rebFut1.cancelToken().isCancelled());
        StopRebuildIndexTest.assertNull((Object)this.indexRebuildFuture(n, cacheCtx.cacheId()));
        StopRebuildIndexTest.assertNull((Object)this.internalIndexRebuildFuture(n, cacheCtx.cacheId()));
    }

    private void stopRebuildIndexes(IgniteThrowableConsumer<IgniteEx> stopRebuildIndexes, boolean expThrowEx) throws Exception {
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        int keys = 100000;
        IgniteEx n = this.startGrid(0);
        this.populate((IgniteCache<Integer, Person>)n.cache("default"), keys);
        GridCacheContext cacheCtx = n.cachex("default").context();
        IgniteH2IndexingEx.addCacheRowConsumer(IndexingTestUtils.nodeName(n), cacheCtx.name(), (IgniteThrowableConsumer<CacheDataRow>)(IgniteThrowableConsumer & Serializable)row -> U.sleep((long)10L));
        this.forceRebuildIndexes(n, new GridCacheContext[]{cacheCtx});
        IgniteInternalFuture fut0 = this.indexRebuildFuture(n, cacheCtx.cacheId());
        StopRebuildIndexTest.assertNotNull((Object)fut0);
        SchemaIndexCacheFuture fut1 = this.internalIndexRebuildFuture(n, cacheCtx.cacheId());
        StopRebuildIndexTest.assertNotNull((Object)fut1);
        CacheMetricsImpl metrics0 = this.cacheMetrics0(n, cacheCtx.name());
        StopRebuildIndexTest.assertTrue((boolean)metrics0.isIndexRebuildInProgress());
        StopRebuildIndexTest.assertFalse((boolean)fut0.isDone());
        StopRebuildIndexTest.assertFalse((boolean)fut1.isDone());
        StopRebuildIndexTest.assertFalse((boolean)fut1.cancelToken().isCancelled());
        StopRebuildIndexTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> metrics0.getIndexRebuildKeysProcessed() >= (long)(keys / 100), (long)this.getTestTimeout()));
        StopRebuildIndexTest.assertTrue((boolean)metrics0.isIndexRebuildInProgress());
        StopRebuildIndexTest.assertFalse((boolean)fut0.isDone());
        StopRebuildIndexTest.assertFalse((boolean)fut1.isDone());
        StopRebuildIndexTest.assertFalse((boolean)fut1.cancelToken().isCancelled());
        stopRebuildIndexes.accept((Object)n);
        StopRebuildIndexTest.assertFalse((boolean)metrics0.isIndexRebuildInProgress());
        StopRebuildIndexTest.assertTrue((metrics0.getIndexRebuildKeysProcessed() < (long)keys ? 1 : 0) != 0);
        if (expThrowEx) {
            GridTestUtils.assertThrows((IgniteLogger)log, () -> fut0.get(this.getTestTimeout()), SchemaIndexOperationCancellationException.class, null);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)fut1.get(this.getTestTimeout()), SchemaIndexOperationCancellationException.class, null);
            StopRebuildIndexTest.assertTrue((boolean)fut1.cancelToken().isCancelled());
        } else {
            fut0.get(this.getTestTimeout());
            fut1.get(this.getTestTimeout());
            StopRebuildIndexTest.assertFalse((boolean)fut1.cancelToken().isCancelled());
        }
        StopRebuildIndexTest.assertNull((Object)this.internalIndexRebuildFuture(n, cacheCtx.cacheId()));
    }

    @Nullable
    private SchemaIndexCacheFuture internalIndexRebuildFuture(IgniteEx n, int cacheId) {
        GridQueryIndexing indexing = n.context().query().getIndexing();
        return (SchemaIndexCacheFuture)((Map)GridTestUtils.getFieldValueHierarchy((Object)indexing, (String[])new String[]{"idxRebuildFuts"})).get(cacheId);
    }
}

