/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.Person;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class StopNodeOnRebuildIndexFailureTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = StopNodeOnRebuildIndexFailureTest.class.getSimpleName() + "-cache";
    private static final String INDEX_NAME = (StopNodeOnRebuildIndexFailureTest.class.getSimpleName() + "_idx").toUpperCase();
    private static final String SQL_TABLE = Person.class.getSimpleName();
    private static final String CREATE_INDEX_SQL = "CREATE INDEX " + INDEX_NAME + " ON " + SQL_TABLE + " (name)";
    private final AtomicBoolean exceptionWasThrown = new AtomicBoolean();
    private Supplier<? extends Throwable> errorSupplier;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName(CACHE_NAME).setIndexedTypes(new Class[]{Integer.class, Person.class})});
        cfg.setFailureHandler((FailureHandler)new StopNodeFailureHandler());
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.exceptionWasThrown.set(false);
        BPlusTree.testHndWrapper = (tree, hnd) -> {
            if (tree.name().toUpperCase().contains(INDEX_NAME)) {
                final PageHandler delegate = hnd;
                return new PageHandler<Object, BPlusTree.Result>(){

                    public BPlusTree.Result run(int cacheId, long pageId, long page, long pageAddr, PageIO io, Boolean walPlc, Object arg, int intArg, IoStatisticsHolder statHolder) throws IgniteCheckedException {
                        try {
                            Throwable t = (Throwable)StopNodeOnRebuildIndexFailureTest.this.errorSupplier.get();
                            if (t instanceof Error) {
                                throw (Error)t;
                            }
                            if (t instanceof RuntimeException) {
                                throw (RuntimeException)t;
                            }
                            if (t instanceof IgniteCheckedException) {
                                throw (IgniteCheckedException)t;
                            }
                        }
                        catch (Throwable t) {
                            StopNodeOnRebuildIndexFailureTest.this.exceptionWasThrown.set(true);
                            log.error("Exception was thrown ", t);
                            throw t;
                        }
                        return null;
                    }

                    public boolean releaseAfterWrite(int cacheId, long pageId, long page, long pageAddr, Object arg, int intArg) {
                        return delegate.releaseAfterWrite(cacheId, pageId, page, pageAddr, arg, intArg);
                    }
                };
            }
            return hnd;
        };
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        BPlusTree.testHndWrapper = null;
    }

    @Test
    public void testWithRuntimeException() throws Exception {
        this.startBuildIndexAndThrowExceptionTest(() -> new RuntimeException("Test"));
    }

    @Test
    public void testWithIgniteCheckedException() throws Exception {
        this.startBuildIndexAndThrowExceptionTest(() -> new IgniteCheckedException("Test"));
    }

    @Test
    public void testWithOOMError() throws Exception {
        this.startBuildIndexAndThrowExceptionTest(() -> new OutOfMemoryError("Test"));
    }

    @Test
    public void testWithAssertionError() throws Exception {
        this.startBuildIndexAndThrowExceptionTest(() -> new AssertionError((Object)"Test"));
    }

    @Test
    public void testWithError() throws Exception {
        this.startBuildIndexAndThrowExceptionTest(() -> new Error("Test"));
    }

    private void startBuildIndexAndThrowExceptionTest(Supplier<? extends Throwable> throwableSupplier) throws Exception {
        this.errorSupplier = throwableSupplier;
        Throwable t = throwableSupplier.get();
        if (t instanceof Exception && !(t instanceof RuntimeException) && !(t instanceof IgniteCheckedException)) {
            throw new IllegalArgumentException("Invalid throwable class " + t.getClass());
        }
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        StopNodeOnRebuildIndexFailureTest.assertEquals((int)1, (int)G.allGrids().size());
        ignite.cache(CACHE_NAME).put((Object)0, (Object)new Person(Integer.valueOf(0), "name"));
        GridTestUtils.assertThrows((IgniteLogger)log, () -> ignite.cache(CACHE_NAME).query(new SqlFieldsQuery(CREATE_INDEX_SQL)).getAll(), CacheException.class, null);
        StopNodeOnRebuildIndexFailureTest.assertTrue((boolean)this.exceptionWasThrown.get());
        StopNodeOnRebuildIndexFailureTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> G.allGrids().isEmpty(), (long)5000L));
    }
}

