/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SqlPartitionEvictionTest
extends GridCommonAbstractTest {
    private static final String POI_CACHE_NAME = "POI_CACHE";
    private static final String POI_SCHEMA_NAME = "DOMAIN";
    private static final String POI_TABLE_NAME = "POI";
    private static final String POI_CLASS_NAME = "PointOfInterest";
    private static final String ID_FIELD_NAME = "id";
    private static final String NAME_FIELD_NAME = "name";
    private static final String LATITUDE_FIELD_NAME = "latitude";
    private static final String LONGITUDE_FIELD_NAME = "longitude";
    private static final int NUM_ENTITIES = 1000;
    @Parameterized.Parameter
    public int backupsCount;
    private static final CountDownLatch LATCH = new CountDownLatch(1);

    @Parameterized.Parameters(name="backups_count={0}")
    public static Iterable<Object[]> params() {
        return Arrays.asList({0}, {1}, {2});
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration(POI_CACHE_NAME).setAtomicityMode(CacheAtomicityMode.ATOMIC).setSqlSchema(POI_SCHEMA_NAME).setQueryEntities(Collections.singletonList(this.queryEntity())).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setCacheMode(CacheMode.PARTITIONED).setBackups(this.backupsCount)});
        cfg.setActiveOnStart(true);
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids(true);
        super.afterTest();
    }

    @Test
    public void testSqlConsistencyOnEviction() throws Exception {
        IgniteEx ig = null;
        int idx = 0;
        while (idx <= this.backupsCount) {
            ig = this.ignitionStart(idx++);
        }
        this.loadData(ig, 0, 1000);
        this.ignitionStart(idx);
        this.awaitPartitionMapExchange();
        U.await((CountDownLatch)LATCH, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        for (Ignite g : G.allGrids()) {
            SqlPartitionEvictionTest.assertEquals((int)1000, (int)this.query(g, "SELECT * FROM POI").size());
        }
    }

    private void loadData(IgniteEx node, int start, int end) {
        try (IgniteDataStreamer streamer = node.dataStreamer(POI_CACHE_NAME);){
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            for (int i = start; i < end; ++i) {
                BinaryObject bo = node.binary().builder(POI_CLASS_NAME).setField(NAME_FIELD_NAME, (Object)("POI_" + i), String.class).setField(LATITUDE_FIELD_NAME, (Object)((Random)rnd).nextDouble(), Double.class).setField(LONGITUDE_FIELD_NAME, (Object)((Random)rnd).nextDouble(), Double.class).build();
                streamer.addData((Object)i, (Object)bo);
            }
        }
    }

    protected List<List<?>> query(Ignite ig, String sql) {
        IgniteCache cache = ig.cache(POI_CACHE_NAME).withKeepBinary();
        return cache.query(new SqlFieldsQuery(sql).setSchema(POI_SCHEMA_NAME)).getAll();
    }

    private QueryEntity queryEntity() {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put(ID_FIELD_NAME, Integer.class.getName());
        fields.put(NAME_FIELD_NAME, String.class.getName());
        fields.put(LATITUDE_FIELD_NAME, Double.class.getName());
        fields.put(LONGITUDE_FIELD_NAME, Double.class.getName());
        return new QueryEntity().setKeyType(Integer.class.getName()).setKeyFieldName(ID_FIELD_NAME).setValueType(POI_CLASS_NAME).setTableName(POI_TABLE_NAME).setFields(fields);
    }

    private IgniteEx ignitionStart(int idx) throws Exception {
        GridQueryProcessor.idxCls = BlockingIndexing.class;
        IgniteConfiguration cfg = this.getConfiguration(this.getTestIgniteInstanceName(idx));
        return this.startGrid(cfg);
    }

    private static class BlockingIndexing
    extends IgniteH2Indexing {
        private BlockingIndexing() {
        }

        public void remove(GridCacheContext cctx, GridQueryTypeDescriptor type, CacheDataRow row) throws IgniteCheckedException {
            U.sleep((long)50L);
            LATCH.countDown();
            super.remove(cctx, type, row);
        }
    }
}

