/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.junit.Test;

public class QueryEntityValidationSelfTest
extends AbstractIndexingCommonTest {
    private static final String CACHE_NAME = "cache";
    private static final ListeningTestLogger srvLog = new ListeningTestLogger(log);

    protected void beforeTestsStarted() throws Exception {
        this.startGrid(0);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setGridLogger((IgniteLogger)srvLog);
    }

    @Test
    public void testValueTypeNull() throws Exception {
        final CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE_NAME);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType("Key");
        ccfg.setQueryEntities(Collections.singleton(entity));
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                QueryEntityValidationSelfTest.this.grid(0).createCache(ccfg);
                return null;
            }
        }, IgniteCheckedException.class, (String)"Value type cannot be null or empty");
    }

    @Test
    public void testIndexTypeNull() throws Exception {
        final CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE_NAME);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType("Key");
        entity.setValueType("Value");
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("a", Integer.class.getName());
        entity.setFields(fields);
        LinkedHashMap<String, Boolean> idxFields = new LinkedHashMap<String, Boolean>();
        idxFields.put("a", true);
        QueryIndex idx = new QueryIndex().setName("idx").setFields(idxFields).setIndexType(null);
        ArrayList<QueryIndex> idxs = new ArrayList<QueryIndex>();
        idxs.add(idx);
        entity.setIndexes(idxs);
        ccfg.setQueryEntities(Collections.singleton(entity));
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                QueryEntityValidationSelfTest.this.grid(0).createCache(ccfg);
                return null;
            }
        }, IgniteCheckedException.class, (String)"Index type is not set");
    }

    @Test
    public void testIndexNameDuplicate() throws Exception {
        final CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE_NAME);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType("Key");
        entity.setValueType("Value");
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("a", Integer.class.getName());
        fields.put("b", Integer.class.getName());
        entity.setFields(fields);
        LinkedHashMap<String, Boolean> idx1Fields = new LinkedHashMap<String, Boolean>();
        LinkedHashMap idx2Fields = new LinkedHashMap();
        idx1Fields.put("a", true);
        idx1Fields.put("b", true);
        QueryIndex idx1 = new QueryIndex().setName("idx").setFields(idx1Fields);
        QueryIndex idx2 = new QueryIndex().setName("idx").setFields(idx2Fields);
        ArrayList<QueryIndex> idxs = new ArrayList<QueryIndex>();
        idxs.add(idx1);
        idxs.add(idx2);
        entity.setIndexes(idxs);
        ccfg.setQueryEntities(Collections.singleton(entity));
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                QueryEntityValidationSelfTest.this.grid(0).createCache(ccfg);
                return null;
            }
        }, IgniteCheckedException.class, (String)"Duplicate index name");
    }

    @Test
    public void testNestedDuplicatedAnnotations() {
        final CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE_NAME);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() {
                ccfg.setIndexedTypes(new Class[]{TestKey.class, TestValue.class});
                return null;
            }
        }, CacheException.class, (String)"Property with name 'notUniqueId' already exists");
    }

    @Test
    public void testUniqueNameInAnnotation() {
        CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE_NAME);
        QueryEntityValidationSelfTest.assertNotNull((Object)ccfg.setIndexedTypes(new Class[]{TestKeyWithUniqueName.class, TestValueWithUniqueName.class}));
    }

    @Test
    public void testNotUniqueNameInAnnotation() {
        CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE_NAME);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            ccfg.setIndexedTypes(new Class[]{TestKeyWithNotUniqueName.class, TestValueWithNotUniqueName.class});
            return null;
        }, CacheException.class, (String)"Property with name 'Name3' already exists");
    }

    @Test
    public void testNonAnnotatedField() {
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setName(CACHE_NAME);
        ccfg.setIndexedTypes(new Class[]{TestKeyNoAnnotatedFields.class, TestValue.class});
        LogListener logListener = LogListener.matches((String)"Key of user type has no fields configured for table=TESTVALUE").build();
        srvLog.registerListener(logListener);
        try {
            this.grid(0).createCache(ccfg);
            QueryEntityValidationSelfTest.assertTrue((boolean)logListener.check());
        }
        finally {
            srvLog.clearListeners();
            this.grid(0).destroyCache(CACHE_NAME);
        }
    }

    private static class TestKeyNoAnnotatedFields {
        int keyField;

        private TestKeyNoAnnotatedFields() {
        }
    }

    private static class TestValueWithNotUniqueName {
        @QuerySqlField(name="Name3")
        int uniqueId2;

        private TestValueWithNotUniqueName() {
        }
    }

    private static class TestKeyWithNotUniqueName {
        @QuerySqlField(name="Name3")
        int uniqueId1;

        private TestKeyWithNotUniqueName() {
        }
    }

    private static class TestValueWithUniqueName {
        @QuerySqlField(name="Name2")
        int notUniqueId;

        private TestValueWithUniqueName() {
        }
    }

    private static class TestKeyWithUniqueName {
        @QuerySqlField(name="Name1")
        int notUniqueId;

        private TestKeyWithUniqueName() {
        }
    }

    private static class TestValueField {
        @QuerySqlField
        int notUniqueId;

        private TestValueField() {
        }
    }

    private static class TestValue {
        @QuerySqlField
        TestValueField field;

        private TestValue() {
        }
    }

    private static class TestKey {
        @QuerySqlField
        int notUniqueId;

        private TestKey() {
        }
    }
}

