/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.metric.IoStatisticsCacheSelfTest;
import org.apache.ignite.internal.metric.IoStatisticsMetricsLocalMxBeanCacheGroupsTest;
import org.apache.ignite.internal.metric.IoStatisticsType;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.metric.Metric;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.junit.Assert;
import org.junit.Test;

public class IoStatisticsBasicIndexSelfTest
extends AbstractIndexingCommonTest {
    private static final int NUMBER_OF_PK_SORTED_INDEXES = 1;
    private static final Set<String> PK_HASH_INDEXES = Sets.newHashSet((Object[])new String[]{"default"});
    private Collection<QueryIndex> indexes;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IoStatisticsBasicIndexSelfTest.assertNotNull(this.indexes);
        IgniteConfiguration igniteCfg = super.getConfiguration(igniteInstanceName);
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("keyStr", String.class.getName());
        fields.put("keyLong", Long.class.getName());
        fields.put("keyPojo", Pojo.class.getName());
        fields.put("valStr", String.class.getName());
        fields.put("valLong", Long.class.getName());
        fields.put("valPojo", Pojo.class.getName());
        HashSet<String> keyFields = new HashSet<String>();
        keyFields.add("keyStr");
        keyFields.add("keyLong");
        keyFields.add("keyPojo");
        CacheConfiguration ccfg = new CacheConfiguration("default").setQueryEntities(Collections.singleton(new QueryEntity().setKeyType(Key.class.getName()).setValueType(Val.class.getName()).setKeyFields(keyFields).setFields(fields).setIndexes(this.indexes)));
        igniteCfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        igniteCfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        return igniteCfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.indexes = null;
        super.afterTest();
    }

    @Test
    public void testNoIndexes() throws Exception {
        this.indexes = Collections.emptyList();
        this.startGrid();
        this.grid().cluster().active(true);
        this.populateCache();
        this.checkStat();
        this.checkAll();
        this.checkStat();
    }

    @Test
    public void testAllIndexes() throws Exception {
        this.indexes = Arrays.asList(new QueryIndex("keyStr"), new QueryIndex("keyLong"), new QueryIndex("keyPojo"), new QueryIndex("valStr"), new QueryIndex("valLong"), new QueryIndex("valPojo"));
        this.startGrid();
        this.grid().cluster().active(true);
        this.populateCache();
        this.checkStat();
        this.checkAll();
        this.checkStat();
    }

    @Test
    public void testMetricRegistryRemovedOnIndexDrop() throws Exception {
        this.indexes = Collections.emptyList();
        this.startGrid();
        this.grid().cluster().active(true);
        this.execute((Ignite)this.grid(), "CREATE TABLE t(id int, name varchar, primary key (id))", new Object[0]);
        this.execute((Ignite)this.grid(), "CREATE INDEX MY_IDX ON t(name)", new Object[0]);
        MetricRegistry mreg = this.grid().context().metric().registry(MetricUtils.metricName((String[])new String[]{IoStatisticsType.SORTED_INDEX.metricGroupName(), "SQL_PUBLIC_T", "MY_IDX"}));
        IoStatisticsBasicIndexSelfTest.assertTrue((boolean)mreg.iterator().hasNext());
        IoStatisticsBasicIndexSelfTest.assertNotNull((Object)mreg.findMetric("name"));
        this.execute((Ignite)this.grid(), "DROP INDEX MY_IDX", new Object[0]);
        mreg = this.grid().context().metric().registry(MetricUtils.metricName((String[])new String[]{IoStatisticsType.SORTED_INDEX.metricGroupName(), "SQL_PUBLIC_T", "MY_IDX"}));
        IoStatisticsBasicIndexSelfTest.assertFalse((boolean)mreg.iterator().hasNext());
    }

    private void checkStat() throws Exception {
        GridMetricManager mmgr = this.grid().context().metric();
        Set<String> hashIndexes = this.deriveStatisticNames(this.grid(), IoStatisticsType.HASH_INDEX);
        Assert.assertEquals(PK_HASH_INDEXES, hashIndexes);
        Set<String> sortedIdxCaches = this.deriveStatisticNames(this.grid(), IoStatisticsType.SORTED_INDEX);
        Assert.assertEquals((long)1L, (long)sortedIdxCaches.size());
        Set<String> sortedIdxNames = this.deriveStatisticSubNames(this.grid(), IoStatisticsType.SORTED_INDEX);
        Assert.assertEquals((String)sortedIdxCaches.toString(), (long)(this.indexes.size() + 1), (long)sortedIdxNames.size());
        for (String idxName : sortedIdxNames) {
            Long logicalReads = IoStatisticsCacheSelfTest.logicalReads((GridMetricManager)mmgr, (IoStatisticsType)IoStatisticsType.SORTED_INDEX, (String)MetricUtils.metricName((String[])new String[]{"default", idxName}));
            Assert.assertNotNull((String)idxName, (Object)logicalReads);
            Assert.assertTrue((logicalReads > 0L ? 1 : 0) != 0);
        }
        IoStatisticsMetricsLocalMxBeanCacheGroupsTest.resetAllIoMetrics((IgniteEx)this.grid());
    }

    private void checkAll() {
        IgniteCache cache = this.grid().cache("default");
        this.checkRemovePut((IgniteCache<Key, Val>)cache);
        this.checkSelectAll((IgniteCache<Key, Val>)cache);
        this.checkSelectStringEqual((IgniteCache<Key, Val>)cache);
        this.checkSelectLongEqual((IgniteCache<Key, Val>)cache);
        this.checkSelectStringRange((IgniteCache<Key, Val>)cache);
        this.checkSelectLongRange((IgniteCache<Key, Val>)cache);
    }

    private void populateCache() {
        IgniteCache cache = this.grid().cache("default");
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)IoStatisticsBasicIndexSelfTest.key(i), (Object)IoStatisticsBasicIndexSelfTest.val(i));
        }
    }

    private void checkRemovePut(IgniteCache<Key, Val> cache) {
        int INT = 24;
        IoStatisticsBasicIndexSelfTest.assertEquals((Object)IoStatisticsBasicIndexSelfTest.val(24L), (Object)cache.get((Object)IoStatisticsBasicIndexSelfTest.key(24L)));
        cache.remove((Object)IoStatisticsBasicIndexSelfTest.key(24L));
        IoStatisticsBasicIndexSelfTest.assertNull((Object)cache.get((Object)IoStatisticsBasicIndexSelfTest.key(24L)));
        cache.put((Object)IoStatisticsBasicIndexSelfTest.key(24L), (Object)IoStatisticsBasicIndexSelfTest.val(24L));
        IoStatisticsBasicIndexSelfTest.assertEquals((Object)IoStatisticsBasicIndexSelfTest.val(24L), (Object)cache.get((Object)IoStatisticsBasicIndexSelfTest.key(24L)));
    }

    private void checkSelectAll(IgniteCache<Key, Val> cache) {
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val")).getAll();
        IoStatisticsBasicIndexSelfTest.assertEquals((int)100, (int)data.size());
        for (List row : data) {
            Key key = (Key)row.get(0);
            Val val = (Val)row.get(1);
            long i = key.keyLong;
            IoStatisticsBasicIndexSelfTest.assertEquals((Object)IoStatisticsBasicIndexSelfTest.key(i), (Object)key);
            IoStatisticsBasicIndexSelfTest.assertEquals((Object)IoStatisticsBasicIndexSelfTest.val(i), (Object)val);
        }
    }

    private void checkSelectStringEqual(IgniteCache<Key, Val> cache) {
        String STR = "foo011";
        long LONG = 11L;
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val where keyStr = ?").setArgs(new Object[]{"foo011"})).getAll();
        IoStatisticsBasicIndexSelfTest.assertEquals((int)1, (int)data.size());
        List row = (List)data.get(0);
        IoStatisticsBasicIndexSelfTest.assertEquals((Object)IoStatisticsBasicIndexSelfTest.key(11L), row.get(0));
        IoStatisticsBasicIndexSelfTest.assertEquals((Object)IoStatisticsBasicIndexSelfTest.val(11L), row.get(1));
    }

    private void checkSelectLongEqual(IgniteCache<Key, Val> cache) {
        long LONG = 42L;
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val where valLong = ?").setArgs(new Object[]{42L})).getAll();
        IoStatisticsBasicIndexSelfTest.assertEquals((int)1, (int)data.size());
        List row = (List)data.get(0);
        IoStatisticsBasicIndexSelfTest.assertEquals((Object)IoStatisticsBasicIndexSelfTest.key(42L), row.get(0));
        IoStatisticsBasicIndexSelfTest.assertEquals((Object)IoStatisticsBasicIndexSelfTest.val(42L), row.get(1));
    }

    private void checkSelectStringRange(IgniteCache<Key, Val> cache) {
        String PREFIX = "foo06";
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val where keyStr like ?").setArgs(new Object[]{"foo06%"})).getAll();
        IoStatisticsBasicIndexSelfTest.assertEquals((int)10, (int)data.size());
        for (List row : data) {
            Key key = (Key)row.get(0);
            Val val = (Val)row.get(1);
            long i = key.keyLong;
            IoStatisticsBasicIndexSelfTest.assertEquals((Object)IoStatisticsBasicIndexSelfTest.key(i), (Object)key);
            IoStatisticsBasicIndexSelfTest.assertEquals((Object)IoStatisticsBasicIndexSelfTest.val(i), (Object)val);
            IoStatisticsBasicIndexSelfTest.assertTrue((boolean)key.keyStr.startsWith("foo06"));
        }
    }

    private void checkSelectLongRange(IgniteCache<Key, Val> cache) {
        long RANGE_START = 70L;
        long RANGE_END = 80L;
        List data = cache.query(new SqlFieldsQuery("select _key, _val from Val where valLong >= ? and valLong < ?").setArgs(new Object[]{70L, 80L})).getAll();
        IoStatisticsBasicIndexSelfTest.assertEquals((int)10, (int)data.size());
        for (List row : data) {
            Key key = (Key)row.get(0);
            Val val = (Val)row.get(1);
            long i = key.keyLong;
            IoStatisticsBasicIndexSelfTest.assertEquals((Object)IoStatisticsBasicIndexSelfTest.key(i), (Object)key);
            IoStatisticsBasicIndexSelfTest.assertEquals((Object)IoStatisticsBasicIndexSelfTest.val(i), (Object)val);
            IoStatisticsBasicIndexSelfTest.assertTrue((i >= 70L && i < 80L ? 1 : 0) != 0);
        }
    }

    public Set<String> deriveStatisticSubNames(IgniteEx ignite, IoStatisticsType statType) {
        assert (statType != null);
        return this.ioStats(ignite, statType).map(m -> {
            if (m.name().startsWith(IoStatisticsType.CACHE_GROUP.metricGroupName())) {
                return m.findMetric("grpId").getAsString();
            }
            if (m.name().startsWith(IoStatisticsType.HASH_INDEX.metricGroupName()) || m.name().startsWith(IoStatisticsType.SORTED_INDEX.metricGroupName())) {
                return m.findMetric("indexName").getAsString();
            }
            throw new IgniteException("Wrong metric registry " + m.name());
        }).collect(Collectors.toSet());
    }

    public Set<String> deriveStatisticNames(IgniteEx ignite, IoStatisticsType statType) {
        assert (statType != null);
        Stream<ReadOnlyMetricRegistry> grpsStream = this.ioStats(ignite, statType);
        return grpsStream.flatMap(grp -> StreamSupport.stream(grp.spliterator(), false)).filter(m -> m.name().endsWith("name")).map(Metric::getAsString).collect(Collectors.toSet());
    }

    private Stream<ReadOnlyMetricRegistry> ioStats(IgniteEx ignite, IoStatisticsType statType) {
        GridMetricManager mmgr = ignite.context().metric();
        return StreamSupport.stream(mmgr.spliterator(), false).filter(grp -> grp.name().startsWith(statType.metricGroupName()));
    }

    private static Key key(long i) {
        return new Key(String.format("foo%03d", i), i, new Pojo(i));
    }

    private static Val val(long i) {
        return new Val(String.format("bar%03d", i), i, new Pojo(i));
    }

    private List<List<?>> execute(Ignite node, String sql, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setArgs(args).setSchema("PUBLIC");
        return AbstractSchemaSelfTest.queryProcessor(node).querySqlFields(qry, true).getAll();
    }

    private static class Pojo {
        private long pojoLong;

        private Pojo(long pojoLong) {
            this.pojoLong = pojoLong;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pojo pojo = (Pojo)o;
            return this.pojoLong == pojo.pojoLong;
        }

        public int hashCode() {
            return Objects.hash(this.pojoLong);
        }

        public String toString() {
            return S.toString(Pojo.class, (Object)this);
        }
    }

    private static class Val {
        private String valStr;
        private long valLong;
        private Pojo valPojo;

        private Val(String str, long aLong, Pojo pojo) {
            this.valStr = str;
            this.valLong = aLong;
            this.valPojo = pojo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Val val = (Val)o;
            return this.valLong == val.valLong && Objects.equals(this.valStr, val.valStr) && Objects.equals(this.valPojo, val.valPojo);
        }

        public int hashCode() {
            return Objects.hash(this.valStr, this.valLong, this.valPojo);
        }

        public String toString() {
            return S.toString(Val.class, (Object)this);
        }
    }

    private static class Key {
        private String keyStr;
        private long keyLong;
        private Pojo keyPojo;

        private Key(String str, long aLong, Pojo pojo) {
            this.keyStr = str;
            this.keyLong = aLong;
            this.keyPojo = pojo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.keyLong == key.keyLong && Objects.equals(this.keyStr, key.keyStr) && Objects.equals(this.keyPojo, key.keyPojo);
        }

        public int hashCode() {
            return Objects.hash(this.keyStr, this.keyLong, this.keyPojo);
        }

        public String toString() {
            return S.toString(Key.class, (Object)this);
        }
    }
}

