/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheClusterMetricsMXBeanImpl;
import org.apache.ignite.internal.processors.cache.CacheLocalMetricsMXBeanImpl;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.mxbean.CacheMetricsMXBean;
import org.apache.ignite.spi.metric.BooleanMetric;
import org.apache.ignite.spi.metric.Metric;
import org.junit.Test;

public class IndexMetricsTest
extends AbstractIndexingCommonTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0xA00000L)));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        GridQueryProcessor.idxCls = null;
    }

    private CacheConfiguration<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cacheConfiguration(String cacheName) {
        CacheConfiguration ccfg = new CacheConfiguration(cacheName);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(AbstractSchemaSelfTest.KeyClass.class.getName());
        entity.setValueType(AbstractSchemaSelfTest.ValueClass.class.getName());
        entity.setKeyFieldName("key");
        entity.addQueryField("key", entity.getKeyType(), null);
        entity.setIndexes(Collections.singletonList(new QueryIndex("key", true, cacheName + "_index")));
        ccfg.setQueryEntities(Collections.singletonList(entity));
        return ccfg;
    }

    @Test
    public void testIndexRebuildingMetric() throws Exception {
        int i;
        IgniteEx n = this.startGrid(0);
        n.cluster().active(true);
        String cacheName1 = "cache1";
        String cacheName2 = "cache2";
        IgniteCache cache1 = n.getOrCreateCache(this.cacheConfiguration(cacheName1));
        IgniteCache cache2 = n.getOrCreateCache(this.cacheConfiguration(cacheName2));
        int entryCnt1 = 100;
        int entryCnt2 = 200;
        for (i = 0; i < entryCnt1; ++i) {
            cache1.put((Object)new AbstractSchemaSelfTest.KeyClass(i), (Object)new AbstractSchemaSelfTest.ValueClass(Long.valueOf(i)));
        }
        for (i = 0; i < entryCnt2; ++i) {
            cache2.put((Object)new AbstractSchemaSelfTest.KeyClass(i), (Object)new AbstractSchemaSelfTest.ValueClass(Long.valueOf(i)));
        }
        List<Path> idxPaths = this.getIndexBinPaths(cacheName1);
        idxPaths.addAll(this.getIndexBinPaths(cacheName2));
        this.stopAllGrids();
        idxPaths.forEach(idxPath -> IndexMetricsTest.assertTrue((boolean)U.delete((Path)idxPath)));
        GridQueryProcessor.idxCls = AbstractIndexingCommonTest.BlockingIndexing.class;
        n = this.startGrid(0);
        BooleanMetric idxRebuildInProgress1 = (BooleanMetric)this.indexRebuildMetric(n, cacheName1, "IsIndexRebuildInProgress");
        BooleanMetric idxRebuildInProgress2 = (BooleanMetric)this.indexRebuildMetric(n, cacheName2, "IsIndexRebuildInProgress");
        LongAdderMetric idxRebuildKeyProcessed1 = (LongAdderMetric)this.indexRebuildMetric(n, cacheName1, "IndexRebuildKeyProcessed");
        LongAdderMetric idxRebuildKeyProcessed2 = (LongAdderMetric)this.indexRebuildMetric(n, cacheName2, "IndexRebuildKeyProcessed");
        CacheMetrics cacheMetrics1 = this.cacheMetrics(n, cacheName1);
        CacheMetrics cacheMetrics2 = this.cacheMetrics(n, cacheName2);
        CacheLocalMetricsMXBeanImpl cacheMetricsMXBean1 = this.cacheMetricsMXBean(n, cacheName1, CacheLocalMetricsMXBeanImpl.class);
        CacheLocalMetricsMXBeanImpl cacheMetricsMXBean2 = this.cacheMetricsMXBean(n, cacheName2, CacheLocalMetricsMXBeanImpl.class);
        CacheClusterMetricsMXBeanImpl cacheClusterMetricsMXBean1 = this.cacheMetricsMXBean(n, cacheName1, CacheClusterMetricsMXBeanImpl.class);
        CacheClusterMetricsMXBeanImpl cacheClusterMetricsMXBean2 = this.cacheMetricsMXBean(n, cacheName2, CacheClusterMetricsMXBeanImpl.class);
        n.cluster().active(true);
        BooleanSupplier[] booleanSupplierArray = new BooleanSupplier[3];
        booleanSupplierArray[0] = () -> ((BooleanMetric)idxRebuildInProgress1).value();
        booleanSupplierArray[1] = () -> ((CacheMetrics)cacheMetrics1).isIndexRebuildInProgress();
        booleanSupplierArray[2] = () -> ((CacheMetricsMXBean)cacheMetricsMXBean1).isIndexRebuildInProgress();
        BooleanSupplier[] idxRebuildProgressCache1 = booleanSupplierArray;
        BooleanSupplier[] booleanSupplierArray2 = new BooleanSupplier[3];
        booleanSupplierArray2[0] = () -> ((BooleanMetric)idxRebuildInProgress2).value();
        booleanSupplierArray2[1] = () -> ((CacheMetrics)cacheMetrics2).isIndexRebuildInProgress();
        booleanSupplierArray2[2] = () -> ((CacheMetricsMXBean)cacheMetricsMXBean2).isIndexRebuildInProgress();
        BooleanSupplier[] idxRebuildProgressCache2 = booleanSupplierArray2;
        BooleanSupplier[] booleanSupplierArray3 = new BooleanSupplier[2];
        booleanSupplierArray3[0] = () -> ((CacheMetricsMXBean)cacheClusterMetricsMXBean1).isIndexRebuildInProgress();
        booleanSupplierArray3[1] = () -> ((CacheMetricsMXBean)cacheClusterMetricsMXBean2).isIndexRebuildInProgress();
        BooleanSupplier[] idxRebuildProgressCluster = booleanSupplierArray3;
        LongSupplier[] longSupplierArray = new LongSupplier[3];
        longSupplierArray[0] = () -> ((LongAdderMetric)idxRebuildKeyProcessed1).value();
        longSupplierArray[1] = () -> ((CacheMetrics)cacheMetrics1).getIndexRebuildKeysProcessed();
        longSupplierArray[2] = () -> ((CacheMetricsMXBean)cacheMetricsMXBean1).getIndexRebuildKeysProcessed();
        LongSupplier[] idxRebuildKeyProcessedCache1 = longSupplierArray;
        LongSupplier[] longSupplierArray2 = new LongSupplier[3];
        longSupplierArray2[0] = () -> ((LongAdderMetric)idxRebuildKeyProcessed2).value();
        longSupplierArray2[1] = () -> ((CacheMetrics)cacheMetrics2).getIndexRebuildKeysProcessed();
        longSupplierArray2[2] = () -> ((CacheMetricsMXBean)cacheMetricsMXBean2).getIndexRebuildKeysProcessed();
        LongSupplier[] idxRebuildKeyProcessedCache2 = longSupplierArray2;
        LongSupplier[] longSupplierArray3 = new LongSupplier[2];
        longSupplierArray3[0] = () -> ((CacheMetricsMXBean)cacheClusterMetricsMXBean1).getIndexRebuildKeysProcessed();
        longSupplierArray3[1] = () -> ((CacheMetricsMXBean)cacheClusterMetricsMXBean2).getIndexRebuildKeysProcessed();
        LongSupplier[] idxRebuildKeyProcessedCluster = longSupplierArray3;
        this.assertEquals(true, idxRebuildProgressCache1);
        this.assertEquals(true, idxRebuildProgressCache2);
        this.assertEquals(false, idxRebuildProgressCluster);
        this.assertEquals(0L, idxRebuildKeyProcessedCache1);
        this.assertEquals(0L, idxRebuildKeyProcessedCache2);
        this.assertEquals(0L, idxRebuildKeyProcessedCluster);
        ((AbstractIndexingCommonTest.BlockingIndexing)n.context().query().getIndexing()).stopBlock(cacheName1);
        n.cache(cacheName1).indexReadyFuture().get(30000L);
        this.assertEquals(false, idxRebuildProgressCache1);
        this.assertEquals(true, idxRebuildProgressCache2);
        this.assertEquals(false, idxRebuildProgressCluster);
        this.assertEquals(entryCnt1, idxRebuildKeyProcessedCache1);
        this.assertEquals(0L, idxRebuildKeyProcessedCache2);
        this.assertEquals(0L, idxRebuildKeyProcessedCluster);
        ((AbstractIndexingCommonTest.BlockingIndexing)n.context().query().getIndexing()).stopBlock(cacheName2);
        n.cache(cacheName2).indexReadyFuture().get(30000L);
        this.assertEquals(false, idxRebuildProgressCache1);
        this.assertEquals(false, idxRebuildProgressCache2);
        this.assertEquals(false, idxRebuildProgressCluster);
        this.assertEquals(entryCnt1, idxRebuildKeyProcessedCache1);
        this.assertEquals(entryCnt2, idxRebuildKeyProcessedCache2);
        this.assertEquals(0L, idxRebuildKeyProcessedCluster);
    }

    private <M extends Metric> M indexRebuildMetric(IgniteEx ignite, String cacheName, String name) {
        MetricRegistry mreg = ignite.context().metric().registry(MetricUtils.cacheMetricsRegistryName((String)cacheName, (boolean)false));
        return (M)mreg.findMetric(name);
    }

    private CacheMetrics cacheMetrics(IgniteEx node, String cacheName) {
        Objects.requireNonNull(node);
        Objects.requireNonNull(cacheName);
        return node.context().cache().cacheGroup(CU.cacheId((String)cacheName)).singleCacheContext().cache().metrics0();
    }

    private <T extends CacheMetricsMXBean> T cacheMetricsMXBean(IgniteEx n, String cacheName, Class<? super T> cls) {
        Objects.requireNonNull(n);
        Objects.requireNonNull(cacheName);
        Objects.requireNonNull(cls);
        return (T)((CacheMetricsMXBean)IndexMetricsTest.getMxBean((String)n.name(), (String)cacheName, (String)cls.getName(), CacheMetricsMXBean.class));
    }

    private void assertEquals(boolean exp, BooleanSupplier ... actuals) {
        Objects.requireNonNull(actuals);
        for (int i = 0; i < actuals.length; ++i) {
            IndexMetricsTest.assertEquals((String)("i=" + i), (boolean)exp, (boolean)actuals[i].getAsBoolean());
        }
    }

    private void assertEquals(long exp, LongSupplier ... actuals) {
        Objects.requireNonNull(actuals);
        for (int i = 0; i < actuals.length; ++i) {
            IndexMetricsTest.assertEquals((String)("i=" + i), (long)exp, (long)actuals[i].getAsLong());
        }
    }
}

