/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.localtask.DurableBackgroundTaskState;
import org.apache.ignite.internal.processors.localtask.DurableBackgroundTasksProcessor;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.DurableBackgroundCleanupIndexTreeTaskV2;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.database.io.H2LeafIO;
import org.apache.ignite.internal.processors.query.h2.maintenance.MaintenanceRebuildIndexTarget;
import org.apache.ignite.internal.processors.query.h2.maintenance.MaintenanceRebuildIndexUtils;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.verify.ValidateIndexesClosure;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.maintenance.MaintenanceRegistry;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IndexCorruptionRebuildTest
extends GridCommonAbstractTest {
    private static final String FAIL_IDX_1 = "FAIL_IDX_1";
    private static final String OK_IDX = "OK_IDX";
    private static final String FAIL_IDX_2 = "FAIL_IDX_2";
    private static final String FAIL_IDX_3 = "FAIL_IDX_3";
    private static final String CACHE_NAME_1 = "SQL_PUBLIC_TEST1";
    private static final String CACHE_NAME_2 = "SQL_PUBLIC_TEST2";
    private static final String TABLE_NAME_1 = "test1";
    private static final String TABLE_NAME_2 = "test2";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setConsistentId((Serializable)((Object)gridName));
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("default").setBackups(1)});
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        GridQueryProcessor.idxCls = null;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        GridQueryProcessor.idxCls = null;
        super.afterTest();
    }

    @Test
    public void testCorruptedTree() throws Exception {
        IgniteEx srv = this.startGrid(0);
        IgniteEx normalNode = this.startGrid(1);
        normalNode.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = srv.getOrCreateCache("default");
        String qry = "create table %s (col1 varchar primary key, col2 varchar, col3 varchar, col4 varchar) with \"BACKUPS=1\"";
        cache.query(new SqlFieldsQuery(String.format(qry, TABLE_NAME_1)));
        cache.query(new SqlFieldsQuery(String.format(qry, TABLE_NAME_2)));
        cache.query(new SqlFieldsQuery("create index FAIL_IDX_1 on test1(col2) INLINE_SIZE 0"));
        cache.query(new SqlFieldsQuery("create index OK_IDX on test1(col3) INLINE_SIZE 0"));
        cache.query(new SqlFieldsQuery("create index FAIL_IDX_2 on test1(col4) INLINE_SIZE 0"));
        cache.query(new SqlFieldsQuery("create index FAIL_IDX_3 on test2(col2) INLINE_SIZE 0"));
        for (int i = 0; i < 100; ++i) {
            int counter = i;
            String value = "test" + i;
            String query = "insert into %s(col1, col2, col3, col4) values (?1, ?2, ?3, ?4)";
            Stream.of(TABLE_NAME_1, TABLE_NAME_2).map(tableName -> new SqlFieldsQuery(String.format(query, tableName)).setArgs(new Object[]{String.valueOf(counter), value, value, value})).forEach(arg_0 -> ((IgniteCache)cache).query(arg_0));
        }
        IgniteH2Indexing indexing = (IgniteH2Indexing)srv.context().query().getIndexing();
        this.corruptIndex(srv, indexing, CACHE_NAME_1, FAIL_IDX_1);
        this.corruptIndex(srv, indexing, CACHE_NAME_1, FAIL_IDX_2);
        this.corruptIndex(srv, indexing, CACHE_NAME_2, FAIL_IDX_3);
        MaintenanceRegistry registry = srv.context().maintenanceRegistry();
        this.checkIndexCorruption(registry, (IgniteCache<Integer, Integer>)cache, TABLE_NAME_1, Arrays.asList("col2", "col4"));
        this.checkIndexCorruption(registry, (IgniteCache<Integer, Integer>)cache, TABLE_NAME_2, Collections.singletonList("col2"));
        MaintenanceTask task = registry.requestedTask("indexRebuildMaintenanceTask");
        List targets = MaintenanceRebuildIndexUtils.parseMaintenanceTaskParameters((String)task.parameters());
        Map<Integer, Set<String>> rebuildMap = targets.stream().collect(Collectors.groupingBy(MaintenanceRebuildIndexTarget::cacheId, Collectors.mapping(MaintenanceRebuildIndexTarget::idxName, Collectors.toSet())));
        this.checkCacheToCorruptedIndexMap(rebuildMap);
        this.stopGrid(0);
        srv = this.startGrid(0);
        IndexCorruptionRebuildTest.assertTrue((boolean)srv.context().maintenanceRegistry().isMaintenanceMode());
        Collection<DurableBackgroundTaskState<?>> durableTasks = this.tasks(srv.context().durableBackgroundTask()).values();
        Map<Integer, Set<String>> indexTasksByCache = durableTasks.stream().collect(Collectors.groupingBy(state -> CU.cacheId((String)((DurableBackgroundCleanupIndexTreeTaskV2)state.task()).cacheName()), Collectors.mapping(state -> ((DurableBackgroundCleanupIndexTreeTaskV2)state.task()).idxName(), Collectors.toSet())));
        this.checkCacheToCorruptedIndexMap(indexTasksByCache);
        this.stopGrid(0);
        GridQueryProcessor.idxCls = CaptureRebuildGridQueryIndexing.class;
        srv = this.startGrid(0);
        normalNode.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        CaptureRebuildGridQueryIndexing capturingIndex = (CaptureRebuildGridQueryIndexing)srv.context().query().getIndexing();
        IndexCorruptionRebuildTest.assertFalse((boolean)capturingIndex.didRebuildIndexes());
        IndexCorruptionRebuildTest.validateIndexes(srv);
    }

    private void checkCacheToCorruptedIndexMap(Map<Integer, Set<String>> cacheToCorruptedIndexMap) {
        Set<String> idxsForCache1 = cacheToCorruptedIndexMap.get(CU.cacheId((String)CACHE_NAME_1));
        IndexCorruptionRebuildTest.assertEquals((int)2, (int)idxsForCache1.size());
        IndexCorruptionRebuildTest.assertTrue((boolean)idxsForCache1.containsAll(Arrays.asList(FAIL_IDX_1, FAIL_IDX_2)));
        Set<String> idxsForCache2 = cacheToCorruptedIndexMap.get(CU.cacheId((String)CACHE_NAME_2));
        IndexCorruptionRebuildTest.assertEquals((int)1, (int)idxsForCache2.size());
        IndexCorruptionRebuildTest.assertTrue((boolean)idxsForCache2.contains(FAIL_IDX_3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void corruptIndex(IgniteEx srv, IgniteH2Indexing indexing, String cacheName, String idxName) throws IgniteCheckedException {
        PageMemoryEx mem = (PageMemoryEx)srv.context().cache().context().cacheContext(CU.cacheId((String)cacheName)).dataRegion().pageMemory();
        Collection tables = indexing.schemaManager().tablesForCache(cacheName);
        for (H2TableDescriptor descriptor : tables) {
            H2TreeIndex index = (H2TreeIndex)descriptor.table().getIndex(idxName);
            int segments = index.segmentsCount();
            for (int segment = 0; segment < segments; ++segment) {
                H2Tree tree = index.treeForRead(segment);
                GridCacheDatabaseSharedManager manager = this.dbMgr(srv);
                manager.checkpointReadLock();
                try {
                    this.corruptTreeRoot(mem, tree.groupId(), tree.getMetaPageId());
                    continue;
                }
                finally {
                    manager.checkpointReadUnlock();
                }
            }
        }
    }

    private static void validateIndexes(IgniteEx node) throws Exception {
        ValidateIndexesClosure clo = new ValidateIndexesClosure(() -> false, null, 0, 0, false, true);
        node.context().resource().injectGeneric((Object)clo);
        VisorValidateIndexesJobResult call = clo.call();
        IndexCorruptionRebuildTest.assertFalse((boolean)call.hasIssues());
    }

    private void checkIndexCorruption(MaintenanceRegistry registry, IgniteCache<Integer, Integer> cache, String tableName, List<String> colNames) {
        List<SqlFieldsQuery> queries = colNames.stream().map(colName -> new SqlFieldsQuery(String.format("select * from %s where %s=?1", tableName, colName)).setArgs(new Object[]{TABLE_NAME_2})).collect(Collectors.toList());
        queries.forEach(query -> {
            try {
                cache.query(query).getAll();
                IndexCorruptionRebuildTest.fail((String)"Should've failed with CorruptedTreeException");
            }
            catch (CacheException e) {
                MaintenanceTask task = registry.requestedTask("indexRebuildMaintenanceTask");
                IndexCorruptionRebuildTest.assertNotNull((Object)task);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void corruptTreeRoot(PageMemoryEx pageMemory, int grpId, long metaPageId) throws IgniteCheckedException {
        long leafId = this.findFirstLeafId(grpId, metaPageId, pageMemory);
        if (leafId != 0L) {
            long leafPage = pageMemory.acquirePage(grpId, leafId);
            try {
                long leafPageAddr = pageMemory.writeLock(grpId, leafId, leafPage);
                try {
                    H2LeafIO io = (H2LeafIO)PageIO.getBPlusIO((long)leafPageAddr);
                    for (int idx = 0; idx < io.getCount(leafPageAddr); ++idx) {
                        PageUtils.putLong((long)leafPageAddr, (int)(io.offset(idx) + io.getPayloadSize()), (long)0L);
                    }
                }
                finally {
                    pageMemory.writeUnlock(grpId, leafId, leafPage, Boolean.valueOf(true), true);
                }
            }
            finally {
                pageMemory.releasePage(grpId, leafId, leafPage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findFirstLeafId(int grpId, long metaPageId, PageMemoryEx partPageMemory) throws IgniteCheckedException {
        long metaPage = partPageMemory.acquirePage(grpId, metaPageId);
        try {
            long l;
            long metaPageAddr = partPageMemory.readLock(grpId, metaPageId, metaPage);
            try {
                BPlusMetaIO metaIO = (BPlusMetaIO)PageIO.getPageIO((long)metaPageAddr);
                l = metaIO.getFirstPageId(metaPageAddr, 0);
            }
            catch (Throwable throwable) {
                partPageMemory.readUnlock(grpId, metaPageId, metaPage);
                throw throwable;
            }
            partPageMemory.readUnlock(grpId, metaPageId, metaPage);
            return l;
        }
        finally {
            partPageMemory.releasePage(grpId, metaPageId, metaPage);
        }
    }

    private Map<String, DurableBackgroundTaskState<?>> tasks(DurableBackgroundTasksProcessor proc) {
        return (Map)GridTestUtils.getFieldValue((Object)proc, (String[])new String[]{"tasks"});
    }

    public static class CaptureRebuildGridQueryIndexing
    extends IgniteH2Indexing {
        private volatile boolean rebuiltIndexes;

        public IgniteInternalFuture<?> rebuildIndexesFromHash(GridCacheContext cctx, boolean force) {
            IgniteInternalFuture future = super.rebuildIndexesFromHash(cctx, force);
            this.rebuiltIndexes = future != null;
            return future;
        }

        public boolean didRebuildIndexes() {
            return this.rebuiltIndexes;
        }
    }
}

