/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.util.typedef.F;
import org.junit.Test;

public abstract class H2DynamicIndexAbstractSelfTest
extends AbstractSchemaSelfTest {
    private static final int CLIENT = 2;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        for (IgniteConfiguration cfg : this.configurations()) {
            Ignition.start((IgniteConfiguration)cfg);
        }
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.createSqlCache(this.client(), this.cacheConfiguration());
        H2DynamicIndexAbstractSelfTest.assertNoIndex("cache", TBL_NAME_ESCAPED, "idx_1");
        IgniteCache cache = this.client().cache("cache");
        cache.put((Object)new AbstractSchemaSelfTest.KeyClass(1L), (Object)new AbstractSchemaSelfTest.ValueClass(1L));
        cache.put((Object)new AbstractSchemaSelfTest.KeyClass(2L), (Object)new AbstractSchemaSelfTest.ValueClass(2L));
        cache.put((Object)new AbstractSchemaSelfTest.KeyClass(3L), (Object)new AbstractSchemaSelfTest.ValueClass(3L));
    }

    protected void afterTest() throws Exception {
        this.destroySqlCache(this.client());
        super.afterTest();
    }

    @Test
    public void testCreateIndex() throws Exception {
        IgniteCache<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cache = this.cache();
        this.assertSize(3L);
        cache.query(new SqlFieldsQuery("CREATE INDEX \"idx_1\" ON \"" + TBL_NAME_ESCAPED + "\"(\"" + "field1" + "\" ASC)")).getAll();
        for (int i = 0; i < 4; ++i) {
            if (this.ignite(i).configuration().isClientMode().booleanValue()) continue;
            List locRes = this.ignite(i).cache("cache").query(new SqlFieldsQuery("explain select \"id\" from \"cache\".\"ValueClass\" where \"field1\" = 1").setLocal(true)).getAll();
            H2DynamicIndexAbstractSelfTest.assertEquals((Object)F.asList(Collections.singletonList("SELECT\n    \"id\"\nFROM \"cache\".\"ValueClass\"\n    /* cache.idx_1: field1 = 1 */\nWHERE \"field1\" = 1")), (Object)locRes);
        }
        this.assertSize(3L);
        cache.remove((Object)new AbstractSchemaSelfTest.KeyClass(2L));
        this.assertSize(2L);
        cache.put((Object)new AbstractSchemaSelfTest.KeyClass(4L), (Object)new AbstractSchemaSelfTest.ValueClass(1L));
        this.assertSize(3L);
    }

    @Test
    public void testCreateIndexWithDuplicateName() {
        final IgniteCache<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cache = this.cache();
        cache.query(new SqlFieldsQuery("CREATE INDEX \"idx_1\" ON \"" + TBL_NAME_ESCAPED + "\"(\"" + "field1" + "\" ASC)"));
        H2DynamicIndexAbstractSelfTest.assertSqlException(new Runnable(){

            @Override
            public void run() {
                cache.query(new SqlFieldsQuery("CREATE INDEX \"idx_1\" ON \"" + AbstractSchemaSelfTest.TBL_NAME_ESCAPED + "\"(\"id\" ASC)"));
            }
        }, 3005);
    }

    @Test
    public void testCreateIndexIfNotExists() {
        IgniteCache<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cache = this.cache();
        cache.query(new SqlFieldsQuery("CREATE INDEX \"idx_1\" ON \"" + TBL_NAME_ESCAPED + "\"(\"" + "field1" + "\" ASC)"));
        cache.query(new SqlFieldsQuery("CREATE INDEX IF NOT EXISTS \"idx_1\" ON \"" + TBL_NAME_ESCAPED + "\"(\"id\" ASC)"));
    }

    @Test
    public void testDropIndex() {
        IgniteCache<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cache = this.cache();
        this.assertSize(3L);
        cache.query(new SqlFieldsQuery("CREATE INDEX \"idx_1\" ON \"" + TBL_NAME_ESCAPED + "\"(\"" + "field1" + "\" ASC)"));
        this.assertSize(3L);
        cache.query(new SqlFieldsQuery("DROP INDEX \"idx_1\""));
        for (int i = 0; i < 4; ++i) {
            if (this.ignite(i).configuration().isClientMode().booleanValue()) continue;
            List locRes = this.ignite(i).cache("cache").query(new SqlFieldsQuery("explain select \"id\" from \"cache\".\"ValueClass\" where \"field1\" = 1").setLocal(true)).getAll();
            H2DynamicIndexAbstractSelfTest.assertEquals((Object)F.asList(Collections.singletonList("SELECT\n    \"id\"\nFROM \"cache\".\"ValueClass\"\n    /* cache.ValueClass.__SCAN_ */\nWHERE \"field1\" = 1")), (Object)locRes);
        }
        this.assertSize(3L);
    }

    @Test
    public void testDropMissingIndex() {
        final IgniteCache<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cache = this.cache();
        H2DynamicIndexAbstractSelfTest.assertSqlException(new Runnable(){

            @Override
            public void run() {
                cache.query(new SqlFieldsQuery("DROP INDEX \"idx_1\""));
            }
        }, 3006);
    }

    @Test
    public void testDropMissingIndexIfExists() {
        IgniteCache<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cache = this.cache();
        cache.query(new SqlFieldsQuery("DROP INDEX IF EXISTS \"idx_1\""));
    }

    @Test
    public void testIndexState() {
        IgniteCache<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cache = this.cache();
        this.assertColumnValues(1L, 2L, 3L);
        cache.query(new SqlFieldsQuery("CREATE INDEX \"idx_1\" ON \"" + TBL_NAME_ESCAPED + "\"(\"" + "field1" + "\" ASC)"));
        this.assertColumnValues(1L, 2L, 3L);
        cache.remove((Object)new AbstractSchemaSelfTest.KeyClass(2L));
        this.assertColumnValues(1L, 3L);
        cache.put((Object)new AbstractSchemaSelfTest.KeyClass(0L), (Object)new AbstractSchemaSelfTest.ValueClass(0L));
        this.assertColumnValues(0L, 1L, 3L);
        cache.query(new SqlFieldsQuery("DROP INDEX \"idx_1\""));
        this.assertColumnValues(0L, 1L, 3L);
    }

    private void assertColumnValues(Long ... vals) {
        ArrayList<List<Long>> expRes = new ArrayList<List<Long>>(vals.length);
        for (Long v : vals) {
            expRes.add(Collections.singletonList(v));
        }
        List all = this.cache().query(new SqlFieldsQuery("SELECT \"field1\" FROM \"" + TBL_NAME_ESCAPED + "\" ORDER BY \"id\"")).getAll();
        H2DynamicIndexAbstractSelfTest.assertEquals(expRes, (Object)all);
    }

    private void assertSize(long expSize) {
        H2DynamicIndexAbstractSelfTest.assertEquals((long)expSize, (long)this.cache().size(new CachePeekMode[0]));
        Object actual = ((List)this.cache().query(new SqlFieldsQuery("SELECT COUNT(*) from \"ValueClass\"")).getAll().get(0)).get(0);
        H2DynamicIndexAbstractSelfTest.assertEquals((Object)expSize, actual);
    }

    private List<IgniteConfiguration> configurations() throws Exception {
        return Arrays.asList(this.serverConfiguration(0), this.serverConfiguration(1), this.clientConfiguration(2), this.serverConfiguration(3));
    }

    private Ignite client() {
        return this.ignite(2);
    }

    private IgniteCache<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cache() {
        return this.client().cache("cache");
    }

    private IgniteConfiguration serverConfiguration(int idx) throws Exception {
        return this.commonConfiguration(idx);
    }

    private IgniteConfiguration clientConfiguration(int idx) throws Exception {
        return this.commonConfiguration(idx).setClientMode(true);
    }

    private CacheConfiguration cacheConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration().setName("cache");
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(AbstractSchemaSelfTest.KeyClass.class.getName());
        entity.setValueType(AbstractSchemaSelfTest.ValueClass.class.getName());
        entity.addQueryField("id", Long.class.getName(), null);
        entity.addQueryField("field1", Long.class.getName(), null);
        entity.addQueryField("field2", Long.class.getName(), null);
        entity.setKeyFields(Collections.singleton("id"));
        entity.setAliases(Collections.singletonMap("field2", H2DynamicIndexAbstractSelfTest.alias("field2")));
        ccfg.setQueryEntities(Collections.singletonList(entity));
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setSqlEscapeAll(true);
        ccfg.setAtomicityMode(this.atomicityMode());
        ccfg.setCacheMode(this.cacheMode());
        ccfg.setEntryCompressionConfiguration(this.entryCompressionConfiguration());
        if (this.nearCache()) {
            ccfg.setNearConfiguration(new NearCacheConfiguration());
        }
        return ccfg;
    }

    protected abstract CacheMode cacheMode();

    protected abstract CacheAtomicityMode atomicityMode();

    protected abstract boolean nearCache();

    protected EntryCompressionConfiguration entryCompressionConfiguration() {
        return null;
    }
}

