/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.cache.index.DynamicIndexAbstractSelfTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.junit.Test;

public abstract class DynamicIndexAbstractBasicSelfTest
extends DynamicIndexAbstractSelfTest {
    protected static final int IDX_SRV_CRD = 0;
    protected static final int IDX_SRV_NON_CRD = 1;
    protected static final int IDX_CLI = 2;
    protected static final int IDX_SRV_FILTERED = 3;
    protected static final int IDX_CLI_NEAR_ONLY = 4;
    protected static final String STATIC_CACHE_NAME = "cache_static";

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        for (IgniteConfiguration cfg : this.configurations()) {
            Ignition.start((IgniteConfiguration)cfg);
        }
    }

    protected void afterTest() throws Exception {
        this.node().context().cache().dynamicDestroyCache("cache", true, true, false, null).get();
        super.afterTest();
    }

    private void initialize(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.createSqlCache((Ignite)this.node(), this.cacheConfiguration(mode, atomicityMode, near));
        this.awaitPartitionMapExchange();
        this.grid(4).getOrCreateNearCache("cache", new NearCacheConfiguration());
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
        this.loadInitialData();
    }

    private CacheConfiguration<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cacheConfiguration(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) {
        CacheConfiguration<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> ccfg = this.cacheConfiguration();
        ccfg.setCacheMode(mode);
        ccfg.setAtomicityMode(atomicityMode);
        if (near) {
            ccfg.setNearConfiguration(new NearCacheConfiguration());
        }
        return ccfg;
    }

    private void loadInitialData() {
        DynamicIndexAbstractBasicSelfTest.put((Ignite)this.node(), 0, 100);
    }

    @Test
    public void testCreatePartitionedAtomic() throws Exception {
        this.checkCreate(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testCreatePartitionedAtomicNear() throws Exception {
        this.checkCreate(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    @Test
    public void testCreatePartitionedTransactional() throws Exception {
        this.checkCreate(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    @Test
    public void testCreatePartitionedTransactionalNear() throws Exception {
        this.checkCreate(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    @Test
    public void testCreateReplicatedAtomic() throws Exception {
        this.checkCreate(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testCreateReplicatedTransactional() throws Exception {
        this.checkCreate(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreate(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        final QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("IDX_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        this.dynamicIndexCreate("cache", TBL_NAME, idx, false, 0);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "IDX_1", -1, DynamicIndexAbstractBasicSelfTest.field("field1"));
        DynamicIndexAbstractBasicSelfTest.assertIgniteSqlException((Runnable)new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, false, 0);
            }
        }, 3005);
        this.dynamicIndexCreate("cache", TBL_NAME, idx, true, 0);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "IDX_1", -1, DynamicIndexAbstractBasicSelfTest.field("field1"));
        this.assertSimpleIndexOperations(SQL_SIMPLE_FIELD_1);
        DynamicIndexAbstractBasicSelfTest.assertIndexUsed("IDX_1", SQL_SIMPLE_FIELD_1, 40);
    }

    @Test
    public void testCreateCompositePartitionedAtomic() throws Exception {
        this.checkCreateComposite(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testCreateCompositePartitionedAtomicNear() throws Exception {
        this.checkCreateComposite(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    @Test
    public void testCreateCompositePartitionedTransactional() throws Exception {
        this.checkCreateComposite(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    @Test
    public void testCreateCompositePartitionedTransactionalNear() throws Exception {
        this.checkCreateComposite(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    @Test
    public void testCreateCompositeReplicatedAtomic() throws Exception {
        this.checkCreateComposite(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testCreateCompositeReplicatedTransactional() throws Exception {
        this.checkCreateComposite(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreateComposite(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("IDX_1", DynamicIndexAbstractBasicSelfTest.field("field1"), DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
        this.dynamicIndexCreate("cache", TBL_NAME, idx, false, 0);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "IDX_1", -1, DynamicIndexAbstractBasicSelfTest.field("field1"), DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
        this.assertCompositeIndexOperations(SQL_COMPOSITE);
        DynamicIndexAbstractBasicSelfTest.assertIndexUsed("IDX_1", SQL_COMPOSITE, 40, 80);
    }

    @Test
    public void testCreateIndexNoCachePartitionedAtomic() throws Exception {
        this.checkCreateNotCache(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testCreateIndexNoCachePartitionedAtomicNear() throws Exception {
        this.checkCreateNotCache(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    @Test
    public void testCreateIndexNoCachePartitionedTransactional() throws Exception {
        this.checkCreateNotCache(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    @Test
    public void testCreateIndexNoCachePartitionedTransactionalNear() throws Exception {
        this.checkCreateNotCache(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    @Test
    public void testCreateIndexNoCacheReplicatedAtomic() throws Exception {
        this.checkCreateNotCache(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testCreateIndexNoCacheReplicatedTransactional() throws Exception {
        this.checkCreateNotCache(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreateNotCache(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("IDX_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        try {
            String cacheName = DynamicIndexAbstractBasicSelfTest.randomString();
            DynamicIndexAbstractBasicSelfTest.queryProcessor(this.node()).dynamicIndexCreate(cacheName, cacheName, TBL_NAME, idx, false, 0).get();
        }
        catch (SchemaOperationException e) {
            DynamicIndexAbstractBasicSelfTest.assertEquals((int)1, (int)e.code());
            DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
            return;
        }
        catch (Exception e) {
            DynamicIndexAbstractBasicSelfTest.fail((String)("Unexpected exception: " + e));
        }
        DynamicIndexAbstractBasicSelfTest.fail((String)(SchemaOperationException.class.getSimpleName() + " is not thrown."));
    }

    @Test
    public void testCreateNoTablePartitionedAtomic() throws Exception {
        this.checkCreateNoTable(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testCreateNoTablePartitionedAtomicNear() throws Exception {
        this.checkCreateNoTable(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    @Test
    public void testCreateNoTablePartitionedTransactional() throws Exception {
        this.checkCreateNoTable(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    @Test
    public void testCreateNoTablePartitionedTransactionalNear() throws Exception {
        this.checkCreateNoTable(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    @Test
    public void testCreateNoTableReplicatedAtomic() throws Exception {
        this.checkCreateNoTable(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testCreateNoTableReplicatedTransactional() throws Exception {
        this.checkCreateNoTable(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreateNoTable(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        final QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("IDX_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        DynamicIndexAbstractBasicSelfTest.assertIgniteSqlException((Runnable)new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexCreate("cache", DynamicIndexAbstractSelfTest.randomString(), idx, false, 0);
            }
        }, 3001);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
    }

    @Test
    public void testCreateIndexNoColumnPartitionedAtomic() throws Exception {
        this.checkCreateIndexNoColumn(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testCreateIndexNoColumnPartitionedAtomicNear() throws Exception {
        this.checkCreateIndexNoColumn(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    @Test
    public void testCreateIndexNoColumnPartitionedTransactional() throws Exception {
        this.checkCreateIndexNoColumn(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    @Test
    public void testCreateIndexNoColumnPartitionedTransactionalNear() throws Exception {
        this.checkCreateIndexNoColumn(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    @Test
    public void testCreateIndexNoColumnReplicatedAtomic() throws Exception {
        this.checkCreateIndexNoColumn(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testCreateIndexNoColumnReplicatedTransactional() throws Exception {
        this.checkCreateIndexNoColumn(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreateIndexNoColumn(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        final QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("IDX_1", DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.randomString()));
        DynamicIndexAbstractBasicSelfTest.assertIgniteSqlException((Runnable)new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, false, 0);
            }
        }, 3008);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
    }

    @Test
    public void testCreateIndexOnColumnWithAliasPartitionedAtomic() throws Exception {
        this.checkCreateIndexOnColumnWithAlias(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testCreateIndexOnColumnWithAliasPartitionedAtomicNear() throws Exception {
        this.checkCreateIndexOnColumnWithAlias(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    @Test
    public void testCreateIndexOnColumnWithAliasPartitionedTransactional() throws Exception {
        this.checkCreateIndexOnColumnWithAlias(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    @Test
    public void testCreateColumnWithAliasPartitionedTransactionalNear() throws Exception {
        this.checkCreateIndexOnColumnWithAlias(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    @Test
    public void testCreateColumnWithAliasReplicatedAtomic() throws Exception {
        this.checkCreateIndexOnColumnWithAlias(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testCreateColumnWithAliasReplicatedTransactional() throws Exception {
        this.checkCreateIndexOnColumnWithAlias(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreateIndexOnColumnWithAlias(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        DynamicIndexAbstractBasicSelfTest.assertIgniteSqlException((Runnable)new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                QueryIndex idx = AbstractSchemaSelfTest.index("IDX_1", AbstractSchemaSelfTest.field("field2"));
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, false, 0);
            }
        }, 3008);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
        QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("IDX_1", DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
        this.dynamicIndexCreate("cache", TBL_NAME, idx, false, 0);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "IDX_1", -1, DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
        this.assertSimpleIndexOperations(SQL_SIMPLE_FIELD_2);
        DynamicIndexAbstractBasicSelfTest.assertIndexUsed("IDX_1", SQL_SIMPLE_FIELD_2, 40);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", value="true")
    public void testCreateIndexWithInlineSizePartitionedAtomic() throws Exception {
        this.checkCreateIndexWithInlineSize(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", value="true")
    public void testCreateIndexWithInlineSizePartitionedAtomicNear() throws Exception {
        this.checkCreateIndexWithInlineSize(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", value="true")
    public void testCreateIndexWithInlineSizePartitionedTransactional() throws Exception {
        this.checkCreateIndexWithInlineSize(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", value="true")
    public void testCreateIndexWithInlineSizePartitionedTransactionalNear() throws Exception {
        this.checkCreateIndexWithInlineSize(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", value="true")
    public void testCreateIndexWithInlineSizeReplicatedAtomic() throws Exception {
        this.checkCreateIndexWithInlineSize(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", value="true")
    public void testCreateIndexWithInlineSizeReplicatedTransactional() throws Exception {
        this.checkCreateIndexWithInlineSize(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreateIndexWithInlineSize(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        this.checkNoIndexIsCreatedForInlineSize(-2, 1001);
        this.checkNoIndexIsCreatedForInlineSize(Integer.MIN_VALUE, 1001);
        this.checkIndexCreatedForInlineSize(0);
        this.loadInitialData();
        this.checkIndexCreatedForInlineSize(1);
        this.loadInitialData();
        this.checkIndexCreatedForInlineSize(30);
    }

    private void checkIndexCreatedForInlineSize(int inlineSize) throws Exception {
        QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("IDX_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        idx.setInlineSize(inlineSize);
        this.dynamicIndexCreate("cache", TBL_NAME, idx, false, 0);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "IDX_1", inlineSize, DynamicIndexAbstractBasicSelfTest.field("field1"));
        this.assertSimpleIndexOperations(SQL_SIMPLE_FIELD_1);
        DynamicIndexAbstractBasicSelfTest.assertIndexUsed("IDX_1", SQL_SIMPLE_FIELD_1, 40);
        this.dynamicIndexDrop("cache", "IDX_1", false);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
    }

    private void checkNoIndexIsCreatedForInlineSize(final int inlineSize, int igniteQryErrorCode) throws Exception {
        DynamicIndexAbstractBasicSelfTest.assertIgniteSqlException((Runnable)new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                QueryIndex idx = AbstractSchemaSelfTest.index("IDX_1", AbstractSchemaSelfTest.field("field1"));
                idx.setInlineSize(inlineSize);
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, false, 0);
            }
        }, igniteQryErrorCode);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", value="true")
    public void testCreateIndexWithParallelismPartitionedAtomic() throws Exception {
        this.checkCreateIndexWithParallelism(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", value="true")
    public void testCreateIndexWithParallelismPartitionedAtomicNear() throws Exception {
        this.checkCreateIndexWithParallelism(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", value="true")
    public void testCreateIndexWithParallelismPartitionedTransactional() throws Exception {
        this.checkCreateIndexWithParallelism(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", value="true")
    public void testCreateIndexWithParallelismPartitionedTransactionalNear() throws Exception {
        this.checkCreateIndexWithParallelism(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", value="true")
    public void testCreateIndexWithParallelismReplicatedAtomic() throws Exception {
        this.checkCreateIndexWithParallelism(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", value="true")
    public void testCreateIndexWithParallelismReplicatedTransactional() throws Exception {
        this.checkCreateIndexWithParallelism(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreateIndexWithParallelism(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        this.checkNoIndexIsCreatedForParallelism(-2, 1001);
        this.checkNoIndexIsCreatedForParallelism(Integer.MIN_VALUE, 1001);
        this.checkIndexCreatedForParallelism(0);
        this.loadInitialData();
        this.checkIndexCreatedForParallelism(1);
        this.loadInitialData();
        this.checkIndexCreatedForParallelism(5);
    }

    private void checkIndexCreatedForParallelism(int parallel) throws Exception {
        QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("IDX_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        this.dynamicIndexCreate("cache", TBL_NAME, idx, false, parallel);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "IDX_1", -1, DynamicIndexAbstractBasicSelfTest.field("field1"));
        this.assertSimpleIndexOperations(SQL_SIMPLE_FIELD_1);
        DynamicIndexAbstractBasicSelfTest.assertIndexUsed("IDX_1", SQL_SIMPLE_FIELD_1, 40);
        this.dynamicIndexDrop("cache", "IDX_1", false);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
    }

    private void checkNoIndexIsCreatedForParallelism(final int parallel, int igniteQryErrorCode) throws Exception {
        DynamicIndexAbstractBasicSelfTest.assertIgniteSqlException((Runnable)new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                QueryIndex idx = AbstractSchemaSelfTest.index("IDX_1", AbstractSchemaSelfTest.field("field1"));
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, false, parallel);
            }
        }, igniteQryErrorCode);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
    }

    @Test
    public void testDropPartitionedAtomic() throws Exception {
        this.checkDrop(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testDropPartitionedAtomicNear() throws Exception {
        this.checkDrop(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    @Test
    public void testDropPartitionedTransactional() throws Exception {
        this.checkDrop(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    @Test
    public void testDropPartitionedTransactionalNear() throws Exception {
        this.checkDrop(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    @Test
    public void testDropReplicatedAtomic() throws Exception {
        this.checkDrop(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testDropReplicatedTransactional() throws Exception {
        this.checkDrop(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    public void checkDrop(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        QueryIndex idx1 = DynamicIndexAbstractBasicSelfTest.index("IDX_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        this.dynamicIndexCreate("cache", TBL_NAME, idx1, false, 0);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "IDX_1", -1, DynamicIndexAbstractBasicSelfTest.field("field1"));
        DynamicIndexAbstractBasicSelfTest.assertIndexUsed("IDX_1", SQL_SIMPLE_FIELD_1, 40);
        this.assertSimpleIndexOperations(SQL_SIMPLE_FIELD_1);
        QueryIndex idx2 = DynamicIndexAbstractBasicSelfTest.index("IDX_2", DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
        this.dynamicIndexCreate("cache", TBL_NAME, idx2, false, 0);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "IDX_2", -1, DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
        this.loadInitialData();
        this.dynamicIndexDrop("cache", "IDX_1", false);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
        this.assertSimpleIndexOperations(SQL_SIMPLE_FIELD_1);
        DynamicIndexAbstractBasicSelfTest.assertIndexNotUsed("IDX_1", SQL_SIMPLE_FIELD_1, 40);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "IDX_2", -1, DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
    }

    @Test
    public void testDropNoIndexPartitionedAtomic() throws Exception {
        this.checkDropNoIndex(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testDropNoIndexPartitionedAtomicNear() throws Exception {
        this.checkDropNoIndex(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    @Test
    public void testDropNoIndexPartitionedTransactional() throws Exception {
        this.checkDropNoIndex(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    @Test
    public void testDropNoIndexPartitionedTransactionalNear() throws Exception {
        this.checkDropNoIndex(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    @Test
    public void testDropNoIndexReplicatedAtomic() throws Exception {
        this.checkDropNoIndex(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testDropNoIndexReplicatedTransactional() throws Exception {
        this.checkDropNoIndex(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkDropNoIndex(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        DynamicIndexAbstractBasicSelfTest.assertIgniteSqlException((Runnable)new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexDrop("cache", "IDX_1", false);
            }
        }, 3006);
        this.dynamicIndexDrop("cache", "IDX_1", true);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
    }

    @Test
    public void testDropNoCachePartitionedAtomic() throws Exception {
        this.checkDropNoCache(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testDropNoCachePartitionedAtomicNear() throws Exception {
        this.checkDropNoCache(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    @Test
    public void testDropNoCachePartitionedTransactional() throws Exception {
        this.checkDropNoCache(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    @Test
    public void testDropNoCachePartitionedTransactionalNear() throws Exception {
        this.checkDropNoCache(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    @Test
    public void testDropNoCacheReplicatedAtomic() throws Exception {
        this.checkDropNoCache(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    @Test
    public void testDropNoCacheReplicatedTransactional() throws Exception {
        this.checkDropNoCache(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkDropNoCache(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        try {
            String cacheName = DynamicIndexAbstractBasicSelfTest.randomString();
            DynamicIndexAbstractBasicSelfTest.queryProcessor(this.node()).dynamicIndexDrop(cacheName, cacheName, "my_idx", false).get();
        }
        catch (SchemaOperationException e) {
            DynamicIndexAbstractBasicSelfTest.assertEquals((int)1, (int)e.code());
            DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
            return;
        }
        catch (Exception e) {
            DynamicIndexAbstractBasicSelfTest.fail((String)("Unexpected exception: " + e));
        }
        DynamicIndexAbstractBasicSelfTest.fail((String)(SchemaOperationException.class.getSimpleName() + " is not thrown."));
    }

    @Test
    public void testFailOnLocalCache() throws Exception {
        for (Ignite node : Ignition.allGrids()) {
            if (node.configuration().isClientMode().booleanValue()) continue;
            this.createSqlCache(node, this.localCacheConfiguration());
        }
        final QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("IDX_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        DynamicIndexAbstractBasicSelfTest.assertIgniteSqlException((Runnable)new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, true, 0);
            }
        }, 1002);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "IDX_1");
        DynamicIndexAbstractBasicSelfTest.assertIgniteSqlException((Runnable)new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexDrop("cache", "IDX_LOC", true);
            }
        }, 1002);
    }

    @Test
    public void testNonSqlCache() throws Exception {
        QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("IDX_2", DynamicIndexAbstractBasicSelfTest.field("FIELD1"));
        this.dynamicIndexCreate(STATIC_CACHE_NAME, TBL_NAME, idx, true, 0);
        DynamicIndexAbstractBasicSelfTest.assertIndex(STATIC_CACHE_NAME, TBL_NAME, "IDX_1", -1, DynamicIndexAbstractBasicSelfTest.field("field1"));
        this.dynamicIndexDrop(STATIC_CACHE_NAME, "IDX_1", true);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex(STATIC_CACHE_NAME, TBL_NAME, "IDX_1");
    }

    @Test
    public void testIndexNameCaseSensitivity() throws Exception {
        this.doTestIndexNameCaseSensitivity("myIdx", false);
        this.doTestIndexNameCaseSensitivity("myIdx", true);
    }

    private void doTestIndexNameCaseSensitivity(String idxName, boolean sensitive) throws Exception {
        String idxNameSql = sensitive ? '\"' + idxName + '\"' : idxName;
        this.assertIndexNameIsValid(idxNameSql, idxNameSql);
        if (sensitive) {
            this.assertIndexNameIsNotValid(idxNameSql, idxName.toUpperCase());
            this.assertIndexNameIsNotValid(idxNameSql, idxName.toLowerCase());
        } else {
            this.assertIndexNameIsValid(idxNameSql, '\"' + idxName.toUpperCase() + '\"');
            this.assertIndexNameIsValid(idxNameSql, idxName.toUpperCase());
            this.assertIndexNameIsValid(idxNameSql, idxName.toLowerCase());
        }
    }

    private void assertIndexNameIsValid(String idxNameToCreate, String checkedIdxName) throws Exception {
        this.info("Checking index name variant for validity: " + checkedIdxName);
        QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index(idxNameToCreate, DynamicIndexAbstractBasicSelfTest.field("FIELD1"));
        this.dynamicIndexCreate(STATIC_CACHE_NAME, TBL_NAME, idx, true, 0);
        this.dynamicIndexDrop(STATIC_CACHE_NAME, checkedIdxName, false);
    }

    private void assertIndexNameIsNotValid(String idxNameToCreate, final String checkedIdxName) throws Exception {
        this.info("Checking index name variant for invalidity: " + checkedIdxName);
        QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index(idxNameToCreate, DynamicIndexAbstractBasicSelfTest.field("FIELD1"));
        this.dynamicIndexCreate(STATIC_CACHE_NAME, TBL_NAME, idx, true, 0);
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexDrop(DynamicIndexAbstractBasicSelfTest.STATIC_CACHE_NAME, checkedIdxName, false);
                return null;
            }
        }, IgniteSQLException.class, (String)("Index doesn't exist: " + checkedIdxName.toUpperCase()));
    }

    protected IgniteEx node() {
        return this.grid(this.nodeIndex());
    }

    protected abstract int nodeIndex();

    protected List<IgniteConfiguration> configurations() throws Exception {
        return Arrays.asList(this.serverCoordinatorConfiguration(0), this.serverConfiguration(1), this.clientConfiguration(2), this.serverConfiguration(3, true), this.clientConfiguration(4));
    }

    @Override
    protected IgniteConfiguration commonConfiguration(int idx) throws Exception {
        IgniteConfiguration cfg = super.commonConfiguration(idx);
        if (idx != this.nodeIndex()) {
            return cfg;
        }
        CacheConfiguration staticCacheCfg = this.cacheConfiguration().setName(STATIC_CACHE_NAME);
        ((QueryEntity)staticCacheCfg.getQueryEntities().iterator().next()).setIndexes(Collections.singletonList(DynamicIndexAbstractBasicSelfTest.index("IDX_1", DynamicIndexAbstractBasicSelfTest.field("FIELD1"))));
        CacheConfiguration[] newCfgs = new CacheConfiguration[F.isEmpty((Object[])cfg.getCacheConfiguration()) ? 1 : cfg.getCacheConfiguration().length + 1];
        if (newCfgs.length > 1) {
            System.arraycopy(cfg.getCacheConfiguration(), 0, newCfgs, 0, newCfgs.length - 1);
        }
        newCfgs[newCfgs.length - 1] = staticCacheCfg;
        cfg.setCacheConfiguration(newCfgs);
        return cfg;
    }

    protected IgniteConfiguration serverCoordinatorConfiguration(int idx) throws Exception {
        return this.serverConfiguration(idx);
    }

    private void assertSimpleIndexOperations(String sql) {
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlSimpleData(node, sql, 60);
        }
        DynamicIndexAbstractBasicSelfTest.put((Ignite)this.node(), 100, 200);
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlSimpleData(node, sql, 160);
        }
        DynamicIndexAbstractBasicSelfTest.remove((Ignite)this.node(), 0, 100);
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlSimpleData(node, sql, 100);
        }
        DynamicIndexAbstractBasicSelfTest.remove((Ignite)this.node(), 100, 200);
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlSimpleData(node, sql, 0);
        }
    }

    private void assertCompositeIndexOperations(String sql) {
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlCompositeData(node, sql, 20);
        }
        DynamicIndexAbstractBasicSelfTest.put((Ignite)this.node(), 100, 200);
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlCompositeData(node, sql, 120);
        }
        DynamicIndexAbstractBasicSelfTest.remove((Ignite)this.node(), 0, 100);
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlCompositeData(node, sql, 100);
        }
        DynamicIndexAbstractBasicSelfTest.remove((Ignite)this.node(), 100, 200);
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlCompositeData(node, sql, 0);
        }
    }

    protected static void assertIgniteSqlException(Runnable r, int expCode) {
        DynamicIndexAbstractBasicSelfTest.assertIgniteSqlException(r, null, expCode);
    }

    private static void assertIgniteSqlException(Runnable r, String msg, int expCode) {
        try {
            r.run();
        }
        catch (IgniteException ie) {
            DynamicIndexAbstractBasicSelfTest.assertTrue((String)("Unexpected exception: " + (Object)((Object)ie)), (boolean)(ie.getCause() instanceof CacheException));
            DynamicIndexAbstractBasicSelfTest.checkCacheException(msg, expCode, (CacheException)ie.getCause());
            return;
        }
        catch (CacheException e) {
            DynamicIndexAbstractBasicSelfTest.checkCacheException(msg, expCode, e);
            return;
        }
        catch (Exception e) {
            DynamicIndexAbstractBasicSelfTest.fail((String)("Unexpected exception: " + e));
        }
        DynamicIndexAbstractBasicSelfTest.fail((String)(IgniteSQLException.class.getSimpleName() + " is not thrown."));
    }

    private static void checkCacheException(String msg, int expCode, CacheException e) {
        Throwable cause = e.getCause();
        DynamicIndexAbstractBasicSelfTest.assertTrue((cause != null ? 1 : 0) != 0);
        DynamicIndexAbstractBasicSelfTest.assertTrue((String)("Unexpected cause: " + cause.getClass().getName()), (boolean)(cause instanceof IgniteSQLException));
        IgniteSQLException cause0 = (IgniteSQLException)cause;
        int code = cause0.statusCode();
        DynamicIndexAbstractBasicSelfTest.assertEquals((String)("Unexpected error code [expected=" + expCode + ", actual=" + code + ", msg=" + cause.getMessage() + ']'), (int)expCode, (int)code);
        if (msg != null) {
            DynamicIndexAbstractBasicSelfTest.assertEquals((String)("Unexpected error message [expected=" + msg + ", actual=" + cause0.getMessage() + ']'), (String)msg, (String)cause0.getMessage());
        }
    }

    private void dynamicIndexCreate(String cacheName, String tblName, QueryIndex idx, boolean ifNotExists, int parallel) throws Exception {
        this.dynamicIndexCreate((Ignite)this.node(), cacheName, tblName, idx, ifNotExists, parallel);
    }

    private void dynamicIndexDrop(String cacheName, String idxName, boolean ifExists) throws Exception {
        this.dynamicIndexDrop((Ignite)this.node(), cacheName, idxName, ifExists);
    }
}

