/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.value.ValueTime;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class BasicSqlTypesIndexTest
extends AbstractIndexingCommonTest {
    private static final int DATSET_SIZE = 1000;
    private static final AtomicInteger TBL_ID = new AtomicInteger();
    private static final String CREATE_TBL_PK_ONLY_TEMPLATE = "CREATE TABLE \"%s\" (idxVal %s PRIMARY KEY, val INT) WITH \"%s\"";
    private static final String CREATE_TBL_SECONDARY_INDEX_TEMPLATE = "CREATE TABLE \"%s\" (id INT PRIMARY KEY, idxVal %s, val INT) WITH \"%s\"";
    private static final String CREATE_SECONDARY_INDEX_TEMPLATE = "CREATE INDEX \"%s\" ON \"%s\"(idxVal %s)";
    private static final String SELECT_ORDERED_RANGE_TEMPLATE = "SELECT val FROM \"%s\" USE INDEX(\"%s\") WHERE %s <= ? ORDER BY %s ASC";
    private static final String SELECT_VALUE_TEMPLATE = "SELECT val, idxVal FROM \"%s\" USE INDEX(\"%s\") WHERE %s = ?";
    private static final String INSERT_PK_ONLY_TEMPLATE = "INSERT INTO \"%s\" (idxVal, val) VALUES (?, ?)";
    private static final String INSERT_SECONDARY_TEMPLATE = "INSERT INTO \"%s\" (id, idxVal, val) VALUES (?, ?, ?)";
    private static final String UPDATE_VAL_TEMPLATE = "UPDATE \"%s\" SET val=? WHERE idxVal=?";
    private int decimalPrecision;
    private int maxStrLen;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
    }

    @Before
    public void clearState() {
        this.decimalPrecision = -1;
        this.maxStrLen = 40;
    }

    @Test
    public void testSqlBooleanTypeIndex() {
        String idxTypeStr = "BOOLEAN";
        Class<Boolean> idxCls = Boolean.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, Boolean::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Boolean::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Boolean::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Boolean::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlBigintTypeIndex() {
        String idxTypeStr = "BIGINT";
        Class<Long> idxCls = Long.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, Long::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Long::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Long::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Long::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlDecimalTypeIndex() {
        String idxTypeStr = "DECIMAL";
        Class<BigDecimal> idxCls = BigDecimal.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, BigDecimal::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, BigDecimal::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, BigDecimal::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, BigDecimal::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlDecimalFixedPrecisionTypeIndex() {
        this.decimalPrecision = 3;
        String idxTypeStr = "DECIMAL(20,3)";
        Class<BigDecimal> idxCls = BigDecimal.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, BigDecimal::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, BigDecimal::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, BigDecimal::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, BigDecimal::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlNumericTypeIndex() {
        this.decimalPrecision = 0;
        String idxTypeStr = "NUMERIC(10)";
        Class<BigDecimal> idxCls = BigDecimal.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, BigDecimal::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, BigDecimal::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, BigDecimal::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, BigDecimal::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlDoubleTypeIndex() {
        String idxTypeStr = "DOUBLE";
        Class<Double> idxCls = Double.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, Double::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Double::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Double::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Double::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlIntTypeIndex() {
        String idxTypeStr = "INT";
        Class<Integer> idxCls = Integer.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, Integer::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Integer::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Integer::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Integer::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlRealTypeIndex() {
        String idxTypeStr = "REAL";
        Class<Float> idxCls = Float.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, Float::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Float::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Float::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Float::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlTinyintTypeIndex() {
        String idxTypeStr = "TINYINT";
        Class<Byte> idxCls = Byte.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, Byte::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Byte::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Byte::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Byte::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlSmallintTypeIndex() {
        String idxTypeStr = "SMALLINT";
        Class<Short> idxCls = Short.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, Short::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Short::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Short::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Short::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlVarcharTypeIndex() {
        String idxTypeStr = "VARCHAR";
        Class<String> idxCls = String.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, String::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, String::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, String::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, String::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlCharTypeIndex() {
        this.maxStrLen = 10;
        String idxTypeStr = "CHAR(10)";
        Class<String> idxCls = String.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, String::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, String::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, String::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, String::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlDateTypeIndex() {
        String idxTypeStr = "DATE";
        Class<Date> idxCls = Date.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, java.util.Date::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, java.util.Date::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Ignore(value="GG-34036")
    @Test
    public void testSqlTimeTypeIndex() {
        String idxTypeStr = "TIME";
        Class<Time> idxCls = Time.class;
        Comparator<Time> comp = new Comparator<Time>(){

            @Override
            public int compare(Time o1, Time o2) {
                GregorianCalendar cal = new GregorianCalendar();
                long l1 = DateTimeUtils.convertTime((Time)o1, (Calendar)cal).getNanos();
                long l2 = DateTimeUtils.convertTime((Time)o2, (Calendar)cal).getNanos();
                return Long.compare(l1, l2);
            }
        };
        int i = -1143442969;
        BasicSqlTypesIndexTest.assertEquals((long)i, (long)new Time(i).getTime());
        BasicSqlTypesIndexTest.assertEquals((long)i, (long)ValueTime.get((Time)new Time(i)).getTime().getTime());
        this.createPopulateAndVerify(idxTypeStr, idxCls, comp, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, comp, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, comp, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, comp, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlTimestampTypeIndex() {
        String idxTypeStr = "TIMESTAMP";
        Class<Timestamp> idxCls = Timestamp.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, Timestamp::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Timestamp::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Timestamp::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, Timestamp::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlBynaryTypeIndex() {
        String idxTypeStr = "BINARY";
        Class<byte[]> idxCls = byte[].class;
        Comparator<byte[]> comp = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                int len = Math.min(o1.length, o2.length);
                for (int i = 0; i < len; ++i) {
                    int res = Byte.compare(o1[i], o2[i]);
                    if (res == 0) continue;
                    return res;
                }
                return Integer.compare(o1.length, o2.length);
            }
        };
        this.createPopulateAndVerify(idxTypeStr, idxCls, comp, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, comp, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testSqlUuidTypeIndex() {
        String idxTypeStr = "UUID";
        Class<UUID> idxCls = UUID.class;
        this.createPopulateAndVerify(idxTypeStr, idxCls, UUID::compareTo, IndexType.PK, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, UUID::compareTo, IndexType.PK, "BACKUPS=1,AFFINITY_KEY=idxVal");
        this.createPopulateAndVerify(idxTypeStr, idxCls, UUID::compareTo, IndexType.SECONDARY_DESC, "BACKUPS=1");
        this.createPopulateAndVerify(idxTypeStr, idxCls, UUID::compareTo, IndexType.SECONDARY_ASC, "BACKUPS=1");
    }

    @Test
    public void testGroupByAndIndexHint() {
        this.execSql("CREATE TABLE T1 (id INT PRIMARY KEY, val1 INT, val2 INT, val3 INT)", new Object[0]);
        this.execSql("CREATE TABLE T2 (id INT PRIMARY KEY, val1 INT, val2 INT, val3 INT)", new Object[0]);
        this.execSql("CREATE INDEX IDX_ON_PREDICATE ON T1(val1)", new Object[0]);
        this.execSql("CREATE INDEX IDX_ON_GRP ON T1(val2)", new Object[0]);
        this.execSql("CREATE INDEX IDX_NOT_CHOOSE ON T1(val3)", new Object[0]);
        List<List<?>> res = this.execSql("EXPLAIN SELECT T1.id FROM T1 USE INDEX(IDX_ON_PREDICATE) INNER JOIN T2 ON T1.id = T2.id WHERE T1.val1 = 1 AND T2.val1 = 2 GROUP BY T1.val2", new Object[0]);
        String explainPlan = (String)res.get(0).get(0);
        BasicSqlTypesIndexTest.assertTrue((String)explainPlan, (boolean)explainPlan.contains("IDX_ON_PREDICATE"));
        res = this.execSql("EXPLAIN SELECT T1.id FROM T1 USE INDEX(IDX_NOT_CHOOSE, IDX_ON_PREDICATE) INNER JOIN T2 ON T1.id = T2.id WHERE T1.val1 = 1 AND T2.val1 = 2 GROUP BY T1.val2", new Object[0]);
        explainPlan = (String)res.get(0).get(0);
        BasicSqlTypesIndexTest.assertTrue((String)explainPlan, (boolean)explainPlan.contains("IDX_ON_PREDICATE"));
        res = this.execSql("EXPLAIN SELECT T1.id FROM T1 INNER JOIN T2 ON T1.id = T2.id WHERE T1.val1 = 1 AND T2.val1 = 2 GROUP BY T1.val2", new Object[0]);
        explainPlan = (String)res.get(0).get(0);
        BasicSqlTypesIndexTest.assertTrue((String)explainPlan, (boolean)explainPlan.contains("IDX_ON_PREDICATE"));
        this.execSql("DROP INDEX IDX_ON_GRP", new Object[0]);
        res = this.execSql("EXPLAIN SELECT T1.id FROM T1 INNER JOIN T2 ON T1.id = T2.id WHERE T1.val1 = 1 AND T2.val1 = 2 GROUP BY T1.val2", new Object[0]);
        explainPlan = (String)res.get(0).get(0);
        BasicSqlTypesIndexTest.assertTrue((String)explainPlan, (boolean)explainPlan.contains("IDX_ON_PREDICATE"));
        this.execSql("DROP INDEX IDX_ON_PREDICATE", new Object[0]);
        this.execSql("CREATE INDEX IDX_ON_GRP ON T1(val2)", new Object[0]);
        res = this.execSql("EXPLAIN SELECT T1.id FROM T1 USE INDEX(IDX_NOT_CHOOSE) INNER JOIN T2 ON T1.id = T2.id WHERE T1.val1 = 1 AND T2.val1 = 2 GROUP BY T1.val2", new Object[0]);
        explainPlan = (String)res.get(0).get(0);
        BasicSqlTypesIndexTest.assertTrue((String)explainPlan, (boolean)explainPlan.contains("IDX_ON_GRP"));
    }

    @Test
    public void testPredicateAndGroupBy() {
        this.execSql("CREATE TABLE T (id INT PRIMARY KEY, val1 INT, val2 INT)", new Object[0]);
        this.execSql("CREATE INDEX T_IDX_ON_PREDICATE ON T(val1)", new Object[0]);
        this.execSql("CREATE INDEX T_IDX_ON_GRP ON T(val2)", new Object[0]);
        List<List<?>> res = this.execSql("EXPLAIN SELECT * FROM T WHERE T.val1 = 1 GROUP BY T.val2", new Object[0]);
        String explainPlan = (String)res.get(0).get(0);
        BasicSqlTypesIndexTest.assertTrue((String)explainPlan, (boolean)explainPlan.contains("T_IDX_ON_PREDICATE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void createPopulateAndVerify(String idxTypeStr, Class<T> idxTypeCls, Comparator<T> comp, IndexType idxType, @Nullable String benefits) {
        String tblName = idxTypeStr + "_TBL" + TBL_ID.incrementAndGet();
        try {
            String idxFieldName;
            String idxName;
            String createTblSql = String.format(idxType == IndexType.PK ? CREATE_TBL_PK_ONLY_TEMPLATE : CREATE_TBL_SECONDARY_INDEX_TEMPLATE, tblName, idxTypeStr, benefits != null ? benefits : "");
            this.execSql(createTblSql, new Object[0]);
            if (idxType != IndexType.PK) {
                idxName = "idxVal_idx";
                idxFieldName = "idxVal";
                this.execSql(String.format(CREATE_SECONDARY_INDEX_TEMPLATE, idxName, tblName, idxType == IndexType.SECONDARY_ASC ? "ASC" : "DESC"), new Object[0]);
            } else {
                idxName = "_key_PK";
                idxFieldName = "_KEY";
            }
            TreeMap data = new TreeMap(comp);
            this.populateTable(data, tblName, idxTypeCls, idxType == IndexType.PK);
            this.verifyRange(data, tblName, idxFieldName, idxName, comp);
            this.verifyEach(data, tblName, idxFieldName, idxName);
        }
        finally {
            this.execSql("DROP TABLE IF EXISTS \"" + tblName + "\"", new Object[0]);
        }
    }

    private <T> void populateTable(Map<T, Integer> data, String tblName, Class<T> idxValCls, boolean pk) {
        for (int i = 0; i < 1000; ++i) {
            int val;
            int id = this.nextVal(Integer.class);
            T idxVal = this.nextVal(idxValCls);
            if (data.put(idxVal, val = this.nextVal(Integer.class).intValue()) == null) {
                if (pk) {
                    this.execSql(String.format(INSERT_PK_ONLY_TEMPLATE, tblName), idxVal, val);
                    continue;
                }
                this.execSql(String.format(INSERT_SECONDARY_TEMPLATE, tblName), id, idxVal, val);
                continue;
            }
            this.execSql(String.format(UPDATE_VAL_TEMPLATE, tblName), val, idxVal);
        }
    }

    private <T> T nextVal(Class<T> cls) {
        if (cls.isAssignableFrom(Boolean.class)) {
            return cls.cast(ThreadLocalRandom.current().nextBoolean());
        }
        if (cls.isAssignableFrom(Byte.class)) {
            return cls.cast((byte)ThreadLocalRandom.current().nextInt());
        }
        if (cls.isAssignableFrom(Short.class)) {
            return cls.cast((short)ThreadLocalRandom.current().nextInt());
        }
        if (cls.isAssignableFrom(Integer.class)) {
            return cls.cast(ThreadLocalRandom.current().nextInt());
        }
        if (cls.isAssignableFrom(Long.class)) {
            return cls.cast(ThreadLocalRandom.current().nextLong());
        }
        if (cls.isAssignableFrom(Float.class)) {
            return cls.cast(Float.valueOf(ThreadLocalRandom.current().nextFloat()));
        }
        if (cls.isAssignableFrom(Double.class)) {
            return cls.cast(ThreadLocalRandom.current().nextDouble());
        }
        if (cls.isAssignableFrom(BigDecimal.class)) {
            BigDecimal bd = new BigDecimal(ThreadLocalRandom.current().nextDouble());
            if (this.decimalPrecision >= 0) {
                bd = bd.setScale(this.decimalPrecision, RoundingMode.HALF_UP);
            }
            return cls.cast(bd);
        }
        if (cls.isAssignableFrom(String.class)) {
            return cls.cast(GridTestUtils.randomString((Random)ThreadLocalRandom.current(), (int)1, (int)this.maxStrLen));
        }
        if (cls.isAssignableFrom(Date.class)) {
            return cls.cast(new Date(ThreadLocalRandom.current().nextLong()));
        }
        if (cls.isAssignableFrom(Time.class)) {
            return cls.cast(new Time(ThreadLocalRandom.current().nextLong()));
        }
        if (cls.isAssignableFrom(Timestamp.class)) {
            return cls.cast(new Timestamp(ThreadLocalRandom.current().nextLong()));
        }
        if (cls.isAssignableFrom(UUID.class)) {
            return cls.cast(new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()));
        }
        if (cls.isAssignableFrom(byte[].class)) {
            return cls.cast(GridTestUtils.randomString((Random)ThreadLocalRandom.current(), (int)1, (int)this.maxStrLen).getBytes());
        }
        throw new IllegalStateException("There is no generator for class=" + cls.getSimpleName());
    }

    private <T> void verifyRange(Map<T, Integer> data, String tblName, String idxFieldName, String idxName, Comparator<T> comp) {
        Object val = this.getRandom(data.keySet());
        List<List<?>> res = this.execSql(String.format(SELECT_ORDERED_RANGE_TEMPLATE, tblName, idxName, idxFieldName, idxFieldName), val);
        List exp = data.entrySet().stream().filter(e -> comp.compare(e.getKey(), val) <= 0).sorted((e1, e2) -> comp.compare(e1.getKey(), e2.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        List act = res.stream().flatMap(Collection::stream).map(e -> (Integer)e).collect(Collectors.toList());
        Assert.assertEquals(exp, act);
    }

    private <T> void verifyEach(Map<T, Integer> data, String tblName, String idxFieldName, String idxName) {
        for (Map.Entry<T, Integer> entry : data.entrySet()) {
            List<List<?>> res = this.execSql(String.format(SELECT_VALUE_TEMPLATE, tblName, idxName, idxFieldName), entry.getKey());
            Assert.assertFalse((String)"Result should not be empty", (boolean)res.isEmpty());
            Assert.assertFalse((String)"Result should contain at least one column", (boolean)res.get(0).isEmpty());
            Assert.assertEquals((Object)entry.getValue(), res.get(0).get(0));
        }
    }

    private <T> T getRandom(Collection<T> col) {
        int rndIdx = ThreadLocalRandom.current().nextInt(col.size());
        int i = 0;
        for (T el : col) {
            if (i++ != rndIdx) continue;
            return el;
        }
        return null;
    }

    private List<List<?>> execSql(String qry, Object ... args) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(qry).setArgs(args), false).getAll();
    }

    static enum IndexType {
        PK,
        SECONDARY_ASC,
        SECONDARY_DESC;

    }
}

