/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.odbc.ClientListenerProcessor;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.marshaller.Marshaller;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemaSelfTest
extends AbstractIndexingCommonTest {
    protected static final String CACHE_NAME = "cache";
    protected static final String TBL_NAME = AbstractSchemaSelfTest.tableName(ValueClass.class);
    protected static final String TBL_NAME_ESCAPED = AbstractSchemaSelfTest.typeName(ValueClass.class);
    protected static final String IDX_NAME_1 = "IDX_1";
    protected static final String IDX_NAME_1_ESCAPED = "idx_1";
    protected static final String IDX_NAME_2 = "IDX_2";
    protected static final String IDX_NAME_2_ESCAPED = "idx_2";
    protected static final String IDX_NAME_LOCAL = "IDX_LOC";
    protected static final String FIELD_KEY = "id";
    protected static final String FIELD_KEY_ALIAS = "key";
    protected static final String FIELD_NAME_1 = "FIELD1";
    protected static final String FIELD_NAME_1_ESCAPED = "field1";
    protected static final String FIELD_NAME_2 = "FIELD2";
    protected static final String FIELD_NAME_2_ESCAPED = "field2";

    protected IgniteConfiguration commonConfiguration(int idx) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(this.getTestIgniteInstanceName(idx));
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x8000000L));
        cfg.setDataStorageConfiguration(memCfg);
        return this.optimize(cfg);
    }

    static void assertSqlException(Runnable r, int expCode) {
        try {
            try {
                r.run();
            }
            catch (CacheException e) {
                if (e.getCause() != null) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
        }
        catch (IgniteSQLException e) {
            AbstractSchemaSelfTest.assertEquals((String)("Unexpected error code [expected=" + expCode + ", actual=" + e.statusCode() + ']'), (int)expCode, (int)e.statusCode());
            return;
        }
        catch (Exception e) {
            AbstractSchemaSelfTest.fail((String)("Unexpected exception: " + e));
        }
        AbstractSchemaSelfTest.fail((String)(IgniteSQLException.class.getSimpleName() + " is not thrown."));
    }

    static QueryTypeDescriptorImpl typeExisting(IgniteEx node, String cacheName, String tblName) {
        QueryTypeDescriptorImpl res = AbstractSchemaSelfTest.type(node, cacheName, tblName);
        AbstractSchemaSelfTest.assertNotNull((Object)res);
        return res;
    }

    @Nullable
    protected static QueryTypeDescriptorImpl type(IgniteEx node, String cacheName, String tblName) {
        return AbstractSchemaSelfTest.types(node, cacheName).get(tblName);
    }

    protected static Map<String, QueryTypeDescriptorImpl> types(IgniteEx node, String cacheName) {
        HashMap<String, QueryTypeDescriptorImpl> res = new HashMap<String, QueryTypeDescriptorImpl>();
        Collection descs = node.context().query().types(cacheName);
        for (GridQueryTypeDescriptor desc : descs) {
            QueryTypeDescriptorImpl desc0 = (QueryTypeDescriptorImpl)desc;
            res.put(desc0.tableName(), desc0);
        }
        return res;
    }

    static void assertIndex(String cacheName, String tblName, String idxName, int inlineSize, IgniteBiTuple<String, Boolean> ... fields) {
        for (Ignite node : Ignition.allGrids()) {
            AbstractSchemaSelfTest.assertIndex(node, cacheName, tblName, idxName, inlineSize, fields);
        }
    }

    static void assertIndex(Ignite node, String cacheName, String tblName, String idxName, int inlineSize, IgniteBiTuple<String, Boolean> ... fields) {
        AbstractSchemaSelfTest.awaitCompletion();
        node.cache(cacheName);
        IgniteEx node0 = (IgniteEx)node;
        ArrayList<T2> res = new ArrayList<T2>();
        try {
            try (Connection c = AbstractSchemaSelfTest.connect(node0);
                 ResultSet rs = c.getMetaData().getIndexInfo(null, cacheName, tblName, false, false);){
                while (rs.next()) {
                    if (!F.eq((Object)idxName, (Object)rs.getString("INDEX_NAME"))) continue;
                    res.add(new T2((Object)rs.getString("COLUMN_NAME"), (Object)F.eq((Object)"A", (Object)rs.getString("ASC_OR_DESC"))));
                }
            }
            AbstractSchemaSelfTest.assertTrue((String)("Index not found: " + idxName), (res.size() > 0 ? 1 : 0) != 0);
            AbstractSchemaSelfTest.assertEquals(Arrays.asList(fields), res);
        }
        catch (SQLException e) {
            throw new AssertionError((Object)e);
        }
        QueryTypeDescriptorImpl typeDesc = AbstractSchemaSelfTest.typeExisting(node0, cacheName, tblName);
        AbstractSchemaSelfTest.assertInternalIndexParams(typeDesc, idxName, inlineSize);
    }

    private static void assertInternalIndexParams(QueryTypeDescriptorImpl typeDesc, String idxName, int inlineSize) {
        QueryIndexDescriptorImpl idxDesc = typeDesc.index(idxName);
        AbstractSchemaSelfTest.assertNotNull((Object)idxDesc);
        AbstractSchemaSelfTest.assertEquals((String)idxName, (String)idxDesc.name());
        AbstractSchemaSelfTest.assertEquals((Object)typeDesc, (Object)idxDesc.typeDescriptor());
        AbstractSchemaSelfTest.assertEquals((Object)QueryIndexType.SORTED, (Object)idxDesc.type());
        AbstractSchemaSelfTest.assertEquals((int)inlineSize, (int)idxDesc.inlineSize());
    }

    public static Connection connect(IgniteEx node) {
        Collection recs = node.context().ports().records();
        GridPortRecord cliLsnrRec = null;
        for (GridPortRecord rec : recs) {
            if (rec.clazz() != ClientListenerProcessor.class) continue;
            cliLsnrRec = rec;
            break;
        }
        AbstractSchemaSelfTest.assertNotNull(cliLsnrRec);
        try {
            return DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:" + cliLsnrRec.port());
        }
        catch (SQLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void execute(Connection conn, String sql) throws SQLException {
        try (Statement s = conn.createStatement();){
            s.execute(sql);
        }
    }

    static void assertNoIndex(String cacheName, String tblName, String idxName) {
        for (Ignite node : Ignition.allGrids()) {
            AbstractSchemaSelfTest.assertNoIndex(node, cacheName, tblName, idxName);
        }
    }

    static void assertNoIndex(Ignite node, String cacheName, String tblName, String idxName) {
        AbstractSchemaSelfTest.awaitCompletion();
        node.cache(cacheName);
        try (Connection c = AbstractSchemaSelfTest.connect((IgniteEx)node);
             ResultSet rs = c.getMetaData().getIndexInfo(null, cacheName, tblName, false, false);){
            while (rs.next()) {
                AbstractSchemaSelfTest.assertFalse((String)("Index exists, although shouldn't: " + tblName + '.' + idxName), (boolean)F.eq((Object)idxName, (Object)rs.getString("INDEX_NAME")));
            }
        }
        catch (SQLException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void awaitCompletion() {
        try {
            U.sleep((long)100L);
        }
        catch (IgniteInterruptedCheckedException e) {
            AbstractSchemaSelfTest.fail();
        }
    }

    protected static String typeName(Class cls) {
        return cls.getSimpleName();
    }

    static String tableName(Class cls) {
        return QueryUtils.normalizeObjectName((String)AbstractSchemaSelfTest.typeName(cls), (boolean)true);
    }

    protected static QueryIndex index(String name, IgniteBiTuple<String, Boolean> ... fields) {
        QueryIndex idx = new QueryIndex();
        idx.setName(name);
        LinkedHashMap<Object, Object> fields0 = new LinkedHashMap<Object, Object>();
        for (IgniteBiTuple<String, Boolean> field : fields) {
            fields0.put(field.getKey(), field.getValue());
        }
        idx.setFields(fields0);
        return idx;
    }

    protected List<List<?>> execute(Ignite node, String sql) {
        return AbstractSchemaSelfTest.queryProcessor(node).querySqlFields(new SqlFieldsQuery(sql).setSchema("PUBLIC"), true).getAll();
    }

    public static GridQueryProcessor queryProcessor(Ignite node) {
        return AbstractSchemaSelfTest.queryProcessor((IgniteEx)node);
    }

    protected static GridQueryProcessor queryProcessor(IgniteEx node) {
        return node.context().query();
    }

    protected static IgniteBiTuple<String, Boolean> field(String name) {
        return AbstractSchemaSelfTest.field(name, true);
    }

    protected static IgniteBiTuple<String, Boolean> field(String name, boolean asc) {
        return F.t((Object)name.toUpperCase(), (Object)asc);
    }

    protected static String alias(String fieldName) {
        return fieldName + "_alias";
    }

    void dynamicIndexCreate(Ignite node, String cacheName, String tblName, QueryIndex idx, boolean ifNotExists, int parallel) throws Exception {
        GridStringBuilder sql = new SB("CREATE INDEX ").a(ifNotExists ? "IF NOT EXISTS " : "").a(idx.getName()).a(" ON ").a(tblName).a(" (");
        boolean first = true;
        for (Map.Entry fieldEntry : idx.getFields().entrySet()) {
            if (first) {
                first = false;
            } else {
                sql.a(", ");
            }
            String name = (String)fieldEntry.getKey();
            boolean asc = (Boolean)fieldEntry.getValue();
            sql.a(name).a(" ").a(asc ? "ASC" : "DESC");
        }
        sql.a(')');
        if (idx.getInlineSize() != -1) {
            sql.a(" INLINE_SIZE ").a(idx.getInlineSize());
        }
        if (parallel != 0) {
            sql.a(" PARALLEL ").a(parallel);
        }
        this.executeSql(node, cacheName, sql.toString());
    }

    protected void dynamicIndexDrop(Ignite node, String cacheName, String idxName, boolean ifExists) throws Exception {
        String sql = "DROP INDEX " + (ifExists ? "IF EXISTS " : "") + idxName;
        this.executeSql(node, cacheName, sql);
    }

    protected IgniteCache<?, ?> createSqlCache(Ignite node, CacheConfiguration ccfg) throws IgniteCheckedException {
        ((IgniteEx)node).context().cache().dynamicStartSqlCache(ccfg).get();
        IgniteCache res = node.cache(CACHE_NAME);
        AbstractSchemaSelfTest.assertNotNull((Object)res);
        return res;
    }

    protected void destroySqlCache(Ignite node) throws IgniteCheckedException {
        this.destroySqlCacheFuture(node).get();
    }

    protected IgniteInternalFuture<Boolean> destroySqlCacheFuture(Ignite node) {
        return ((IgniteEx)node).context().cache().dynamicDestroyCache(CACHE_NAME, true, true, false, null);
    }

    private void executeSql(Ignite node, String cacheName, String sql) {
        log.info("Executing DDL: " + sql);
        node.cache(cacheName).query(new SqlFieldsQuery(sql)).getAll();
    }

    public static class ValueClass2 {
        @QuerySqlField(name="field1")
        private String field;

        public ValueClass2(String field) {
            this.field = field;
        }

        public String field() {
            return this.field;
        }
    }

    public static class ValueClass {
        @QuerySqlField
        private Long field1;

        public ValueClass(Long field1) {
            this.field1 = field1;
        }

        public Long field1() {
            return this.field1;
        }
    }

    public static class KeyClass {
        @QuerySqlField
        private long id;

        public KeyClass(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyClass keyClass = (KeyClass)o;
            return this.id == keyClass.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }
    }
}

