/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.replicated;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.IgniteCacheAbstractFieldsQuerySelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class IgniteCacheReplicatedFieldsQuerySelfTest
extends IgniteCacheAbstractFieldsQuerySelfTest {
    @Override
    protected CacheMode cacheMode() {
        return CacheMode.REPLICATED;
    }

    @Override
    protected int gridCount() {
        return 3;
    }

    @Test
    public void testLostIterator() throws Exception {
        IgniteCache cache = intCache;
        FieldsQueryCursor qry = null;
        int maximumQryIterCnt = ((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).getMaxQueryIteratorsCount();
        for (int i = 0; i < maximumQryIterCnt + 1; ++i) {
            FieldsQueryCursor q = cache.query(new SqlFieldsQuery("select _key from Integer where _key >= 0 order by _key"));
            IgniteCacheReplicatedFieldsQuerySelfTest.assertEquals((Object)0, ((List)q.iterator().next()).get(0));
            if (qry != null) continue;
            qry = q;
        }
        final FieldsQueryCursor qry0 = qry;
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                int i = 0;
                for (List row : qry0) {
                    IgniteCacheReplicatedFieldsQuerySelfTest.assertEquals((Object)(++i % 50), (Object)row.get(0));
                }
                return null;
            }
        }, IgniteException.class, null);
    }
}

