/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.Collection;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class SqlPageLocksDumpTest
extends GridCommonAbstractTest {
    private static final String PERSON_CACHE = "person";
    private ListeningTestLogger testLog;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person.class.getName());
        entity.addQueryField("id", Integer.class.getName(), null);
        entity.addQueryField("name", String.class.getName(), null);
        entity.setKeyFieldName("id");
        CacheConfiguration ccfg = new CacheConfiguration(PERSON_CACHE);
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        this.testLog = new ListeningTestLogger(log);
        cfg.setGridLogger((IgniteLogger)this.testLog);
        return cfg;
    }

    @Test
    @WithSystemProperty(key="IGNITE_PAGE_LOCK_TRACKER_CHECK_INTERVAL", value="1000")
    public void queryTouchingManyPagesShouldNotLogPageLocksDump() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        try (IgniteDataStreamer streamer = ignite.dataStreamer(PERSON_CACHE);){
            for (int i = 0; i < 100000; ++i) {
                streamer.addData((Object)i, (Object)new Person(i, "name" + i));
            }
        }
        IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}));
        ClientCache personCache = client.cache(PERSON_CACHE);
        LogListener lsnr = LogListener.matches((String)"Page locks dump:").build();
        this.testLog.registerListener(lsnr);
        personCache.query(new SqlFieldsQuery("SELECT COUNT(*) FROM \"person\".Person")).getAll();
        SqlPageLocksDumpTest.assertFalse((String)"Page locks dump should not be logged", (boolean)GridTestUtils.waitForCondition(() -> ((LogListener)lsnr).check(), (long)5000L));
    }

    private static class Person
    implements Serializable {
        int id;
        String name;

        public Person(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

