/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteClientReconnectAbstractTest;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.DynamicEnableIndexingAbstractTest;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.spi.IgniteSpiException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class IgniteDynamicEnableIndexingRestoreTest
extends DynamicEnableIndexingAbstractTest {
    private static final String WRONG_SCHEMA_NAME = "DOMAIN_1";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setClusterStateOnStart(ClusterState.INACTIVE);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0xC800000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        cfg.setConsistentId((Serializable)((Object)gridName));
        cfg.setSqlSchemas(new String[]{"DOMAIN", WRONG_SCHEMA_NAME});
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testMergeCacheConfig_StartWithInitialCoordinator() throws Exception {
        this.testMergeCacheConfig(0, 1);
    }

    @Test
    public void testMergeCacheConfig_StartWithInitialSecondNode() throws Exception {
        this.testMergeCacheConfig(1, 0);
    }

    private void testMergeCacheConfig(int firstIdx, int secondIdx) throws Exception {
        this.prepareTestGrid();
        IgniteEx ig = this.startGrid(firstIdx);
        this.startGrid(secondIdx);
        ig.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        this.performQueryingIntegrityCheck((Ignite)ig);
        this.stopAllGrids();
        ig = this.startGrids(2);
        ig.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        this.performQueryingIntegrityCheck((Ignite)ig);
    }

    @Test
    public void testFailJoiningNodeBecauseNeedConfigUpdateOnActiveGrid() throws Exception {
        this.prepareTestGrid();
        IgniteEx ig = this.startGrid(1);
        ig.cluster().state(ClusterState.ACTIVE);
        try {
            this.startGrid(0);
            IgniteDynamicEnableIndexingRestoreTest.fail((String)"Node should start with fail");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)((IgniteSpiException)X.cause((Throwable)e, IgniteSpiException.class)).getMessage(), (Matcher)CoreMatchers.containsString((String)"the config of the cache 'poi' has to be merged which is impossible on active grid"));
        }
    }

    @Test
    public void testFailJoiningNodeDifferentSchemasOnDynamicIndexes() throws Exception {
        this.prepareTestGrid();
        IgniteEx ig = this.startGrid(1);
        ig.cluster().state(ClusterState.ACTIVE);
        this.createTable(ig.cache("poi"), WRONG_SCHEMA_NAME, 1);
        try {
            this.startGrid(0);
            IgniteDynamicEnableIndexingRestoreTest.fail((String)"Node should start with fail");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)((IgniteSpiException)X.cause((Throwable)e, IgniteSpiException.class)).getMessage(), (Matcher)CoreMatchers.containsString((String)"schema 'DOMAIN' from joining node differs to 'DOMAIN_1'"));
        }
    }

    @Test
    public void testReconnectClient_RestartFromNodeWithEnabledIndexing() throws Exception {
        this.testReconnectClient(true);
    }

    @Test
    public void testReconnectClient_RestartFromNodeWithDisabledIndexing() throws Exception {
        this.testReconnectClient(false);
    }

    private void testReconnectClient(boolean startFromEnabledIndexing) throws Exception {
        IgniteEx srv0 = this.startGrids(2);
        IgniteEx cli = this.startClientGrid(2);
        cli.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = srv0.createCache(this.testCacheConfiguration("poi"));
        this.loadData(srv0, 0, 1000);
        this.stopGrid(1);
        this.createTable(cache, "DOMAIN", 1);
        this.performQueryingIntegrityCheck((Ignite)srv0);
        IgniteClientReconnectAbstractTest.reconnectClientNode((IgniteLogger)log, (Ignite)cli, (Ignite)srv0, () -> {
            try {
                this.stopGrid(0);
                if (startFromEnabledIndexing) {
                    this.startGrid(0);
                } else {
                    this.startGrid(1);
                }
            }
            catch (Exception e) {
                throw new IgniteException("Failed to restart cluster", (Throwable)e);
            }
        });
        IgniteDynamicEnableIndexingRestoreTest.assertEquals((int)2, (int)cli.cluster().nodes().size());
        cli.cluster().state(ClusterState.ACTIVE);
        if (startFromEnabledIndexing) {
            this.awaitPartitionMapExchange();
            this.performQueryingIntegrityCheck((Ignite)cli);
        } else {
            IgniteDynamicEnableIndexingRestoreTest.assertEquals((int)1000, (int)cli.getOrCreateCache("poi").size(new CachePeekMode[]{CachePeekMode.PRIMARY}));
        }
    }

    private void prepareTestGrid() throws Exception {
        IgniteEx ig = this.startGrids(2);
        ig.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ig.createCache(this.testCacheConfiguration("poi"));
        this.loadData(ig, 0, 1000);
        this.stopGrid(1);
        this.createTable(cache, "DOMAIN", 1);
        this.performQueryingIntegrityCheck((Ignite)ig);
        this.stopAllGrids();
    }

    private CacheConfiguration<?, ?> testCacheConfiguration(String name) {
        return new CacheConfiguration(name).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.REPLICATED).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
    }
}

