/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.concurrent.Callable;
import javax.cache.CacheException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.GridCacheAbstractSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class IgniteCacheSqlQueryErrorSelfTest
extends GridCacheAbstractSelfTest {
    protected int gridCount() {
        return 1;
    }

    @Test
    public void testSelectWrongTable() throws Exception {
        this.checkSqlErrorMessage("select from wrong", "Failed to parse query. Table \"WRONG\" not found");
    }

    @Test
    public void testSelectWrongColumnName() throws Exception {
        this.checkSqlErrorMessage("select wrong from test", "Failed to parse query. Column \"WRONG\" not found");
    }

    @Test
    public void testSelectWrongSyntax() throws Exception {
        this.checkSqlErrorMessage("select from test where", "Failed to parse query. Syntax error in SQL statement \"SELECT FROM TEST WHERE[*]");
    }

    @Test
    public void testDmlWrongTable() throws Exception {
        this.checkSqlErrorMessage("insert into wrong (id, val) values (3, 'val3')", "Failed to parse query. Table \"WRONG\" not found");
        this.checkSqlErrorMessage("merge into wrong (id, val) values (3, 'val3')", "Failed to parse query. Table \"WRONG\" not found");
        this.checkSqlErrorMessage("update wrong set val = 'val3' where id = 2", "Failed to parse query. Table \"WRONG\" not found");
        this.checkSqlErrorMessage("delete from wrong where id = 2", "Failed to parse query. Table \"WRONG\" not found");
    }

    @Test
    public void testDmlWrongColumnName() throws Exception {
        this.checkSqlErrorMessage("insert into test (id, wrong) values (3, 'val3')", "Failed to parse query. Column \"WRONG\" not found");
        this.checkSqlErrorMessage("merge into test (id, wrong) values (3, 'val3')", "Failed to parse query. Column \"WRONG\" not found");
        this.checkSqlErrorMessage("update test set wrong = 'val3' where id = 2", "Failed to parse query. Column \"WRONG\" not found");
        this.checkSqlErrorMessage("delete from test where wrong = 2", "Failed to parse query. Column \"WRONG\" not found");
    }

    @Test
    public void testDmlWrongSyntax() throws Exception {
        this.checkSqlErrorMessage("insert test (id, val) values (3, 'val3')", "Failed to parse query. Syntax error in SQL statement \"INSERT TEST[*] (ID, VAL)");
        this.checkSqlErrorMessage("merge test (id, val) values (3, 'val3')", "Failed to parse query. Syntax error in SQL statement \"MERGE TEST[*] (ID, VAL)");
        this.checkSqlErrorMessage("update test val = 'val3' where id = 2", "Failed to parse query. Syntax error in SQL statement \"UPDATE TEST VAL =[*] 'val3' WHERE ID = 2");
        this.checkSqlErrorMessage("delete from test 1where id = 2", "Failed to parse query. Syntax error in SQL statement \"DELETE FROM TEST 1[*]WHERE ID = 2 ");
    }

    @Test
    public void testDdlWrongTable() throws Exception {
        this.checkSqlErrorMessage("create table test (id int primary key, val varchar)", "Table already exists: TEST");
        this.checkSqlErrorMessage("drop table wrong", "Table doesn't exist: WRONG");
        this.checkSqlErrorMessage("create index idx1 on wrong (val)", "Table doesn't exist: WRONG");
        this.checkSqlErrorMessage("drop index wrong", "Index doesn't exist: WRONG");
        this.checkSqlErrorMessage("alter table wrong drop column val", "Failed to parse query. Table \"WRONG\" not found");
    }

    @Test
    public void testDdlWrongColumnName() throws Exception {
        this.checkSqlErrorMessage("create index idx1 on test (wrong)", "Column doesn't exist: WRONG");
        this.checkSqlErrorMessage("alter table test drop column wrong", "Failed to parse query. Column \"WRONG\" not found");
        this.checkSqlErrorMessage("create table test(id integer primary key, AgE integer, AGe integer)", "Duplicate column name: AGE");
        this.checkSqlErrorMessage("create table test(\"id\" integer primary key, \"age\" integer, \"age\" integer)", "Duplicate column name: age");
        this.checkSqlErrorMessage("create table test(id integer primary key, age integer, age varchar)", "Duplicate column name: AGE");
    }

    @Test
    public void testDdlWrongSyntax() throws Exception {
        this.checkSqlErrorMessage("create table wrong (id int wrong key, val varchar)", "Failed to parse query. Syntax error in SQL statement \"CREATE TABLE WRONG (ID INT WRONG[*]");
        this.checkSqlErrorMessage("drop table test on", "Failed to parse query. Syntax error in SQL statement \"DROP TABLE TEST ON[*]");
        this.checkSqlErrorMessage("create index idx1 test (val)", "Failed to parse query. Syntax error in SQL statement \"CREATE INDEX IDX1 TEST[*]");
        this.checkSqlErrorMessage("drop index", "Failed to parse query. Syntax error in SQL statement \"DROP INDEX [*]");
        this.checkSqlErrorMessage("alter table test drop column", "Failed to parse query. Syntax error in SQL statement \"ALTER TABLE TEST DROP COLUMN [*]");
    }

    private void checkSqlErrorMessage(final String sql, String expMsg) {
        this.execute("DROP TABLE IF EXISTS wrong");
        this.execute("DROP TABLE IF EXISTS test");
        this.execute("CREATE TABLE test (id INT PRIMARY KEY, val VARCHAR)");
        this.execute("INSERT INTO test (id, val) VALUES (1, 'val1')");
        this.execute("INSERT INTO test (id, val) VALUES (2, 'val2')");
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                IgniteCacheSqlQueryErrorSelfTest.this.execute(sql);
                IgniteCacheSqlQueryErrorSelfTest.fail((String)"Exception is expected");
                return null;
            }
        }, CacheException.class, (String)expMsg);
    }

    private void execute(String sql) {
        this.jcache().query(new SqlFieldsQuery(sql).setSchema("PUBLIC")).getAll();
    }
}

