/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.HashMap;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.internal.processors.cache.GridCacheAbstractSelfTest;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.junit.Test;

public class IgniteCacheQueryIndexSelfTest
extends GridCacheAbstractSelfTest {
    private static final int GRID_CNT = 2;
    private static final int ENTRY_CNT = 10;

    protected int gridCount() {
        return 2;
    }

    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    @Test
    public void testWithoutStoreLoad() throws Exception {
        IgniteCache cache = this.grid(0).cache("default");
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)i, (Object)new CacheValue(i));
        }
        this.checkCache((IgniteCache<Integer, CacheValue>)cache);
        this.checkQuery((IgniteCache<Integer, CacheValue>)cache);
    }

    protected Class<?>[] indexedTypes() {
        return new Class[]{Integer.class, CacheValue.class};
    }

    @Test
    public void testWithStoreLoad() throws Exception {
        for (int i = 0; i < 10; ++i) {
            storeStgy.putToStore((Object)i, (Object)new CacheValue(i));
        }
        IgniteCache cache0 = this.grid(0).cache("default");
        cache0.loadCache(null, new Object[0]);
        this.checkCache((IgniteCache<Integer, CacheValue>)cache0);
        this.checkQuery((IgniteCache<Integer, CacheValue>)cache0);
    }

    private void checkCache(IgniteCache<Integer, CacheValue> cache) throws Exception {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Cache.Entry entry : cache) {
            map.put(entry.getKey(), entry.getValue());
        }
        assert (map.entrySet().size() == 10) : "Expected: 10, but was: " + cache.size(new CachePeekMode[0]);
        assert (map.keySet().size() == 10) : "Expected: 10, but was: " + cache.size(new CachePeekMode[0]);
        assert (map.values().size() == 10) : "Expected: 10, but was: " + cache.size(new CachePeekMode[0]);
        assert (cache.localSize(new CachePeekMode[]{CachePeekMode.ALL}) == 10) : "Expected: 10, but was: " + cache.localSize(new CachePeekMode[0]);
    }

    private void checkQuery(IgniteCache<Integer, CacheValue> cache) throws Exception {
        QueryCursor qry = cache.query((Query)new SqlQuery(CacheValue.class, "val >= 5"));
        List queried = qry.getAll();
        IgniteCacheQueryIndexSelfTest.assertEquals((String)("Unexpected query result: " + queried), (int)5, (int)queried.size());
    }

    private static class CacheValue {
        @QuerySqlField
        private final int val;

        CacheValue(int val) {
            this.val = val;
        }

        int value() {
            return this.val;
        }

        public String toString() {
            return S.toString(CacheValue.class, (Object)this);
        }
    }
}

