/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.IgniteCacheAbstractInsertSqlQuerySelfTest;
import org.junit.Test;

public class IgniteCacheMergeSqlQuerySelfTest
extends IgniteCacheAbstractInsertSqlQuerySelfTest {
    @Test
    public void testMergeWithExplicitKey() {
        IgniteCache p = this.ignite(0).cache("S2P").withKeepBinary();
        p.query(new SqlFieldsQuery("merge into Person (_key, id, firstName) values ('s', ?, ?), ('a', 2, 'Alex')").setArgs(new Object[]{1, "Sergi"}));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson(1, "Sergi"), (Object)p.get((Object)"s"));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson(2, "Alex"), (Object)p.get((Object)"a"));
    }

    @Test
    public void testMergeFromSubquery() {
        IgniteCache p = this.ignite(0).cache("S2P").withKeepBinary();
        p.query(new SqlFieldsQuery("merge into String (_key, _val) values ('s', ?), ('a', ?)").setArgs(new Object[]{"Sergi", "Alex"}).setLocal(true));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)"Sergi", (Object)p.get((Object)"s"));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)"Alex", (Object)p.get((Object)"a"));
        p.query(new SqlFieldsQuery("merge into Person(_key, id, firstName) (select substring(lower(_val), 0, 2), cast(length(_val) as int), _val from String)"));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson(5, "Sergi"), (Object)p.get((Object)"se"));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson(4, "Alex"), (Object)p.get((Object)"al"));
    }

    @Test
    public void testMergeWithExplicitPrimitiveKey() {
        IgniteCache p = this.ignite(0).cache("I2P").withKeepBinary();
        p.query(new SqlFieldsQuery("merge into Person (_key, id, firstName) values (cast(? as int), ?, ?), (2, (5 - 3), 'Alex')").setArgs(new Object[]{"1", 1, "Sergi"}));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson(1, "Sergi"), (Object)p.get((Object)1));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson(2, "Alex"), (Object)p.get((Object)2));
    }

    @Test
    public void testMergeWithDynamicKeyInstantiation() {
        IgniteCache p = this.ignite(0).cache("K2P").withKeepBinary();
        p.query(new SqlFieldsQuery("merge into Person (key, id, firstName) values (1, ?, ?), (2, 2, 'Alex')").setArgs(new Object[]{1, "Sergi"}));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson(1, "Sergi"), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key(1)));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson(2, "Alex"), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key(2)));
    }

    @Test
    public void testFieldsCaseSensitivity() {
        IgniteCache p = this.ignite(0).cache("K22P").withKeepBinary();
        p.query(new SqlFieldsQuery("merge into \"Person2\" (\"Id\", \"id\", \"firstName\", \"IntVal\") values (1, ?, ?, 5), (2, 3, 'Alex', 6)").setArgs(new Object[]{4, "Sergi"}));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson2(4, "Sergi", 5), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key2(1)));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson2(3, "Alex", 6), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key2(2)));
    }

    @Test
    public void testPrimitives() {
        IgniteCache p = this.ignite(0).cache("I2I").withKeepBinary();
        p.query(new SqlFieldsQuery("merge into Integer(_key, _val) values (1, ?), (?, 4)").setArgs(new Object[]{2, 3}));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((int)2, (int)((Integer)p.get((Object)1)));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((int)4, (int)((Integer)p.get((Object)3)));
    }

    @Test
    public void testImplicitColumnNames() {
        IgniteCache p = this.ignite(0).cache("K2P").withKeepBinary();
        p.query(new SqlFieldsQuery("merge into Person values (1, 1, 'Vova')")).getAll();
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson(1, "Vova"), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key(1)));
        p.query(new SqlFieldsQuery("merge into Person values (2, 2, 'Sergi'), (3, 3, 'Alex')")).getAll();
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson(2, "Sergi"), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key(2)));
        IgniteCacheMergeSqlQuerySelfTest.assertEquals((Object)this.createPerson(3, "Alex"), (Object)p.get((Object)new IgniteCacheAbstractInsertSqlQuerySelfTest.Key(3)));
    }
}

