/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.sql.AbstractH2CompareQueryTest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.junit.Test;

public class IgniteCacheJoinPartitionedAndReplicatedCollocationTest
extends AbstractH2CompareQueryTest {
    private static final String PERSON_CACHE = "person";
    private static final String ACCOUNT_CACHE = "acc";
    private boolean client;
    private boolean h2DataInserted;

    @Override
    protected void createCaches() {
    }

    @Override
    protected void initCacheAndDbData() throws Exception {
    }

    @Override
    protected void checkAllDataEquals() throws Exception {
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setClientMode(this.client);
        return cfg;
    }

    private CacheConfiguration personCache() {
        CacheConfiguration ccfg = this.configuration(PERSON_CACHE, 0);
        ccfg.setCacheMode(CacheMode.REPLICATED);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person.class.getName());
        entity.addQueryField("name", String.class.getName(), null);
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        return ccfg;
    }

    private CacheConfiguration accountCache(int backups) {
        CacheConfiguration ccfg = this.configuration(ACCOUNT_CACHE, backups);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Account.class.getName());
        entity.addQueryField("personId", Integer.class.getName(), null);
        entity.addQueryField("name", String.class.getName(), null);
        entity.setIndexes((Collection)F.asList((Object)new QueryIndex("personId")));
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        return ccfg;
    }

    private CacheConfiguration configuration(String name, int backups) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setName(name);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setBackups(backups);
        return ccfg;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.client = true;
        this.startGrid(4);
    }

    @Override
    protected Statement initializeH2Schema() throws SQLException {
        Statement st = super.initializeH2Schema();
        st.execute("CREATE SCHEMA \"person\"");
        st.execute("CREATE SCHEMA \"acc\"");
        st.execute("create table \"person\".PERSON  (_key int not null,  _val other not null,  name varchar(255))");
        st.execute("create table \"acc\".ACCOUNT  (_key int not null,  _val other not null,  personId int,  name varchar(255))");
        return st;
    }

    @Test
    public void testJoin() throws Exception {
        IgniteEx client = this.grid(4);
        client.createCache(this.personCache());
        this.checkJoin(0);
        this.h2DataInserted = true;
        this.checkJoin(1);
        this.checkJoin(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkJoin(int accBackups) throws Exception {
        IgniteEx client = this.grid(4);
        IgniteCache personCache = client.cache(PERSON_CACHE);
        Affinity aff = client.affinity(PERSON_CACHE);
        AtomicInteger pKey = new AtomicInteger(100000);
        AtomicInteger accKey = new AtomicInteger();
        ClusterNode node0 = this.ignite(0).cluster().localNode();
        ClusterNode node1 = this.ignite(1).cluster().localNode();
        try {
            IgniteCache accCache = client.createCache(this.accountCache(accBackups));
            Integer pKey1 = this.keyForNode(aff, pKey, node0);
            this.insert((IgniteCache<Object, Object>)personCache, (int)pKey1, new Person("p1"));
            Integer pKey2 = this.keyForNode(aff, pKey, node0);
            this.insert((IgniteCache<Object, Object>)personCache, (int)pKey2, new Person("p2"));
            this.insert((IgniteCache<Object, Object>)accCache, (int)this.keyForNode(aff, accKey, node0), new Account(pKey2, "a-p2"));
            Integer pKey3 = this.keyForNode(aff, pKey, node0);
            this.insert((IgniteCache<Object, Object>)personCache, (int)pKey3, new Person("p3"));
            this.insert((IgniteCache<Object, Object>)accCache, (int)this.keyForNode(aff, accKey, node1), new Account(pKey3, "a-p3"));
            Integer pKey4 = this.keyForNode(aff, pKey, node0);
            this.insert((IgniteCache<Object, Object>)personCache, (int)pKey4, new Person("p4"));
            this.insert((IgniteCache<Object, Object>)accCache, (int)this.keyForNode(aff, accKey, node0), new Account(pKey4, "a-p4-1"));
            this.insert((IgniteCache<Object, Object>)accCache, (int)this.keyForNode(aff, accKey, node1), new Account(pKey4, "a-p4-2"));
            Integer pKey5 = this.keyForNode(aff, pKey, node0);
            this.insert((IgniteCache<Object, Object>)personCache, (int)pKey5, new Person("p5"));
            this.insert((IgniteCache<Object, Object>)accCache, (int)this.keyForNode(aff, accKey, node0), new Account(pKey5, "a-p5-1"));
            this.insert((IgniteCache<Object, Object>)accCache, (int)this.keyForNode(aff, accKey, node0), new Account(pKey5, "a-p5-1"));
            Integer pKey6 = this.keyForNode(aff, pKey, node0);
            this.insert((IgniteCache<Object, Object>)personCache, (int)pKey6, new Person("p6"));
            this.insert((IgniteCache<Object, Object>)accCache, (int)this.keyForNode(aff, accKey, node1), new Account(pKey6, "a-p5-1"));
            this.insert((IgniteCache<Object, Object>)accCache, (int)this.keyForNode(aff, accKey, node1), new Account(pKey6, "a-p5-1"));
            Integer[] keys = new Integer[]{pKey1, pKey2, pKey3, pKey4, pKey5, pKey6};
            for (int i = 0; i < keys.length; ++i) {
                log.info("Test key: " + i);
                Integer key = keys[i];
                this.checkQuery("select p._key, p.name, a.name from \"person\".Person p, \"acc\".Account a where p._key = a.personId and p._key=?", (IgniteCache<Object, Object>)accCache, true, key);
                this.checkQuery("select p._key, p.name, a.name from \"acc\".Account a, \"person\".Person p where p._key = a.personId and p._key=?", (IgniteCache<Object, Object>)accCache, true, key);
                this.checkQuery("select p._key, p.name, a.name from \"person\".Person p right outer join \"acc\".Account a on (p._key = a.personId) and p._key=?", (IgniteCache<Object, Object>)accCache, true, key);
                this.checkQuery("select p._key, p.name, a.name from \"acc\".Account a left outer join \"person\".Person p on (p._key = a.personId) and p._key=?", (IgniteCache<Object, Object>)accCache, true, key);
            }
        }
        finally {
            client.destroyCache(ACCOUNT_CACHE);
            personCache.removeAll();
        }
    }

    private void insert(IgniteCache<Object, Object> cache, int key, Person p) throws Exception {
        cache.put((Object)key, (Object)p);
        if (this.h2DataInserted) {
            return;
        }
        try (PreparedStatement st = conn.prepareStatement("insert into \"person\".PERSON (_key, _val, name) values(?, ?, ?)");){
            st.setObject(1, key);
            st.setObject(2, p);
            st.setObject(3, p.name);
            st.executeUpdate();
        }
    }

    private void insert(IgniteCache<Object, Object> cache, int key, Account a) throws Exception {
        cache.put((Object)key, (Object)a);
        if (this.h2DataInserted) {
            return;
        }
        try (PreparedStatement st = conn.prepareStatement("insert into \"acc\".ACCOUNT (_key, _val, personId, name) values(?, ?, ?, ?)");){
            st.setObject(1, key);
            st.setObject(2, a);
            st.setObject(3, a.personId);
            st.setObject(4, a.name);
            st.executeUpdate();
        }
    }

    private void checkQuery(String sql, IgniteCache<Object, Object> cache, boolean enforceJoinOrder, Object ... args) throws Exception {
        String plan = (String)((List)cache.query(new SqlFieldsQuery("explain " + sql).setArgs(args).setDistributedJoins(true).setEnforceJoinOrder(enforceJoinOrder)).getAll().get(0)).get(0);
        log.info("Plan: " + plan);
        IgniteCacheJoinPartitionedAndReplicatedCollocationTest.compareQueryRes0(cache, sql, true, enforceJoinOrder, args, AbstractH2CompareQueryTest.Ordering.RANDOM);
    }

    private static class Person
    implements Serializable {
        String name;

        public Person(String name) {
            this.name = name;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }

    private static class Account
    implements Serializable {
        int personId;
        String name;

        public Account(int personId, String name) {
            this.personId = personId;
            this.name = name;
        }

        public String toString() {
            return S.toString(Account.class, (Object)this);
        }
    }
}

