/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.IgniteCacheAbstractSqlDmlQuerySelfTest;
import org.junit.Test;

public class IgniteCacheDeleteSqlQuerySelfTest
extends IgniteCacheAbstractSqlDmlQuerySelfTest {
    @Test
    public void testDeleteSimple() {
        IgniteCache p = this.cache();
        FieldsQueryCursor c = p.query(new SqlFieldsQuery("delete from Person p where length(p._key) = 2 or p.secondName like '%ite'"));
        c.iterator();
        c = p.query(new SqlFieldsQuery("select _key, _val, * from Person order by id"));
        List leftovers = c.getAll();
        IgniteCacheDeleteSqlQuerySelfTest.assertEquals((int)2, (int)leftovers.size());
        IgniteCacheDeleteSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("SecondKey", this.createPerson(2, "Joe", "Black"), 2, "Joe", "Black"), (Collection)((Collection)leftovers.get(0)));
        IgniteCacheDeleteSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("f0u4thk3y", this.createPerson(4, "Jane", "Silver"), 4, "Jane", "Silver"), (Collection)((Collection)leftovers.get(1)));
    }

    @Test
    public void testDeleteSingle() {
        IgniteCache p = this.cache();
        FieldsQueryCursor c = p.query(new SqlFieldsQuery("delete from Person where _key = ?").setArgs(new Object[]{"FirstKey"}));
        c.iterator();
        c = p.query(new SqlFieldsQuery("select _key, _val, * from Person order by id, _key"));
        List leftovers = c.getAll();
        IgniteCacheDeleteSqlQuerySelfTest.assertEquals((int)3, (int)leftovers.size());
        IgniteCacheDeleteSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("SecondKey", this.createPerson(2, "Joe", "Black"), 2, "Joe", "Black"), (Collection)((Collection)leftovers.get(0)));
        IgniteCacheDeleteSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("k3", this.createPerson(3, "Sylvia", "Green"), 3, "Sylvia", "Green"), (Collection)((Collection)leftovers.get(1)));
        IgniteCacheDeleteSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("f0u4thk3y", this.createPerson(4, "Jane", "Silver"), 4, "Jane", "Silver"), (Collection)((Collection)leftovers.get(2)));
    }

    @Test
    public void testDeleteSimpleWithoutKeepBinary() {
        IgniteCache p = this.ignite(0).cache("S2P");
        FieldsQueryCursor c = p.query(new SqlFieldsQuery("delete from Person p where length(p._key) = 2 or p.secondName like '%ite'"));
        c.iterator();
        c = p.query(new SqlFieldsQuery("select _key, _val, * from Person order by id"));
        List leftovers = c.getAll();
        IgniteCacheDeleteSqlQuerySelfTest.assertEquals((int)2, (int)leftovers.size());
        IgniteCacheDeleteSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("SecondKey", new IgniteCacheAbstractSqlDmlQuerySelfTest.Person(2, "Joe", "Black"), 2, "Joe", "Black"), (Collection)((Collection)leftovers.get(0)));
        IgniteCacheDeleteSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("f0u4thk3y", new IgniteCacheAbstractSqlDmlQuerySelfTest.Person(4, "Jane", "Silver"), 4, "Jane", "Silver"), (Collection)((Collection)leftovers.get(1)));
    }
}

