/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.CacheCreateDestroyClusterReadOnlyModeAbstractTest;
import org.apache.ignite.internal.processors.cache.ClusterReadOnlyModeTestUtils;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class GridCacheSqlDdlClusterReadOnlyModeTest
extends CacheCreateDestroyClusterReadOnlyModeAbstractTest {
    private static final String SQL_SELECT_ERROR_MSG = "Failed to parse query. Column \"CITY\" not found";

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.grid(0).getOrCreateCache("default");
    }

    @Test
    public void testCreateTableDenied() {
        this.grid(0).cluster().state(ClusterState.ACTIVE_READ_ONLY);
        for (String ddl : GridCacheSqlDdlClusterReadOnlyModeTest.generateCreateTableDDL()) {
            for (Ignite node : G.allGrids()) {
                Throwable t = GridTestUtils.assertThrows((IgniteLogger)log, () -> GridCacheSqlDdlClusterReadOnlyModeTest.execute(node, ddl, new Object[0]), Exception.class, null);
                ClusterReadOnlyModeTestUtils.checkRootCause((Throwable)t, (String)(node.name() + " sql: " + ddl));
            }
        }
    }

    @Test
    public void testDropTableDenied() {
        this.createTables();
        this.grid(0).cluster().state(ClusterState.ACTIVE_READ_ONLY);
        for (String cacheName : ClusterReadOnlyModeTestUtils.cacheNames()) {
            String sql = "drop table " + GridCacheSqlDdlClusterReadOnlyModeTest.tableName(cacheName);
            for (Ignite node : G.allGrids()) {
                Throwable t = GridTestUtils.assertThrows((IgniteLogger)log, () -> GridCacheSqlDdlClusterReadOnlyModeTest.execute(node, sql, new Object[0]), Exception.class, null);
                ClusterReadOnlyModeTestUtils.checkRootCause((Throwable)t, (String)(node.name() + " sql: " + sql));
            }
        }
    }

    @Test
    public void testCreateDropIndexAllowed() {
        this.createTables();
        this.grid(0).cluster().state(ClusterState.ACTIVE_READ_ONLY);
        for (String cacheName : ClusterReadOnlyModeTestUtils.cacheNames()) {
            for (Ignite node : G.allGrids()) {
                String indexName = "age_idx_" + GridCacheSqlDdlClusterReadOnlyModeTest.tableName(cacheName);
                GridCacheSqlDdlClusterReadOnlyModeTest.assertNotNull((Object)GridCacheSqlDdlClusterReadOnlyModeTest.execute(node, "create index " + indexName + " on " + GridCacheSqlDdlClusterReadOnlyModeTest.tableName(cacheName) + " (age)", new Object[0]));
                GridCacheSqlDdlClusterReadOnlyModeTest.assertNotNull((Object)GridCacheSqlDdlClusterReadOnlyModeTest.execute(node, "drop index " + indexName, new Object[0]));
            }
        }
    }

    @Test
    public void testAlterTableAllowed() {
        this.createTables();
        this.grid(0).cluster().state(ClusterState.ACTIVE_READ_ONLY);
        for (CacheConfiguration cfg : ClusterReadOnlyModeTestUtils.cacheConfigurations()) {
            String cacheName = cfg.getName();
            if (cfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) continue;
            for (Ignite node : G.allGrids()) {
                String selectSql = "select city from " + GridCacheSqlDdlClusterReadOnlyModeTest.tableName(cacheName);
                GridTestUtils.assertThrows((IgniteLogger)log, () -> GridCacheSqlDdlClusterReadOnlyModeTest.execute(node, selectSql, new Object[0]), IgniteSQLException.class, (String)SQL_SELECT_ERROR_MSG);
                GridCacheSqlDdlClusterReadOnlyModeTest.execute(node, "alter table " + GridCacheSqlDdlClusterReadOnlyModeTest.tableName(cacheName) + " add column city varchar", new Object[0]);
                GridCacheSqlDdlClusterReadOnlyModeTest.assertNotNull((Object)GridCacheSqlDdlClusterReadOnlyModeTest.execute(node, selectSql, new Object[0]));
                GridCacheSqlDdlClusterReadOnlyModeTest.execute(node, "alter table " + GridCacheSqlDdlClusterReadOnlyModeTest.tableName(cacheName) + " drop column city", new Object[0]);
                GridTestUtils.assertThrows((IgniteLogger)log, () -> GridCacheSqlDdlClusterReadOnlyModeTest.execute(node, selectSql, new Object[0]), IgniteSQLException.class, (String)SQL_SELECT_ERROR_MSG);
            }
        }
    }

    private static List<String> generateCreateTableDDL() {
        ArrayList<String> ddls = new ArrayList<String>();
        for (CacheConfiguration cfg : ClusterReadOnlyModeTestUtils.cacheConfigurations()) {
            SB sb = new SB("CREATE TABLE ");
            sb.a(GridCacheSqlDdlClusterReadOnlyModeTest.tableName(cfg.getName()));
            sb.a(" (id int, city_id int, age int, PRIMARY KEY (id)) WITH \"");
            sb.a("backups=").a(cfg.getBackups()).a(",");
            sb.a("CACHE_NAME=").a(cfg.getName()).a(",");
            if (cfg.getGroupName() != null) {
                sb.a("CACHE_GROUP=").a(cfg.getGroupName()).a(",");
            }
            sb.a("ATOMICITY=").a((Object)cfg.getAtomicityMode()).a(",");
            sb.a("TEMPLATE=").a((Object)cfg.getCacheMode());
            sb.a("\"");
            ddls.add(sb.toString());
        }
        return ddls;
    }

    private void createTables() {
        for (String ddl : GridCacheSqlDdlClusterReadOnlyModeTest.generateCreateTableDDL()) {
            GridCacheSqlDdlClusterReadOnlyModeTest.execute((Ignite)this.grid(0), ddl, new Object[0]);
        }
        for (String cacheName : ClusterReadOnlyModeTestUtils.cacheNames()) {
            GridCacheSqlDdlClusterReadOnlyModeTest.execute((Ignite)this.grid(0), "INSERT INTO " + GridCacheSqlDdlClusterReadOnlyModeTest.tableName(cacheName) + " (id, city_id, age) VALUES (1, 1, 1)", new Object[0]);
        }
    }

    private static Object execute(Ignite node, String sql, Object ... args) {
        return node.cache("default").query(new SqlFieldsQuery(sql).setArgs(args)).getAll();
    }

    private static String tableName(String cacheName) {
        return "tbl_" + cacheName;
    }
}

