/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.cache.Cache;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;

public class GridCacheOffheapIndexGetSelfTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setNetworkTimeout(2000L);
        cfg.setDeploymentMode(DeploymentMode.SHARED);
        return cfg;
    }

    protected CacheConfiguration cacheConfiguration() {
        CacheConfiguration cacheCfg = GridCacheOffheapIndexGetSelfTest.defaultCacheConfiguration();
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg.setCacheMode(CacheMode.PARTITIONED);
        cacheCfg.setBackups(1);
        cacheCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cacheCfg.setEvictionPolicy(null);
        return cacheCfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(2);
    }

    protected void afterTest() throws Exception {
        for (String cacheName : this.grid(0).cacheNames()) {
            this.info("Clear cache: " + cacheName);
            this.grid(0).cache(cacheName).clear();
        }
    }

    @Test
    public void testGet() throws Exception {
        long i;
        IgniteCache cache = this.jcache((Ignite)this.grid(0), this.cacheConfiguration(), Long.class, Long.class);
        for (i = 0L; i < 100L; ++i) {
            cache.put((Object)i, (Object)i);
        }
        for (i = 0L; i < 100L; ++i) {
            GridCacheOffheapIndexGetSelfTest.assertEquals((Object)i, (Object)cache.get((Object)i));
        }
        SqlQuery qry = new SqlQuery(Long.class, "_val >= 90");
        List res = cache.query((Query)qry).getAll();
        GridCacheOffheapIndexGetSelfTest.assertEquals((int)10, (int)res.size());
        for (Cache.Entry e : res) {
            GridCacheOffheapIndexGetSelfTest.assertNotNull((Object)e.getKey());
            GridCacheOffheapIndexGetSelfTest.assertNotNull((Object)e.getValue());
        }
    }

    @Test
    public void testPutGet() throws Exception {
        IgniteCache cache = this.jcache((Ignite)this.grid(0), this.cacheConfiguration(), Object.class, Object.class);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        try (Transaction tx = this.grid(0).transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ, 100000L, 1000);){
            for (int i = 4; i < 400; ++i) {
                map.put("key" + i, new TestEntity("value"));
                map.put(i, "value");
            }
            cache.putAll(map);
            tx.commit();
        }
        for (int i = 0; i < 100; ++i) {
            cache.get((Object)("key" + i));
            cache.get((Object)i);
        }
    }

    @Test
    public void testWithExpiryPolicy() throws Exception {
        long i;
        IgniteCache cache = this.jcache((Ignite)this.grid(0), this.cacheConfiguration(), Long.class, Long.class);
        cache = cache.withExpiryPolicy((ExpiryPolicy)new TestExiryPolicy());
        for (i = 0L; i < 100L; ++i) {
            cache.put((Object)i, (Object)i);
        }
        for (i = 0L; i < 100L; ++i) {
            GridCacheOffheapIndexGetSelfTest.assertEquals((Object)i, (Object)cache.get((Object)i));
        }
        SqlQuery qry = new SqlQuery(Long.class, "_val >= 90");
        List res = cache.query((Query)qry).getAll();
        GridCacheOffheapIndexGetSelfTest.assertEquals((int)10, (int)res.size());
        for (Cache.Entry e : res) {
            GridCacheOffheapIndexGetSelfTest.assertNotNull((Object)e.getKey());
            GridCacheOffheapIndexGetSelfTest.assertNotNull((Object)e.getValue());
        }
    }

    private static class TestEntity
    implements Serializable {
        @QuerySqlField(index=true)
        private String val;

        public TestEntity(String value) {
            this.val = value;
        }

        public String getValue() {
            return this.val;
        }

        public void setValue(String val) {
            this.val = val;
        }
    }

    private static class TestExiryPolicy
    implements ExpiryPolicy {
        private TestExiryPolicy() {
        }

        public Duration getExpiryForCreation() {
            return Duration.ONE_MINUTE;
        }

        public Duration getExpiryForAccess() {
            return Duration.FIVE_MINUTES;
        }

        public Duration getExpiryForUpdate() {
            return Duration.TWENTY_MINUTES;
        }
    }
}

