/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class GridCacheCrossCacheQuerySelfTest
extends GridCommonAbstractTest {
    private static final String PART_CACHE_NAME = "partitioned";
    private static final String REPL_PROD_CACHE_NAME = "replicated-prod";
    private static final String REPL_STORE_CACHE_NAME = "replicated-store";
    private Ignite ignite;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        c.setCacheConfiguration(new CacheConfiguration[]{GridCacheCrossCacheQuerySelfTest.createCache(PART_CACHE_NAME, CacheMode.PARTITIONED, Integer.class, FactPurchase.class), GridCacheCrossCacheQuerySelfTest.createCache(REPL_PROD_CACHE_NAME, CacheMode.REPLICATED, Integer.class, DimProduct.class), GridCacheCrossCacheQuerySelfTest.createCache(REPL_STORE_CACHE_NAME, CacheMode.REPLICATED, Integer.class, DimStore.class)});
        return c;
    }

    protected void beforeTest() throws Exception {
        this.ignite = this.startGridsMultiThreaded(3);
        this.fillCaches();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.ignite = null;
    }

    private static CacheConfiguration createCache(String name, CacheMode mode, Class<?> clsK, Class<?> clsV) {
        CacheConfiguration cc = GridCacheCrossCacheQuerySelfTest.defaultCacheConfiguration();
        cc.setName(name);
        cc.setCacheMode(mode);
        cc.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cc.setRebalanceMode(CacheRebalanceMode.SYNC);
        cc.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cc.setIndexedTypes(new Class[]{clsK, clsV});
        if (mode != CacheMode.PARTITIONED && mode != CacheMode.REPLICATED) {
            throw new IllegalStateException("mode: " + mode);
        }
        return cc;
    }

    @Test
    public void testTwoStepGroupAndAggregates() throws Exception {
        IgniteInternalCache cache = ((IgniteKernal)this.ignite).getCache(PART_CACHE_NAME);
        GridQueryProcessor qryProc = ((IgniteKernal)this.ignite).context().query();
        HashSet<Integer> set1 = new HashSet<Integer>();
        X.println((String)"___ simple", (Object[])new Object[0]);
        SqlFieldsQuery qry = new SqlFieldsQuery("select f.productId, p.name, f.price from FactPurchase f, \"replicated-prod\".DimProduct p where p.id = f.productId ");
        for (Object o : ((FieldsQueryCursor)qryProc.querySqlFields(cache.context(), qry, null, false, true).get(0)).getAll()) {
            X.println((String)("___ -> " + o), (Object[])new Object[0]);
            set1.add((Integer)o.get(0));
        }
        GridCacheCrossCacheQuerySelfTest.assertFalse((boolean)set1.isEmpty());
        HashSet<Integer> set0 = new HashSet<Integer>();
        X.println((String)"___ GROUP BY", (Object[])new Object[0]);
        qry = new SqlFieldsQuery("select productId from FactPurchase group by productId");
        for (Iterator o : ((FieldsQueryCursor)qryProc.querySqlFields(cache.context(), qry, null, false, true).get(0)).getAll()) {
            X.println((String)("___ -> " + o), (Object[])new Object[0]);
            GridCacheCrossCacheQuerySelfTest.assertTrue((boolean)set0.add((Integer)o.get(0)));
        }
        GridCacheCrossCacheQuerySelfTest.assertEquals(set0, set1);
        X.println((String)"___ GROUP BY AVG MIN MAX SUM COUNT(*) COUNT(x) (MAX - MIN) * 2 as", (Object[])new Object[0]);
        HashSet<String> names = new HashSet<String>();
        qry = new SqlFieldsQuery("select p.name, avg(f.price), min(f.price), max(f.price), sum(f.price), count(*), count(nullif(f.price, 5)), (max(f.price) - min(f.price)) * 3 as nn , CAST(max(f.price) + 7 AS VARCHAR) from FactPurchase f, \"replicated-prod\".DimProduct p where p.id = f.productId group by f.productId, p.name");
        for (List o : ((FieldsQueryCursor)qryProc.querySqlFields(cache.context(), qry, null, false, true).get(0)).getAll()) {
            X.println((String)("___ -> " + o), (Object[])new Object[0]);
            GridCacheCrossCacheQuerySelfTest.assertTrue((boolean)names.add((String)o.get(0)));
            GridCacheCrossCacheQuerySelfTest.assertEquals((int)GridCacheCrossCacheQuerySelfTest.i(o, 4), (int)(GridCacheCrossCacheQuerySelfTest.i(o, 2) + GridCacheCrossCacheQuerySelfTest.i(o, 3)));
            GridCacheCrossCacheQuerySelfTest.assertEquals((int)GridCacheCrossCacheQuerySelfTest.i(o, 7), (int)((GridCacheCrossCacheQuerySelfTest.i(o, 3) - GridCacheCrossCacheQuerySelfTest.i(o, 2)) * 3));
            GridCacheCrossCacheQuerySelfTest.assertEquals(o.get(8), (Object)Integer.toString(GridCacheCrossCacheQuerySelfTest.i(o, 3) + 7));
        }
        X.println((String)"___ SUM HAVING", (Object[])new Object[0]);
        qry = new SqlFieldsQuery("select p.name, sum(f.price) s from FactPurchase f, \"replicated-prod\".DimProduct p where p.id = f.productId group by f.productId, p.name having s >= 15");
        for (List o : ((FieldsQueryCursor)qryProc.querySqlFields(cache.context(), qry, null, false, true).get(0)).getAll()) {
            X.println((String)("___ -> " + o), (Object[])new Object[0]);
            GridCacheCrossCacheQuerySelfTest.assertTrue((GridCacheCrossCacheQuerySelfTest.i(o, 1) >= 15 ? 1 : 0) != 0);
        }
        X.println((String)"___ DISTINCT ORDER BY TOP", (Object[])new Object[0]);
        int top = 6;
        qry = new SqlFieldsQuery("select top 3 distinct productId from FactPurchase f order by productId desc ");
        for (List o : ((FieldsQueryCursor)qryProc.querySqlFields(cache.context(), qry, null, false, true).get(0)).getAll()) {
            X.println((String)("___ -> " + o), (Object[])new Object[0]);
            GridCacheCrossCacheQuerySelfTest.assertEquals((Object)top--, o.get(0));
        }
        X.println((String)"___ DISTINCT ORDER BY OFFSET LIMIT", (Object[])new Object[0]);
        top = 5;
        qry = new SqlFieldsQuery("select distinct productId from FactPurchase f order by productId desc limit 2 offset 1");
        for (List o : ((FieldsQueryCursor)qryProc.querySqlFields(cache.context(), qry, null, false, true).get(0)).getAll()) {
            X.println((String)("___ -> " + o), (Object[])new Object[0]);
            GridCacheCrossCacheQuerySelfTest.assertEquals((Object)top--, o.get(0));
        }
        GridCacheCrossCacheQuerySelfTest.assertEquals((int)3, (int)top);
    }

    @Test
    public void testApiQueries() throws Exception {
        IgniteCache c = this.ignite.cache(PART_CACHE_NAME);
        c.query(new SqlFieldsQuery("select cast(? as varchar) from FactPurchase").setArgs(new Object[]{"aaa"})).getAll();
        List res = c.query(new SqlFieldsQuery("select cast(? as varchar), id from FactPurchase order by id limit ? offset ?").setArgs(new Object[]{"aaa", 1, 1})).getAll();
        GridCacheCrossCacheQuerySelfTest.assertEquals((int)1, (int)res.size());
        GridCacheCrossCacheQuerySelfTest.assertEquals((Object)"aaa", ((List)res.get(0)).get(0));
    }

    @Test
    public void testMultiStatement() throws Exception {
        final IgniteInternalCache cache = ((IgniteKernal)this.ignite).getCache(PART_CACHE_NAME);
        final GridQueryProcessor qryProc = ((IgniteKernal)this.ignite).context().query();
        final SqlFieldsQuery qry = new SqlFieldsQuery("insert into FactPurchase(_key, id, productId, storeId, price) values (555, 555, 555, 555, 555);select count(*) from FactPurchase");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                qryProc.querySqlFields(cache.context(), qry, null, false, true);
                return null;
            }
        }, IgniteSQLException.class, (String)"Multiple statements queries are not supported");
        List cursors = qryProc.querySqlFields(cache.context(), qry, null, false, false);
        GridCacheCrossCacheQuerySelfTest.assertEquals((int)2, (int)cursors.size());
        for (FieldsQueryCursor cur : cursors) {
            U.closeQuiet((AutoCloseable)cur);
        }
        qry.setLocal(true);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                qryProc.querySqlFields(cache.context(), qry, null, false, false);
                return null;
            }
        }, IgniteSQLException.class, (String)"Multiple statements queries are not supported for local queries");
    }

    private static int i(List<?> l, int idx) {
        return ((Number)l.get(idx)).intValue();
    }

    private void fillCaches() throws IgniteCheckedException {
        Object v;
        int id;
        int i;
        int idGen = 0;
        GridCacheAdapter dimCacheProd = ((IgniteKernal)this.ignite).internalCache(REPL_PROD_CACHE_NAME);
        GridCacheAdapter dimCacheStore = ((IgniteKernal)this.ignite).internalCache(REPL_STORE_CACHE_NAME);
        ArrayList<Object> dimStores = new ArrayList<Object>();
        ArrayList<Object> dimProds = new ArrayList<Object>();
        for (i = 0; i < 2; ++i) {
            id = idGen++;
            v = new DimStore(id, "Store" + id);
            dimCacheStore.getAndPut((Object)id, v);
            dimStores.add(v);
        }
        for (i = 0; i < 5; ++i) {
            id = idGen++;
            v = new DimProduct(id, "Product" + id);
            dimCacheProd.getAndPut((Object)id, v);
            dimProds.add(v);
        }
        GridCacheAdapter factCache = ((IgniteKernal)this.ignite).internalCache(PART_CACHE_NAME);
        Collections.sort(dimStores, new Comparator<DimStore>(){

            @Override
            public int compare(DimStore o1, DimStore o2) {
                return Integer.compare(o1.getId(), o2.getId());
            }
        });
        Collections.sort(dimProds, new Comparator<DimProduct>(){

            @Override
            public int compare(DimProduct o1, DimProduct o2) {
                return Integer.compare(o1.getId(), o2.getId());
            }
        });
        for (int i2 = 0; i2 < 10; ++i2) {
            int id2 = idGen++;
            DimStore store = (DimStore)dimStores.get(i2 % dimStores.size());
            DimProduct prod = (DimProduct)dimProds.get(i2 % dimProds.size());
            factCache.getAndPut((Object)id2, (Object)new FactPurchase(id2, prod.getId(), store.getId(), i2 + 5));
        }
    }

    private static void check(List<Map.Entry<Integer, FactPurchase>> res) {
        GridCacheCrossCacheQuerySelfTest.assertEquals((String)"Result size", (int)4, (int)res.size());
        GridCacheCrossCacheQuerySelfTest.checkPurchase(res.get(0), 13, 3, 0);
        GridCacheCrossCacheQuerySelfTest.checkPurchase(res.get(1), 14, 4, 1);
        GridCacheCrossCacheQuerySelfTest.checkPurchase(res.get(2), 15, 5, 0);
        GridCacheCrossCacheQuerySelfTest.checkPurchase(res.get(3), 16, 6, 1);
    }

    private static void checkPurchase(Map.Entry<Integer, FactPurchase> entry, int id, int productId, int storeId) {
        FactPurchase purchase = entry.getValue();
        GridCacheCrossCacheQuerySelfTest.assertEquals((String)"Id", (int)id, (int)entry.getKey());
        GridCacheCrossCacheQuerySelfTest.assertEquals((String)"Id", (int)id, (int)purchase.getId());
        GridCacheCrossCacheQuerySelfTest.assertEquals((String)"ProductId", (int)productId, (int)purchase.getProductId());
        GridCacheCrossCacheQuerySelfTest.assertEquals((String)"StoreId", (int)storeId, (int)purchase.getStoreId());
    }

    private static class FactPurchase {
        @QuerySqlField
        private int id;
        @QuerySqlField
        private int storeId;
        @QuerySqlField
        private int productId;
        @QuerySqlField
        private int price;

        FactPurchase(int id, int productId, int storeId, int price) {
            this.id = id;
            this.productId = productId;
            this.storeId = storeId;
            this.price = price;
        }

        public int getId() {
            return this.id;
        }

        public int getProductId() {
            return this.productId;
        }

        public int getStoreId() {
            return this.storeId;
        }
    }

    private static class DimStore {
        @QuerySqlField
        private int id;
        @QuerySqlField
        private String name;

        DimStore(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class DimProduct {
        @QuerySqlField
        private int id;
        @QuerySqlField
        private String name;

        DimProduct(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

