/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Random;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.ClusterReadOnlyModeAbstractTest;
import org.apache.ignite.internal.util.typedef.G;
import org.junit.Test;

public class ClusterReadOnlyModeSqlTest
extends ClusterReadOnlyModeAbstractTest {
    @Test
    public void testSqlReadOnly() {
        this.assertSqlReadOnlyMode(false);
        this.changeClusterReadOnlyMode(true);
        this.assertSqlReadOnlyMode(true);
        this.changeClusterReadOnlyMode(false);
        this.assertSqlReadOnlyMode(false);
    }

    private void assertSqlReadOnlyMode(boolean readOnly) {
        Random rnd = new Random();
        for (Ignite ignite : G.allGrids()) {
            for (String cacheName : CACHE_NAMES) {
                Throwable throwable;
                FieldsQueryCursor cur;
                IgniteCache cache = ignite.cache(cacheName);
                try (FieldsQueryCursor cur2 = cache.query(new SqlFieldsQuery("SELECT * FROM Integer"));){
                    cur2.getAll();
                }
                CacheException failed = null;
                try {
                    cur = cache.query(new SqlFieldsQuery("DELETE FROM Integer"));
                    throwable = null;
                    try {
                        cur.getAll();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (cur != null) {
                            if (throwable != null) {
                                try {
                                    cur.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                cur.close();
                            }
                        }
                    }
                }
                catch (CacheException ex) {
                    if (!readOnly) {
                        log.error("Failed to delete data", (Throwable)ex);
                    }
                    failed = ex;
                }
                if (failed == null == readOnly) {
                    ClusterReadOnlyModeSqlTest.fail((String)("SQL delete from " + cacheName + " must " + (readOnly ? "fail" : "succeed")));
                }
                failed = null;
                try {
                    cur = cache.query(new SqlFieldsQuery("INSERT INTO Integer(_KEY, _VAL) VALUES (?, ?)").setArgs(new Object[]{rnd.nextInt(1000), rnd.nextInt()}));
                    throwable = null;
                    try {
                        cur.getAll();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (cur != null) {
                            if (throwable != null) {
                                try {
                                    cur.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                cur.close();
                            }
                        }
                    }
                }
                catch (CacheException ex) {
                    if (!readOnly) {
                        log.error("Failed to insert data", (Throwable)ex);
                    }
                    failed = ex;
                }
                if (failed == null != readOnly) continue;
                ClusterReadOnlyModeSqlTest.fail((String)("SQL insert into " + cacheName + " must " + (readOnly ? "fail" : "succeed")));
            }
        }
    }
}

