/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.ClusterReadOnlyModeTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ClusterReadOnlyModeDoesNotBreakSqlSelectTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(ClusterReadOnlyModeTestUtils.cacheConfigurations()).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTest();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void test() throws Exception {
        Ignite crd = this.startGridsMultiThreaded(2);
        this.setAndCheckClusterState(crd, ClusterState.ACTIVE);
        for (String cacheName : ClusterReadOnlyModeTestUtils.cacheNames()) {
            crd.cache(cacheName).put((Object)cacheName.hashCode(), (Object)(2 * cacheName.hashCode()));
        }
        this.checkSelect(crd);
        this.setAndCheckClusterState(crd, ClusterState.ACTIVE_READ_ONLY);
        this.checkSelect(crd);
        this.setAndCheckClusterState(crd, ClusterState.INACTIVE);
        this.setAndCheckClusterState(crd, ClusterState.ACTIVE_READ_ONLY);
        this.checkSelect(crd);
        this.setAndCheckClusterState(crd, ClusterState.ACTIVE);
        this.checkSelect(crd);
    }

    private void setAndCheckClusterState(Ignite crd, ClusterState state) {
        crd.cluster().state(state);
        ClusterReadOnlyModeDoesNotBreakSqlSelectTest.assertEquals((Object)state, (Object)crd.cluster().state());
    }

    private void checkSelect(Ignite crd) {
        for (String cacheName : ClusterReadOnlyModeTestUtils.cacheNames()) {
            ClusterReadOnlyModeDoesNotBreakSqlSelectTest.assertEquals((String)cacheName, (int)1, (int)crd.cache(cacheName).size(new CachePeekMode[0]));
            FieldsQueryCursor cur = crd.cache(cacheName).query(new SqlFieldsQuery("SELECT * FROM Integer"));
            Throwable throwable = null;
            try {
                List rows = cur.getAll();
                ClusterReadOnlyModeDoesNotBreakSqlSelectTest.assertEquals((String)cacheName, (int)1, (int)rows.size());
                List row = (List)rows.get(0);
                ClusterReadOnlyModeDoesNotBreakSqlSelectTest.assertEquals((String)cacheName, (int)2, (int)row.size());
                ClusterReadOnlyModeDoesNotBreakSqlSelectTest.assertEquals((String)cacheName, (Object)cacheName.hashCode(), row.get(0));
                ClusterReadOnlyModeDoesNotBreakSqlSelectTest.assertEquals((String)cacheName, (Object)(2 * cacheName.hashCode()), row.get(1));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cur == null) continue;
                if (throwable != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                cur.close();
            }
        }
    }
}

