/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class ClientReconnectAfterClusterRestartTest
extends GridCommonAbstractTest {
    private static final int SERVER_ID = 0;
    private static final int CLIENT_ID = 1;
    private static final String CACHE_PARAMS = "PPRB_PARAMS";
    private int joinTimeout;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        cfg.setIncludeEventTypes(EventType.EVTS_CACHE);
        if (this.getTestIgniteInstanceName(1).equals(igniteInstanceName)) {
            cfg.setClientMode(true);
            CacheConfiguration ccfg = this.getCacheConfiguration();
            cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        }
        if (this.joinTimeout != 0 && this.getTestIgniteInstanceName(1).equals(igniteInstanceName)) {
            ((TcpDiscoverySpi)cfg.getDiscoverySpi()).setJoinTimeout((long)this.joinTimeout);
        }
        return cfg;
    }

    @NotNull
    private CacheConfiguration getCacheConfiguration() {
        CacheConfiguration ccfg = ClientReconnectAfterClusterRestartTest.defaultCacheConfiguration();
        ccfg.setName(CACHE_PARAMS);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ArrayList<QueryEntity> queryEntities = new ArrayList<QueryEntity>();
        QueryEntity entity = new QueryEntity();
        entity.setValueType("Params");
        entity.setKeyType("java.lang.Long");
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("ID", "java.lang.Long");
        fields.put("PARTITIONID", "java.lang.Long");
        fields.put("CLIENTID", "java.lang.Long");
        fields.put("PARAMETRCODE", "java.lang.Long");
        fields.put("PARAMETRVALUE", "java.lang.Object");
        fields.put("PARENTID", "java.lang.Long");
        entity.setFields(fields);
        ArrayList<QueryIndex> indexes = new ArrayList<QueryIndex>();
        indexes.add(new QueryIndex("CLIENTID"));
        indexes.add(new QueryIndex("ID"));
        indexes.add(new QueryIndex("PARENTID"));
        entity.setIndexes(indexes);
        queryEntities.add(entity);
        ccfg.setQueryEntities(queryEntities);
        return ccfg;
    }

    @Test
    public void testReconnectClient() throws Exception {
        this.checkReconnectClient();
    }

    @Test
    public void testReconnectClient10sTimeout() throws Exception {
        this.joinTimeout = 10000;
        this.checkReconnectClient();
    }

    @Test
    public void testReconnectClient2sTimeout() throws Exception {
        this.joinTimeout = 2000;
        this.checkReconnectClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkReconnectClient() throws Exception {
        try {
            this.startGrid(0);
            IgniteEx client = this.startGrid(1);
            this.checkTopology(2);
            IgniteCache cache = client.getOrCreateCache(CACHE_PARAMS).withKeepBinary();
            client.events().localListen((IgnitePredicate)new IgnitePredicate<Event>(){

                public boolean apply(Event event) {
                    switch (event.type()) {
                        case 16: {
                            ClientReconnectAfterClusterRestartTest.this.info("Client disconnected");
                            break;
                        }
                        case 17: {
                            ClientReconnectAfterClusterRestartTest.this.info("Client reconnected");
                        }
                    }
                    return true;
                }
            }, new int[]{16, 17});
            IgniteDataStreamer streamer = client.dataStreamer(CACHE_PARAMS);
            streamer.allowOverwrite(true);
            streamer.keepBinary(true);
            streamer.perNodeBufferSize(10000);
            streamer.perNodeParallelOperations(100);
            BinaryObjectBuilder builder = client.binary().builder("PARAMS");
            builder.setField("ID", (Object)1L);
            builder.setField("PARTITIONID", (Object)1L);
            builder.setField("CLIENTID", (Object)1L);
            builder.setField("PARAMETRCODE", (Object)1L);
            builder.setField("PARAMETRVALUE", (Object)"Test value");
            builder.setField("PARENTID", (Object)1L);
            BinaryObject obj = builder.build();
            streamer.addData((Object)1L, (Object)obj);
            streamer.flush();
            this.stopAllServers(false);
            Thread.sleep(2000L);
            this.startGrid(0);
            try {
                ClientReconnectAfterClusterRestartTest.assertNull((Object)cache.get((Object)1L));
            }
            catch (CacheException ce) {
                IgniteClientDisconnectedException icde = (IgniteClientDisconnectedException)ce.getCause();
                icde.reconnectFuture().get();
                ClientReconnectAfterClusterRestartTest.assertNull((Object)cache.get((Object)1L));
            }
            this.info("Pre-insert");
            builder = client.binary().builder("PARAMS");
            builder.setField("ID", (Object)2L);
            builder.setField("PARTITIONID", (Object)1L);
            builder.setField("CLIENTID", (Object)1L);
            builder.setField("PARAMETRCODE", (Object)1L);
            builder.setField("PARAMETRVALUE", (Object)"Test value");
            builder.setField("PARENTID", (Object)1L);
            obj = builder.build();
            cache.put((Object)2L, (Object)obj);
            builder = client.binary().builder("PARAMS");
            builder.setField("ID", (Object)3L);
            builder.setField("PARTITIONID", (Object)1L);
            builder.setField("CLIENTID", (Object)1L);
            builder.setField("PARAMETRCODE", (Object)1L);
            builder.setField("PARAMETRVALUE", (Object)"Test value");
            builder.setField("PARENTID", (Object)1L);
            obj = builder.build();
            cache.put((Object)3L, (Object)obj);
            builder = client.binary().builder("PARAMS");
            builder.setField("ID", (Object)4L);
            builder.setField("PARTITIONID", (Object)1L);
            builder.setField("CLIENTID", (Object)1L);
            builder.setField("PARAMETRCODE", (Object)1L);
            builder.setField("PARAMETRVALUE", (Object)"Test value");
            builder.setField("PARENTID", (Object)1L);
            obj = builder.build();
            cache.put((Object)4L, (Object)obj);
            this.info("Post-insert");
            obj = (BinaryObject)cache.get((Object)4L);
            ClientReconnectAfterClusterRestartTest.assertNotNull((Object)obj);
            this.info("End");
        }
        finally {
            this.stopAllGrids();
        }
    }
}

