/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupMetricsTest;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Ignore;
import org.junit.Test;

public class CacheGroupMetricsWithIndexTest
extends CacheGroupMetricsTest {
    private static final String GROUP_NAME = "group2";
    private static final String CACHE_NAME2 = "cache2";
    private static final String CACHE_NAME3 = "cache3";
    private static final String GROUP_NAME_2 = "group2";
    private static final String OBJECT_NAME2 = "MyObject2";
    private static final String OBJECT_NAME3 = "MyObject3";
    private static final String TABLE = "\"cache2\".MyObject2";
    private static final String KEY_NAME = "id";
    private static final String COLUMN1_NAME = "col1";
    private static final String COLUMN2_NAME = "col2";
    private static final String COLUMN3_NAME = "col3";
    private static final String INDEX_NAME = "testindex001";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        for (CacheConfiguration cacheCfg : cfg.getCacheConfiguration()) {
            ArrayList<QueryIndex> indexes;
            LinkedHashMap<String, String> fields;
            QueryEntity qryEntity;
            if ("group2".equals(cacheCfg.getGroupName()) && CACHE_NAME2.equals(cacheCfg.getName())) {
                qryEntity = new QueryEntity(Long.class.getCanonicalName(), OBJECT_NAME2);
                qryEntity.setKeyFieldName(KEY_NAME);
                fields = new LinkedHashMap<String, String>();
                fields.put(KEY_NAME, Long.class.getCanonicalName());
                fields.put(COLUMN1_NAME, Integer.class.getCanonicalName());
                fields.put(COLUMN2_NAME, String.class.getCanonicalName());
                qryEntity.setFields(fields);
                indexes = new ArrayList<QueryIndex>();
                indexes.add(new QueryIndex(COLUMN1_NAME));
                indexes.add(new QueryIndex(COLUMN2_NAME));
                qryEntity.setIndexes(indexes);
                cacheCfg.setQueryEntities(Collections.singletonList(qryEntity));
                continue;
            }
            if (!"group2".equals(cacheCfg.getGroupName()) || !CACHE_NAME3.equals(cacheCfg.getName())) continue;
            qryEntity = new QueryEntity(Long.class.getCanonicalName(), OBJECT_NAME3);
            qryEntity.setKeyFieldName(KEY_NAME);
            fields = new LinkedHashMap();
            fields.put(KEY_NAME, Long.class.getCanonicalName());
            fields.put(COLUMN1_NAME, Integer.class.getCanonicalName());
            fields.put(COLUMN2_NAME, String.class.getCanonicalName());
            qryEntity.setFields(fields);
            indexes = new ArrayList();
            indexes.add(new QueryIndex(COLUMN1_NAME));
            indexes.add(new QueryIndex(COLUMN2_NAME));
            qryEntity.setIndexes(indexes);
            cacheCfg.setQueryEntities(Collections.singletonList(qryEntity));
        }
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        GridQueryProcessor.idxCls = null;
    }

    @Test
    public void testIndexRebuildCountPartitionsLeft() throws Exception {
        this.pds = true;
        GridQueryProcessor.idxCls = AbstractIndexingCommonTest.BlockingIndexing.class;
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        String cacheName2 = CACHE_NAME2;
        String cacheName3 = CACHE_NAME3;
        IgniteCache cache2 = ignite.cache(cacheName2);
        IgniteCache cache3 = ignite.cache(cacheName3);
        cache2.put((Object)1L, (Object)1L);
        cache3.put((Object)1L, (Object)1L);
        int parts2 = ignite.cachex(cacheName2).configuration().getAffinity().partitions();
        int parts3 = ignite.cachex(cacheName3).configuration().getAffinity().partitions();
        ignite.cluster().active(false);
        File dir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)false);
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"index.bin");
        Collection idxBinFiles = FileUtils.listFiles((File)dir, (IOFileFilter)filter, (IOFileFilter)TrueFileFilter.TRUE);
        for (File indexBin : idxBinFiles) {
            U.delete((File)indexBin);
        }
        ignite.cluster().active(true);
        MetricRegistry grpMreg = (MetricRegistry)this.cacheGroupMetrics(0, "group2").get2();
        LongMetric indexBuildCountPartitionsLeft = (LongMetric)grpMreg.findMetric("IndexBuildCountPartitionsLeft");
        CacheGroupMetricsWithIndexTest.assertEquals((long)(parts2 + parts3), (long)indexBuildCountPartitionsLeft.value());
        ((AbstractIndexingCommonTest.BlockingIndexing)ignite.context().query().getIndexing()).stopBlock(cacheName2);
        ignite.cache(cacheName2).indexReadyFuture().get(30000L);
        CacheGroupMetricsWithIndexTest.assertEquals((long)parts3, (long)indexBuildCountPartitionsLeft.value());
        ((AbstractIndexingCommonTest.BlockingIndexing)ignite.context().query().getIndexing()).stopBlock(cacheName3);
        ignite.cache(cacheName3).indexReadyFuture().get(30000L);
        CacheGroupMetricsWithIndexTest.assertEquals((long)0L, (long)indexBuildCountPartitionsLeft.value());
    }

    @Test
    public void testIndexCreateCountPartitionsLeft() throws Exception {
        this.pds = true;
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        IgniteCache cache2 = ignite.cache(CACHE_NAME2);
        String addColSql = "ALTER TABLE \"cache2\".MyObject2 ADD COLUMN col3 BIGINT";
        cache2.query(new SqlFieldsQuery(addColSql)).getAll();
        for (int i = 0; i < 100000; ++i) {
            Long id = i;
            BinaryObjectBuilder o = ignite.binary().builder(OBJECT_NAME2).setField(KEY_NAME, (Object)id).setField(COLUMN1_NAME, (Object)(i / 2)).setField(COLUMN2_NAME, (Object)("str" + Integer.toHexString(i))).setField(COLUMN3_NAME, (Object)(id * 10L));
            cache2.put((Object)id, (Object)o.build());
        }
        MetricRegistry metrics = (MetricRegistry)this.cacheGroupMetrics(0, "group2").get2();
        GridTestUtils.runAsync(() -> {
            String createIdxSql = "CREATE INDEX testindex001 ON \"cache2\".MyObject2(col3)";
            cache2.query(new SqlFieldsQuery(createIdxSql)).getAll();
            String selectIdxSql = "select * from sys.indexes where index_name='testindex001'";
            List all = cache2.query(new SqlFieldsQuery(selectIdxSql)).getAll();
            CacheGroupMetricsWithIndexTest.assertEquals((String)"Index not found", (int)1, (int)all.size());
        });
        LongMetric indexBuildCountPartitionsLeft = (LongMetric)metrics.findMetric("IndexBuildCountPartitionsLeft");
        CacheGroupMetricsWithIndexTest.assertTrue((String)"Timeout wait start build index", (boolean)GridTestUtils.waitForCondition(() -> indexBuildCountPartitionsLeft.value() > 0L, (long)30000L));
        CacheGroupMetricsWithIndexTest.assertTrue((String)"Timeout wait finished build index", (boolean)GridTestUtils.waitForCondition(() -> indexBuildCountPartitionsLeft.value() == 0L, (long)30000L));
    }

    @Test
    public void testIndexRebuildCountPartitionsLeftInCluster() throws Exception {
        this.pds = true;
        IgniteEx ignite = this.startGrid(0);
        this.startGrid(1);
        ignite.cluster().active(true);
        IgniteCache cache2 = ignite.cache(CACHE_NAME2);
        IgniteCache cache3 = ignite.cache(CACHE_NAME3);
        try (IgniteDataStreamer s = ignite.dataStreamer(CACHE_NAME2);){
            for (int i = 0; i < 100000; ++i) {
                Long id = i;
                BinaryObjectBuilder o = ignite.binary().builder(OBJECT_NAME2).setField(KEY_NAME, (Object)id).setField(COLUMN1_NAME, (Object)(i / 2)).setField(COLUMN2_NAME, (Object)("str" + Integer.toHexString(i)));
                s.addData((Object)id, (Object)o.build());
            }
        }
        String addColSql = "ALTER TABLE \"cache3\".MyObject3 ADD COLUMN col3 BIGINT";
        cache3.query(new SqlFieldsQuery(addColSql)).getAll();
        try (IgniteDataStreamer s = ignite.dataStreamer(CACHE_NAME3);){
            for (long id = 100000L; id < 200000L; ++id) {
                BinaryObjectBuilder o2 = ignite.binary().builder(OBJECT_NAME3).setField(KEY_NAME, (Object)(id * 3L)).setField(COLUMN1_NAME, (Object)((int)(id / 2L))).setField(COLUMN2_NAME, (Object)("str" + Long.toHexString(id))).setField(COLUMN3_NAME, (Object)(id * 10L));
                s.addData((Object)id, (Object)o2.build());
            }
        }
        String consistentId = ignite.cluster().localNode().consistentId().toString().replace(".", "_");
        this.stopGrid(0);
        File dir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)false);
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"index.bin");
        Collection idxBinFiles = FileUtils.listFiles((File)dir, (IOFileFilter)filter, (IOFileFilter)TrueFileFilter.TRUE);
        for (File indexBin : idxBinFiles) {
            if (!indexBin.getAbsolutePath().contains(consistentId)) continue;
            U.delete((File)indexBin);
        }
        ignite = this.startGrid(0);
        MetricRegistry metrics = (MetricRegistry)this.cacheGroupMetrics(0, "group2").get2();
        LongMetric indexBuildCountPartitionsLeft = (LongMetric)metrics.findMetric("IndexBuildCountPartitionsLeft");
        CacheGroupMetricsWithIndexTest.assertTrue((String)"Timeout wait start rebuild index", (boolean)GridTestUtils.waitForCondition(() -> indexBuildCountPartitionsLeft.value() > 0L, (long)30000L));
        cache3 = ignite.cache(CACHE_NAME3);
        String createIdxSql = "CREATE INDEX ON \"cache3\".MyObject3(col3)";
        cache3.query(new SqlFieldsQuery(createIdxSql)).getAll();
        CacheGroupMetricsWithIndexTest.assertTrue((String)"Timeout wait finished rebuild index", (boolean)GridTestUtils.waitForCondition(() -> {
            CacheGroupMetricsWithIndexTest.assertTrue((String)"indexBuildCountPartitionsLeft below zero", (indexBuildCountPartitionsLeft.value() >= 0L ? 1 : 0) != 0);
            return indexBuildCountPartitionsLeft.value() == 0L;
        }, (long)30000L));
        CacheGroupMetricsWithIndexTest.assertTrue((String)"Checking for the absence of indexBuildCountPartitionsLeft below zero", (indexBuildCountPartitionsLeft.value() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testIndexCreateCountPartitionsLeftInCluster() throws Exception {
        this.pds = true;
        IgniteEx ignite = this.startGrid(0);
        this.startGrid(1);
        ignite.cluster().active(true);
        IgniteCache cache2 = ignite.cache(CACHE_NAME2);
        String addColSql = "ALTER TABLE \"cache2\".MyObject2 ADD COLUMN col3 BIGINT";
        cache2.query(new SqlFieldsQuery(addColSql)).getAll();
        for (int i = 0; i < 100000; ++i) {
            Long id = i;
            BinaryObjectBuilder o = ignite.binary().builder(OBJECT_NAME2).setField(KEY_NAME, (Object)id).setField(COLUMN1_NAME, (Object)(i / 2)).setField(COLUMN2_NAME, (Object)("str" + Integer.toHexString(i))).setField(COLUMN3_NAME, (Object)(id * 10L));
            cache2.put((Object)id, (Object)o.build());
        }
        this.stopGrid(1);
        MetricRegistry metrics = (MetricRegistry)this.cacheGroupMetrics(0, "group2").get2();
        GridTestUtils.runAsync(() -> {
            String createIdxSql = "CREATE INDEX testindex001 ON \"cache2\".MyObject2(col3)";
            cache2.query(new SqlFieldsQuery(createIdxSql)).getAll();
            String selectIdxSql = "select * from sys.indexes where index_name='testindex001'";
            List all = cache2.query(new SqlFieldsQuery(selectIdxSql)).getAll();
            CacheGroupMetricsWithIndexTest.assertEquals((String)"Index not found", (int)1, (int)all.size());
        });
        LongMetric indexBuildCountPartitionsLeft0 = (LongMetric)metrics.findMetric("IndexBuildCountPartitionsLeft");
        CacheGroupMetricsWithIndexTest.assertTrue((String)"Timeout wait start build index", (boolean)GridTestUtils.waitForCondition(() -> indexBuildCountPartitionsLeft0.value() > 0L, (long)30000L));
        CacheGroupMetricsWithIndexTest.assertTrue((String)"Timeout wait finished build index", (boolean)GridTestUtils.waitForCondition(() -> indexBuildCountPartitionsLeft0.value() == 0L, (long)30000L));
        this.startGrid(1);
        metrics = (MetricRegistry)this.cacheGroupMetrics(1, "group2").get2();
        LongMetric indexBuildCountPartitionsLeft1 = (LongMetric)metrics.findMetric("IndexBuildCountPartitionsLeft");
        CacheGroupMetricsWithIndexTest.assertTrue((String)"Timeout wait start build index", (boolean)GridTestUtils.waitForCondition(() -> indexBuildCountPartitionsLeft1.value() > 0L, (long)30000L));
        CacheGroupMetricsWithIndexTest.assertTrue((String)"Timeout wait finished build index", (boolean)GridTestUtils.waitForCondition(() -> indexBuildCountPartitionsLeft1.value() == 0L, (long)30000L));
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-46251")
    public void testCacheGroupMetrics() throws Exception {
        super.testCacheGroupMetrics();
    }
}

