/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryBasicNameMapper;
import org.apache.ignite.binary.BinaryNameMapper;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class BinarySimpleNameRegistrationTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "TWO_TEST_CACHE";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        return BinarySimpleNameRegistrationTest.applyBinaryConfig(cfg);
    }

    private static IgniteConfiguration applyBinaryConfig(IgniteConfiguration cfg) {
        cfg.setBinaryConfiguration(new BinaryConfiguration().setCompactFooter(true).setNameMapper((BinaryNameMapper)new BinaryBasicNameMapper().setSimpleName(true)));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    private void insertData() throws Exception {
        IgniteEx ignite = this.startClientGrid(1);
        IgniteCache cache = ignite.getOrCreateCache(CACHE_NAME);
        SqlFieldsQuery queryCreate = new SqlFieldsQuery("CREATE TABLE IF NOT EXISTS TWO_TEST_CACHE (ID INTEGER NOT NULL, NAME VARCHAR NOT NULL, ADDRESS VARCHAR NOT NULL, primary key (ID)) WITH \"atomicity=transactional, key_type=org.apache.ignite.internal.processors.cache.BinarySimpleNameRegistrationTest$KnTwoTestCacheKey, value_type=org.apache.ignite.internal.processors.cache.BinarySimpleNameRegistrationTest$KnTwoTestCacheValue, cache_name=TWO_TEST_CACHE\";");
        cache.query(queryCreate).getAll();
        SqlFieldsQuery queryDelete = new SqlFieldsQuery("DELETE FROM TWO_TEST_CACHE");
        cache.query(queryDelete).getAll();
        SqlFieldsQuery queryInsert = new SqlFieldsQuery("insert into TWO_TEST_CACHE values (101,'sanjiv','acharyya')");
        cache.query(queryInsert).getAll();
        SqlFieldsQuery queryAll = new SqlFieldsQuery("SELECT * FROM TWO_TEST_CACHE");
        List all = cache.query(queryAll).getAll();
        BinarySimpleNameRegistrationTest.assertEquals((String)"1 entries should be on the cache", (int)1, (int)all.size());
        List all1 = cache.withKeepBinary().query((Query)new ScanQuery()).getAll();
        BinarySimpleNameRegistrationTest.assertEquals((String)"1 entries should be on the cache", (int)1, (int)all1.size());
        System.out.println("*** INSERTING FINISHED ***");
    }

    @Test
    public void shouldReadPreviouslyInsertedDataThickClient() throws Exception {
        this.startGrid(0);
        this.insertData();
        IgniteEx ignite2 = this.startClientGrid(2);
        IgniteCache clientCache = ignite2.cache(CACHE_NAME);
        clientCache.put((Object)new KnTwoTestCacheKey(102), (Object)new KnTwoTestCacheValue("name", "address"));
        BinarySimpleNameRegistrationTest.assertEquals((String)"Cache size", (int)2, (int)clientCache.size(new CachePeekMode[0]));
        List entries = clientCache.query((Query)new ScanQuery()).getAll();
        BinarySimpleNameRegistrationTest.assertEquals((String)"Size must be", (int)2, (int)entries.size());
        BinarySimpleNameRegistrationTest.assertTrue((String)"Found element inserted via SQL", (boolean)entries.stream().anyMatch(e -> new KnTwoTestCacheKey(101).equals(e.getKey())));
        BinarySimpleNameRegistrationTest.assertTrue((String)"Found element inserted via Java", (boolean)entries.stream().anyMatch(e -> new KnTwoTestCacheKey(102).equals(e.getKey())));
    }

    @Test
    public void shouldReadPreviouslyInsertedDataThinClient() throws Exception {
        this.startGrid(0);
        this.insertData();
        ClientConfiguration cfg = new ClientConfiguration();
        cfg.setAddresses(new String[]{"127.0.0.1:10800"});
        IgniteClient client = Ignition.startClient((ClientConfiguration)cfg);
        ClientCache clientCache = client.cache(CACHE_NAME);
        clientCache.put((Object)new KnTwoTestCacheKey(102), (Object)new KnTwoTestCacheValue("name", "address"));
        BinarySimpleNameRegistrationTest.assertEquals((String)"Cache size", (int)2, (int)clientCache.size(new CachePeekMode[0]));
        List entries = clientCache.query((Query)new ScanQuery()).getAll();
        BinarySimpleNameRegistrationTest.assertEquals((String)"Size must be", (int)2, (int)entries.size());
        BinarySimpleNameRegistrationTest.assertTrue((String)"Found element inserted via SQL", (boolean)entries.stream().anyMatch(e -> new KnTwoTestCacheKey(101).equals(e.getKey())));
        BinarySimpleNameRegistrationTest.assertTrue((String)"Found element inserted via Java", (boolean)entries.stream().anyMatch(e -> new KnTwoTestCacheKey(102).equals(e.getKey())));
    }

    @Test
    public void shouldWriteDataAndNotCauseDuplicatedRegistration() throws Exception {
        this.startGrid(0);
        this.insertData();
        ClientConfiguration cfg = new ClientConfiguration();
        cfg.setAddresses(new String[]{"127.0.0.1:10800"});
        IgniteClient client = Ignition.startClient((ClientConfiguration)cfg);
        ClientCache clientCache = client.cache(CACHE_NAME);
        clientCache.put((Object)new KnTwoTestCacheKey(102), (Object)new KnTwoTestCacheValue("name", "address"));
    }

    public class KnTwoTestCacheValue
    implements Serializable {
        private String NAME;
        private String ADDRESS;

        public String getNAME() {
            return this.NAME;
        }

        public void setNAME(String NAME) {
            this.NAME = NAME;
        }

        public String getADDRESS() {
            return this.ADDRESS;
        }

        public void setADDRESS(String ADDRESS) {
            this.ADDRESS = ADDRESS;
        }

        public KnTwoTestCacheValue() {
        }

        public KnTwoTestCacheValue(String name, String address) {
            this.NAME = name;
            this.ADDRESS = address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KnTwoTestCacheValue that = (KnTwoTestCacheValue)o;
            return Objects.equals(this.NAME, that.NAME) && Objects.equals(this.ADDRESS, that.ADDRESS);
        }

        public int hashCode() {
            return Objects.hash(this.NAME, this.ADDRESS);
        }

        public String toString() {
            return "KnTwoTestCacheValue{name='" + this.NAME + '\'' + ", address='" + this.ADDRESS + '\'' + '}';
        }
    }

    public class KnTwoTestCacheKey
    implements Serializable {
        private Integer ID;

        public KnTwoTestCacheKey(int i) {
            this.ID = i;
        }

        public Integer getId() {
            return this.ID;
        }

        public void setId(Integer id) {
            this.ID = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KnTwoTestCacheKey that = (KnTwoTestCacheKey)o;
            return Objects.equals(this.ID, that.ID);
        }

        public int hashCode() {
            return Objects.hash(this.ID);
        }

        public String toString() {
            return "KnTwoTestCacheKey{id=" + this.ID + '}';
        }
    }
}

