/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.internal.metric.SqlStatisticsAbstractTest;
import org.apache.ignite.internal.metric.UserQueriesTestBase;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SqlStatisticsUserQueriesLongTest
extends UserQueriesTestBase {
    @After
    public void stopAll() {
        this.stopAllGrids();
    }

    @Test
    public void testInitialValuesAreZero() throws Exception {
        this.startGrids(2);
        this.createCacheFrom((Ignite)this.grid(0));
        Assert.assertEquals((long)0L, (long)this.longMetricValue(0, "success"));
        Assert.assertEquals((long)0L, (long)this.longMetricValue(0, "failed"));
        Assert.assertEquals((long)0L, (long)this.longMetricValue(0, "canceled"));
        Assert.assertEquals((long)0L, (long)this.longMetricValue(0, "failedByOOM"));
        Assert.assertEquals((long)0L, (long)this.longMetricValue(1, "success"));
        Assert.assertEquals((long)0L, (long)this.longMetricValue(1, "failed"));
        Assert.assertEquals((long)0L, (long)this.longMetricValue(1, "canceled"));
        Assert.assertEquals((long)0L, (long)this.longMetricValue(1, "failedByOOM"));
    }

    @Test
    public void testMetricsOnRemoteMapFail() throws Exception {
        int strongMemQuota = 0x100000;
        int memQuotaUnlimited = 0;
        this.startGridWithMaxMem(1, strongMemQuota);
        this.startGridWithMaxMem(0, memQuotaUnlimited, true);
        IgniteCache cache = this.createCacheFrom((Ignite)this.grid(0));
        String mapFailMsg = "SQL query ran out of memory: Global quota was exceeded.";
        this.assertMetricsIncrementedOnlyOnReducer(() -> {
            SqlMemoryQuotaExceededException cfr_ignored_0 = (SqlMemoryQuotaExceededException)GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB").setLazy(false)).getAll(), SqlMemoryQuotaExceededException.class, (String)"SQL query ran out of memory: Global quota was exceeded.");
        }, "failed");
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.refresh();
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.setProcessRowsToSuspend(1);
        this.assertMetricsIncrementedOnlyOnReducer(() -> {
            CacheException cfr_ignored_0 = (CacheException)GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID < 200 AND failFunction() = 5")).getAll(), CacheException.class, (String)"Failed to execute map query on remote node");
        }, "failed");
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.refresh();
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.setProcessRowsToSuspend(1);
        this.assertMetricsIncrementedOnlyOnReducer(() -> this.startAndKillQuery(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID < 200 AND suspendHook(ID) <> 5 ")), "success", "failed", "canceled");
    }

    @Test
    public void testMetricsOnLocalMapFail() throws Exception {
        int strongMemQuota = 0x100000;
        int memQuotaUnlimited = 0;
        this.startGridWithMaxMem(0, strongMemQuota);
        this.startGridWithMaxMem(1, memQuotaUnlimited, true);
        IgniteCache cache = this.createCacheFrom((Ignite)this.grid(0));
        String mapFailMsg = "SQL query ran out of memory: Global quota was exceeded.";
        this.assertMetricsIncrementedOnlyOnReducer(() -> {
            SqlMemoryQuotaExceededException cfr_ignored_0 = (SqlMemoryQuotaExceededException)GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB").setLazy(false)).getAll(), SqlMemoryQuotaExceededException.class, (String)"SQL query ran out of memory: Global quota was exceeded.");
        }, "failed");
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.refresh();
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.setProcessRowsToSuspend(1);
        this.assertMetricsIncrementedOnlyOnReducer(() -> {
            CacheException cfr_ignored_0 = (CacheException)GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID < 200 AND failFunction() = 5")).getAll(), CacheException.class, (String)"Failed to execute map query on remote node");
        }, "failed");
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.refresh();
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.setProcessRowsToSuspend(1);
        this.assertMetricsIncrementedOnlyOnReducer(() -> this.startAndKillQuery(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID < 200 AND suspendHook(ID) <> 5 ")), "success", "failed", "canceled");
    }

    @Test
    public void testMetricsOnRemoteReduceStepFail() throws Exception {
        int strongMemQuota = 0x100000;
        int memQuotaUnlimited = 0;
        this.startGridWithMaxMem(1, memQuotaUnlimited);
        this.startGridWithMaxMem(0, strongMemQuota, true);
        IgniteCache cache = this.createCacheFrom((Ignite)this.grid(0));
        String rdcFailMsg = "SQL query ran out of memory: Global quota was exceeded.";
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.refresh();
        this.assertMetricsIncrementedOnlyOnReducer(() -> GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery("SELECT id, failFunction(count(id)) FROM TAB WHERE ID < 5 GROUP BY NAME HAVING ID < 5")).getAll(), CacheException.class, (String)"Failed to run reduce query locally."), "failed");
        this.assertMetricsIncrementedOnlyOnReducer(() -> {
            SqlMemoryQuotaExceededException cfr_ignored_0 = (SqlMemoryQuotaExceededException)GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB GROUP BY NAME")).getAll(), SqlMemoryQuotaExceededException.class, (String)"SQL query ran out of memory: Global quota was exceeded.");
        }, "failed", "failedByOOM");
    }

    @Test
    public void testLocalSelectFailedByOOM() throws Exception {
        int strongMemQuota = 0x100000;
        int memQuotaUnlimited = 0;
        this.startGridWithMaxMem(0, strongMemQuota);
        this.startGridWithMaxMem(1, memQuotaUnlimited, true);
        IgniteCache cache = this.createCacheFrom((Ignite)this.grid(0));
        this.assertMetricsIncrementedOnlyOnReducer(() -> {
            CacheException cfr_ignored_0 = (CacheException)GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB").setLocal(true).setLazy(false)).getAll(), CacheException.class, null);
        }, "failed", "failedByOOM");
    }
}

