/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import java.util.Objects;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.spi.metric.Metric;
import org.junit.Assert;
import org.junit.Test;

public class SqlStatisticOffloadingTest
extends DiskSpillingAbstractTest {
    @Override
    protected int nodeCount() {
        return 2;
    }

    @Override
    protected boolean startClient() {
        return true;
    }

    @Override
    protected boolean fromClient() {
        return true;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setSqlConfiguration(new SqlConfiguration().setSqlGlobalMemoryQuota("16k").setSqlOffloadingEnabled(true));
    }

    @Test
    public void testOffloadStats() {
        Metrics m0 = this.withdrawMetrics();
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, "SELECT * FROM person WHERE id < 10");
        SqlStatisticOffloadingTest.assertEquals((Object)m0, (Object)this.withdrawMetrics());
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_WITH_OFFLOADING, "SELECT * FROM person WHERE id < 100 GROUP BY name ORDER BY id");
        Metrics m1 = this.withdrawMetrics();
        Metrics expected = m0.add(Metrics.of(6249L, 6249L, 1L, 16878L, 16878L, 2L));
        SqlStatisticOffloadingTest.assertEquals((Object)expected, (Object)m1);
        if (log.isInfoEnabled()) {
            log.info("Offloading stats: \n" + m1);
        }
    }

    @Test
    public void testOffloadStatsParallel() throws Exception {
        Metrics m0 = this.withdrawMetrics();
        String qry = "SELECT * FROM person WHERE id < 100 GROUP BY name ORDER BY id";
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_WITH_OFFLOADING, "SELECT * FROM person WHERE id < 100 GROUP BY name ORDER BY id");
        Metrics m1 = this.withdrawMetrics();
        Metrics diff = m1.subtract(m0);
        SqlStatisticOffloadingTest.assertTrue((String)("Metrics not changed after offloading: " + diff), (boolean)diff.notZero());
        int iterations = 100;
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_WITH_OFFLOADING, "SELECT * FROM person WHERE id < 100 GROUP BY name ORDER BY id", IgniteConfiguration.DFLT_QUERY_THREAD_POOL_SIZE, 100);
        Metrics m2 = this.withdrawMetrics();
        Metrics expected = m1.add(diff.multiply(IgniteConfiguration.DFLT_QUERY_THREAD_POOL_SIZE * 100));
        SqlStatisticOffloadingTest.assertEquals((Object)expected, (Object)m2);
        if (log.isInfoEnabled()) {
            log.info("Offloading stats: \n" + m2);
        }
    }

    private long longMetricValue(boolean client, String metricName) {
        IgniteEx node = client ? this.grid("client") : this.grid(0);
        MetricRegistry sqlMemReg = node.context().metric().registry("sql.memory.quotas");
        Metric metric = sqlMemReg.findMetric(metricName);
        Assert.assertNotNull((String)("Didn't find metric " + metricName), (Object)metric);
        Assert.assertTrue((String)("Expected long metric, but got " + metric.getClass()), (boolean)(metric instanceof LongMetric));
        return ((LongMetric)metric).value();
    }

    private Metrics withdrawMetrics() {
        return Metrics.of(this.longMetricValue(false, "OffloadingWritten"), this.longMetricValue(false, "OffloadingRead"), this.longMetricValue(false, "OffloadedQueriesNumber"), this.longMetricValue(true, "OffloadingWritten"), this.longMetricValue(true, "OffloadingRead"), this.longMetricValue(true, "OffloadedQueriesNumber"));
    }

    private static class Metrics {
        private final long writtenServer;
        private final long readServer;
        private final long filesNumServer;
        private final long writtenClient;
        private final long readClient;
        private final long fileNumClient;

        private Metrics(long writtenServer, long readServer, long filesNumServer, long writtenClient, long readClient, long fileNumClient) {
            this.writtenServer = writtenServer;
            this.readServer = readServer;
            this.filesNumServer = filesNumServer;
            this.writtenClient = writtenClient;
            this.readClient = readClient;
            this.fileNumClient = fileNumClient;
        }

        Metrics add(Metrics add) {
            return Metrics.of(this.writtenServer + add.writtenServer, this.readServer + add.readServer, this.filesNumServer + add.filesNumServer, this.writtenClient + add.writtenClient, this.readClient + add.readClient, this.fileNumClient + add.fileNumClient);
        }

        Metrics subtract(Metrics sub) {
            return Metrics.of(this.writtenServer - sub.writtenServer, this.readServer - sub.readServer, this.filesNumServer - sub.filesNumServer, this.writtenClient - sub.writtenClient, this.readClient - sub.readClient, this.fileNumClient - sub.fileNumClient);
        }

        Metrics multiply(long multiplier) {
            return Metrics.of(this.writtenServer * multiplier, this.readServer * multiplier, this.filesNumServer * multiplier, this.writtenClient * multiplier, this.readClient * multiplier, this.fileNumClient * multiplier);
        }

        boolean notZero() {
            return this.writtenServer > 0L && this.readServer > 0L && this.filesNumServer > 0L && this.writtenClient > 0L && this.readClient > 0L && this.fileNumClient > 0L;
        }

        static Metrics of(long writtenServer, long readServer, long filesNumServer, long writtenClient, long readClient, long fileNumClient) {
            return new Metrics(writtenServer, readServer, filesNumServer, writtenClient, readClient, fileNumClient);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Metrics metrics = (Metrics)o;
            return this.writtenServer == metrics.writtenServer && this.readServer == metrics.readServer && this.filesNumServer == metrics.filesNumServer && this.writtenClient == metrics.writtenClient && this.readClient == metrics.readClient && this.fileNumClient == metrics.fileNumClient;
        }

        public int hashCode() {
            return Objects.hash(this.writtenServer, this.readServer, this.filesNumServer, this.writtenClient, this.readClient, this.fileNumClient);
        }

        public String toString() {
            return "Metrics{writtenServer=" + this.writtenServer + ", readServer=" + this.readServer + ", filesNumServer=" + this.filesNumServer + ", writtenClient=" + this.writtenClient + ", readClient=" + this.readClient + ", fileNumClient=" + this.fileNumClient + '}';
        }
    }
}

