/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.Config;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class IgniteBinaryQueryTest {
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Test
    public void testBinaryQueries() throws Exception {
        try (Ignite ignored = Ignition.start((IgniteConfiguration)Config.getServerConfiguration());
             IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}));){
            String TYPE_NAME = "Person";
            QueryEntity qryPerson = new QueryEntity().setKeyType(Integer.class.getName()).setValueType("Person").setFields(Stream.of(new AbstractMap.SimpleEntry<String, String>("id", Integer.class.getName()), new AbstractMap.SimpleEntry<String, String>("name", String.class.getName())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (a, b) -> a, LinkedHashMap::new))).setIndexes(Collections.singletonList(new QueryIndex("id")));
            ClientCacheConfiguration cacheCfg = new ClientCacheConfiguration().setName("testBinaryQueries").setQueryEntities(new QueryEntity[]{qryPerson});
            ClientCache cache = client.getOrCreateCache(cacheCfg).withKeepBinary();
            IgniteBinary binary = client.binary();
            Map<Integer, BinaryObject> data = IntStream.range(0, 100).boxed().collect(Collectors.toMap(i -> i, i -> binary.builder("Person").setField("id", i, Integer.TYPE).setField("name", (Object)String.format("Person %s", i), String.class).build()));
            cache.putAll(data);
            Cache.Entry p1 = (Cache.Entry)cache.query((Query)new SqlQuery("Person", "id = 1")).getAll().iterator().next();
            Assert.assertEquals((Object)1, (Object)p1.getKey());
            this.assertBinaryObjectsEqual(data.get(1), (BinaryObject)p1.getValue());
        }
    }

    private void assertBinaryTypesEqual(BinaryType exp, BinaryType actual) {
        Assert.assertEquals((long)exp.typeId(), (long)actual.typeId());
        Assert.assertEquals((Object)exp.typeName(), (Object)actual.typeName());
        Assert.assertEquals((Object)exp.fieldNames(), (Object)actual.fieldNames());
        for (String f : exp.fieldNames()) {
            Assert.assertEquals((Object)exp.fieldTypeName(f), (Object)actual.fieldTypeName(f));
        }
        Assert.assertEquals((Object)exp.affinityKeyFieldName(), (Object)actual.affinityKeyFieldName());
        Assert.assertEquals((Object)exp.isEnum(), (Object)actual.isEnum());
    }

    private void assertBinaryObjectsEqual(BinaryObject exp, BinaryObject actual) throws Exception {
        this.assertBinaryTypesEqual(exp.type(), actual.type());
        for (String f : exp.type().fieldNames()) {
            Object expVal = exp.field(f);
            Class<?> cls = expVal.getClass();
            if (cls.getMethod("equals", Object.class).getDeclaringClass() != cls) continue;
            Assert.assertEquals((Object)expVal, (Object)actual.field(f));
        }
        if (exp.type().isEnum()) {
            Assert.assertEquals((long)exp.enumOrdinal(), (long)actual.enumOrdinal());
        }
    }
}

