/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ClientQueryPartitionLossTest
extends GridCommonAbstractTest {
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        return super.getConfiguration(gridName).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true))).setClientConnectorConfiguration(new ClientConnectorConfiguration().setMaxOpenCursorsPerConnection(3));
    }

    @Test
    public void testPartitionLossSqlFieldsQuery() throws Exception {
        this.testPartitionLoss(cache -> {
            SqlFieldsQuery sqlFieldsQuery = new SqlFieldsQuery("select id, name from \"Person\".PERSON where id = ?");
            sqlFieldsQuery.setArgs(new Object[]{ThreadLocalRandom.current().nextLong(100L)});
            return cache.query(sqlFieldsQuery);
        });
    }

    @Test
    public void testPartitionLossSqlQuery() throws Exception {
        this.testPartitionLoss(cache -> {
            SqlQuery sqlQuery = new SqlQuery(Person.class, "select * from PERSON where id = ?");
            sqlQuery.setArgs(new Object[]{ThreadLocalRandom.current().nextLong(100L)});
            return cache.query((Query)sqlQuery);
        });
    }

    @Test
    public void testPartitionLossScanQuery() throws Exception {
        this.testPartitionLoss(cache -> cache.query((Query)new ScanQuery()));
    }

    private void testPartitionLoss(Function<ClientCache<Integer, Person>, QueryCursor<?>> queryFunc) throws Exception {
        IgniteEx srv1 = this.startGrid(0);
        IgniteEx srv2 = this.startGrid(1);
        srv1.cluster().state(ClusterState.ACTIVE);
        ClientConfiguration cfg = new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"});
        IgniteClient client = Ignition.startClient((ClientConfiguration)cfg);
        ClientCacheConfiguration ccfg = new ClientCacheConfiguration().setName("Person").setQueryEntities(new QueryEntity[]{ClientQueryPartitionLossTest.createPersonQueryEntity()});
        ClientCache personCache = client.getOrCreateCache(ccfg);
        for (int i = 0; i < 100; ++i) {
            personCache.put((Object)i, (Object)new Person("Name" + i));
        }
        boolean partitionsLost = false;
        for (int i = 0; i < 100; ++i) {
            if (i == 10) {
                srv2.close();
            }
            try (QueryCursor<?> cursor = queryFunc.apply((ClientCache<Integer, Person>)personCache);){
                cursor.getAll();
                continue;
            }
            catch (ClientException e) {
                if (e.getMessage().contains("Failed to execute query because cache partition has been lost [cacheName=Person")) {
                    partitionsLost = true;
                    e.printStackTrace();
                    continue;
                }
                throw e;
            }
        }
        ClientQueryPartitionLossTest.assertTrue((boolean)partitionsLost);
    }

    private static QueryEntity createPersonQueryEntity() {
        return new QueryEntity().setValueType(Person.class.getName()).setKeyType(Integer.class.getName()).addQueryField("id", Integer.class.getName(), null).addQueryField("name", String.class.getName(), null).setKeyFieldName("id").setTableName("PERSON");
    }

    private static class Person
    implements Serializable {
        public String name;

        public Person() {
        }

        public Person(String name) {
            this.name = name;
        }
    }
}

