/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cache.query.RangeIndexQueryCriterion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RepeatedFieldIndexQueryTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final String ID_IDX = "ID_IDX";
    private static final String DESC_ID_IDX = "DESC_ID_IDX";
    private static final int CNT = 10000;
    private static IgniteCache<Integer, Person> cache;
    @Parameterized.Parameter
    public String idxName;
    @Parameterized.Parameter(value=1)
    public String fldName;

    @Parameterized.Parameters(name="idx={0} fldName={1}")
    public static List<Object[]> params() {
        return F.asList((Object[])new Object[][]{{ID_IDX, "id"}, {DESC_ID_IDX, "descId"}});
    }

    protected void beforeTestsStarted() throws Exception {
        IgniteEx crd = this.startGrids(2);
        cache = crd.cache(CACHE);
        for (int i = 0; i < 10000; ++i) {
            cache.put((Object)i, (Object)new Person(i));
        }
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg1 = new CacheConfiguration().setName(CACHE).setIndexedTypes(new Class[]{Integer.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1});
        return cfg;
    }

    @Test
    public void testRangeQueriesWithTwoCriteriaSingleField() {
        int lower = new Random().nextInt(5000);
        int upper = 5000 + new Random().nextInt(4999);
        List<IndexQueryCriterion> criteria = this.criteria(this.fldName, lower, upper);
        ArrayList<T2> checks = new ArrayList<T2>();
        for (int i = 0; i < criteria.size(); ++i) {
            for (int j = 0; j < criteria.size(); ++j) {
                checks.add(new T2((Object)((RangeIndexQueryCriterion)criteria.get(i)), (Object)((RangeIndexQueryCriterion)criteria.get(j))));
            }
        }
        checks.forEach(c -> this.checkTwoCriteria((RangeIndexQueryCriterion)c.get1(), (RangeIndexQueryCriterion)c.get2()));
    }

    @Test
    public void testMergeMultipleCriteriaForSingleField() {
        int lower = new Random().nextInt(5000);
        int upper = 5000 + new Random().nextInt(4999);
        IndexQuery qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)this.fldName, (Object)lower), IndexQueryCriteriaBuilder.gt((String)this.fldName, (Object)(lower - 1)), IndexQueryCriteriaBuilder.gt((String)this.fldName, (Object)(lower - 2)), IndexQueryCriteriaBuilder.lt((String)this.fldName, (Object)upper), IndexQueryCriteriaBuilder.lt((String)this.fldName, (Object)(upper + 1)), IndexQueryCriteriaBuilder.lt((String)this.fldName, (Object)(upper + 2))});
        this.check(null, (QueryCursor<Cache.Entry<Integer, Person>>)cache.query((Query)qry), lower + 1, upper);
    }

    @Test
    public void testMultipleEqualsCriteria() {
        int lower = new Random().nextInt(5000);
        int upper = 5000 + new Random().nextInt(4999);
        this.checkEqualsCriteria(lower, upper, 0, 10000);
        this.checkEqualsCriteria(lower, upper, 10000, 0);
        this.checkEqualsCriteria(upper, lower, 0, 10000);
        this.checkEqualsCriteria(upper, lower, 10000, 0);
    }

    private void checkEqualsCriteria(int eq1, int eq2, int from, int to) {
        IndexQuery qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.eq((String)this.fldName, (Object)eq1), IndexQueryCriteriaBuilder.eq((String)this.fldName, (Object)eq2), IndexQueryCriteriaBuilder.between((String)this.fldName, (Object)from, (Object)to)});
        cache.query((Query)qry).getAll();
    }

    @Test
    public void testCommonBoundary() {
        int boundary = new Random().nextInt(5000);
        this.checkEmptyForCommonBoundary(IndexQueryCriteriaBuilder.lt((String)this.fldName, (Object)boundary), IndexQueryCriteriaBuilder.gt((String)this.fldName, (Object)boundary));
        this.checkEmptyForCommonBoundary(IndexQueryCriteriaBuilder.lte((String)this.fldName, (Object)boundary), IndexQueryCriteriaBuilder.gt((String)this.fldName, (Object)boundary));
        this.checkEmptyForCommonBoundary(IndexQueryCriteriaBuilder.lt((String)this.fldName, (Object)boundary), IndexQueryCriteriaBuilder.gte((String)this.fldName, (Object)boundary));
        IndexQuery qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)this.fldName, (Object)boundary), IndexQueryCriteriaBuilder.gte((String)this.fldName, (Object)boundary)});
        this.check(null, (QueryCursor<Cache.Entry<Integer, Person>>)cache.query((Query)qry), boundary, boundary + 1);
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)this.fldName, (Object)0, (Object)boundary), IndexQueryCriteriaBuilder.between((String)this.fldName, (Object)boundary, (Object)10000)});
        this.check(null, (QueryCursor<Cache.Entry<Integer, Person>>)cache.query((Query)qry), boundary, boundary + 1);
    }

    private void checkEmptyForCommonBoundary(IndexQueryCriterion c1, IndexQueryCriterion c2) {
        IndexQuery qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{c1, c2});
        cache.query((Query)qry).getAll();
    }

    @Test
    public void testCorrectMergeMultipleBoundaries() {
        Random rnd = new Random();
        List boundaries = IntStream.range(0, 10).boxed().map(i -> rnd.nextInt(10000)).collect(Collectors.toList());
        int min = (Integer)boundaries.stream().min(Integer::compareTo).get();
        int max = (Integer)boundaries.stream().max(Integer::compareTo).get();
        List ltCriteria = boundaries.stream().map(b -> IndexQueryCriteriaBuilder.lt((String)this.fldName, (Object)b)).collect(Collectors.toList());
        List gtCriteria = boundaries.stream().map(b -> IndexQueryCriteriaBuilder.gt((String)this.fldName, (Object)b)).collect(Collectors.toList());
        IndexQuery qry = new IndexQuery(Person.class, this.idxName).setCriteria(ltCriteria);
        this.check(null, (QueryCursor<Cache.Entry<Integer, Person>>)cache.query((Query)qry), 0, min);
        qry = new IndexQuery(Person.class, this.idxName).setCriteria(gtCriteria);
        this.check(null, (QueryCursor<Cache.Entry<Integer, Person>>)cache.query((Query)qry), max + 1, 10000);
    }

    private <T> void check(String errMsg, QueryCursor<Cache.Entry<Integer, Person>> cursor, int left, int right) {
        List all = cursor.getAll();
        RepeatedFieldIndexQueryTest.assertEquals((String)errMsg, (int)(right - left), (int)all.size());
        boolean desc = Objects.equals(this.idxName, DESC_ID_IDX);
        for (int i = 0; i < all.size(); ++i) {
            Cache.Entry entry = (Cache.Entry)all.get(i);
            int exp = desc ? right - 1 - i : left + i;
            RepeatedFieldIndexQueryTest.assertEquals((String)errMsg, (int)exp, (int)((Integer)entry.getKey()));
        }
    }

    private List<IndexQueryCriterion> criteria(String fld, int val1, int val2) {
        return F.asList((Object[])new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)fld, (Object)val1), IndexQueryCriteriaBuilder.lte((String)fld, (Object)val1), IndexQueryCriteriaBuilder.gt((String)fld, (Object)val1), IndexQueryCriteriaBuilder.gte((String)fld, (Object)val1), IndexQueryCriteriaBuilder.between((String)fld, (Object)val1, (Object)val2)});
    }

    private void checkTwoCriteria(RangeIndexQueryCriterion c1, RangeIndexQueryCriterion c2) {
        IndexQuery qry = new IndexQuery(Person.class, this.idxName).setCriteria(new IndexQueryCriterion[]{c1, c2});
        Range expRange = this.mergeRange(new Range(c1.lower() == null ? 0 : (Integer)c1.lower(), c1.upper() == null ? 10000 : (Integer)c1.upper(), c1.lowerIncl(), c1.upperIncl()), new Range(c2.lower() == null ? 0 : (Integer)c2.lower(), c2.upper() == null ? 10000 : (Integer)c2.upper(), c2.lowerIncl(), c2.upperIncl()));
        int lower = expRange.lower();
        int upper = expRange.upper();
        String errMsg = "Fail crit pair: " + c1 + ", " + c2 + ". Lower=" + lower + ", upper=" + upper;
        if (expRange.valid()) {
            this.check(errMsg, (QueryCursor<Cache.Entry<Integer, Person>>)cache.query((Query)qry), lower, upper);
        } else {
            RepeatedFieldIndexQueryTest.assertEquals((int)0, (int)cache.query((Query)qry).getAll().size());
        }
    }

    private Range mergeRange(Range range1, Range range2) {
        int left = range1.left;
        boolean leftIncl = range1.leftIncl;
        if (range2.left > left) {
            left = range2.left;
            leftIncl = range2.leftIncl;
        } else if (range2.left == left) {
            leftIncl = leftIncl && range2.leftIncl;
        }
        int right = range1.right;
        boolean rightIncl = range1.rightIncl;
        if (range2.right < right) {
            right = range2.right;
            rightIncl = range2.rightIncl;
        } else if (range2.right == right) {
            rightIncl = rightIncl && range2.rightIncl;
        }
        return new Range(left, right, leftIncl, rightIncl);
    }

    private static class Range {
        final int left;
        final int right;
        final boolean leftIncl;
        final boolean rightIncl;

        Range(int left, int right, boolean leftIncl, boolean rightIncl) {
            this.left = left;
            this.right = right;
            this.leftIncl = leftIncl;
            this.rightIncl = rightIncl;
        }

        int lower() {
            return this.leftIncl ? this.left : this.left + 1;
        }

        int upper() {
            return this.rightIncl ? (this.right == 10000 ? 10000 : this.right + 1) : this.right;
        }

        boolean valid() {
            return this.left < this.right || this.left == this.right && this.leftIncl && this.rightIncl;
        }
    }

    private static class Person {
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="ID_IDX", order=0)})
        final int id;
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="DESC_ID_IDX", order=0, descending=true)})
        final int descId;

        Person(int id) {
            this.id = id;
            this.descId = id;
        }
    }
}

