/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultifieldIndexQueryTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final String INDEX = "TEST_IDX";
    private static final String DESC_INDEX = "TEST_DESC_IDX";
    private static final int CNT = 10000;
    @Parameterized.Parameter
    public int nodesCnt;
    @Parameterized.Parameter(value=1)
    public String qryIdx;
    @Parameterized.Parameter(value=2)
    public String qryDescIdx;
    @Parameterized.Parameter(value=3)
    public String qryKeyPKIdx;
    private Ignite ignite;
    private IgniteCache<Object, Object> cache;

    @Parameterized.Parameters(name="nodesCnt={0} qryIdx={1}")
    public static Collection<Object[]> testParams() {
        return Arrays.asList({1, null, null, null}, {2, null, null, null}, {1, INDEX, DESC_INDEX, "_key_PK"}, {2, INDEX, DESC_INDEX, "_key_PK"});
    }

    protected void beforeTest() throws Exception {
        this.ignite = this.startGrids(this.nodesCnt);
        this.cache = this.ignite.cache(CACHE);
    }

    protected void afterTest() {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Long.class, Person.class}).setQueryParallelism(4);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    @Test
    public void testQueryKeyPKIndex() {
        this.insertData();
        int pivot = new Random().nextInt(10000);
        IndexQuery qry = new IndexQuery(Person.class, this.qryKeyPKIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"_KEY", (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, pivot, false);
    }

    @Test
    public void testEmptyCacheQuery() {
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)Integer.MAX_VALUE), IndexQueryCriteriaBuilder.lt((String)"secId", (Object)Integer.MAX_VALUE)});
        QueryCursor cursor = this.cache.query((Query)qry);
        MultifieldIndexQueryTest.assertTrue((boolean)cursor.getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)Integer.MAX_VALUE)});
        MultifieldIndexQueryTest.assertTrue((boolean)this.cache.query((Query)qry).getAll().isEmpty());
    }

    @Test
    public void testCheckBoundaries() {
        this.cache.put((Object)1L, (Object)new Person(0, 1));
        this.cache.put((Object)2L, (Object)new Person(1, 0));
        this.cache.put((Object)3L, (Object)new Person(1, 1));
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"id", (Object)0, (Object)1), IndexQueryCriteriaBuilder.eq((String)"secId", (Object)1)});
        List result = this.cache.query((Query)qry).getAll();
        MultifieldIndexQueryTest.assertEquals((int)2, (int)result.size());
        result.sort(Comparator.comparingLong(Cache.Entry::getKey));
        MultifieldIndexQueryTest.assertEquals((long)1L, (long)((Long)((Cache.Entry)result.get(0)).getKey()));
        MultifieldIndexQueryTest.assertEquals((long)3L, (long)((Long)((Cache.Entry)result.get(1)).getKey()));
        MultifieldIndexQueryTest.assertEquals((Object)new Person(0, 1), (Object)((Cache.Entry)result.get(0)).getValue());
        MultifieldIndexQueryTest.assertEquals((Object)new Person(1, 1), (Object)((Cache.Entry)result.get(1)).getValue());
    }

    @Test
    public void testQuerySingleField() {
        this.insertData();
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)-1)});
        MultifieldIndexQueryTest.assertTrue((boolean)this.cache.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)1)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, 10000, false);
        qry = new IndexQuery(Person.class, this.qryDescIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)-1)});
        MultifieldIndexQueryTest.assertTrue((boolean)this.cache.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.qryDescIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)1)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, 10000, this.qryDescIdx != null);
    }

    @Test
    public void testLtQueryMultipleField() {
        this.insertData();
        int pivot = new Random().nextInt(10000);
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)-1), IndexQueryCriteriaBuilder.lt((String)"secId", (Object)pivot)});
        MultifieldIndexQueryTest.assertTrue((boolean)this.cache.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)1), IndexQueryCriteriaBuilder.lt((String)"secId", (Object)10000)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, 10000, false);
        qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)0), IndexQueryCriteriaBuilder.lt((String)"secId", (Object)pivot)});
        MultifieldIndexQueryTest.assertTrue((boolean)this.cache.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)1), IndexQueryCriteriaBuilder.lt((String)"secId", (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, pivot, false);
    }

    @Test
    public void testLtQueryMultipleFieldReverseFieldsOrder() {
        this.insertData();
        int pivot = new Random().nextInt(10000);
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"secId", (Object)pivot), IndexQueryCriteriaBuilder.lt((String)"id", (Object)-1)});
        MultifieldIndexQueryTest.assertTrue((boolean)this.cache.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"secId", (Object)10000), IndexQueryCriteriaBuilder.lt((String)"id", (Object)1)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, 10000, false);
        qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"secId", (Object)pivot), IndexQueryCriteriaBuilder.lt((String)"id", (Object)0)});
        MultifieldIndexQueryTest.assertTrue((boolean)this.cache.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"secId", (Object)pivot), IndexQueryCriteriaBuilder.lt((String)"id", (Object)1)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, pivot, false);
    }

    @Test
    public void testLegalDifferentCriteriaAscIndex() {
        this.testLegalDifferentCriteria(this.qryIdx, "secId", false);
    }

    @Test
    public void testLegalDifferentCriteriaWithDescIdx() {
        this.testLegalDifferentCriteria(this.qryDescIdx, "descId", true);
    }

    public void testLegalDifferentCriteria(String idxName, String fldName, boolean desc) {
        this.insertData();
        int pivot = new Random().nextInt(10000);
        IndexQuery qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.eq((String)"id", (Object)1), IndexQueryCriteriaBuilder.lt((String)fldName, (Object)pivot)});
        MultifieldIndexQueryTest.assertTrue((boolean)this.cache.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.eq((String)"id", (Object)0), IndexQueryCriteriaBuilder.lte((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, pivot + 1, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.eq((String)"id", (Object)0), IndexQueryCriteriaBuilder.gt((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot + 1, 10000, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.eq((String)"id", (Object)0), IndexQueryCriteriaBuilder.gte((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot, 10000, desc);
        int lower = new Random().nextInt(5000);
        int upper = lower + new Random().nextInt(5000);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.eq((String)"id", (Object)0), IndexQueryCriteriaBuilder.between((String)fldName, (Object)lower, (Object)upper)});
        this.checkPerson((IndexQuery<Long, Person>)qry, lower, upper + 1, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)1), IndexQueryCriteriaBuilder.lte((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, pivot + 1, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)1), IndexQueryCriteriaBuilder.eq((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot, pivot + 1, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)1), IndexQueryCriteriaBuilder.between((String)fldName, (Object)lower, (Object)upper)});
        this.checkPerson((IndexQuery<Long, Person>)qry, lower, upper + 1, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)"id", (Object)0), IndexQueryCriteriaBuilder.lt((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, pivot, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)"id", (Object)1), IndexQueryCriteriaBuilder.between((String)fldName, (Object)lower, (Object)upper)});
        this.checkPerson((IndexQuery<Long, Person>)qry, lower, upper + 1, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)"id", (Object)0), IndexQueryCriteriaBuilder.eq((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot, pivot + 1, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)"id", (Object)-1), IndexQueryCriteriaBuilder.gte((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot, 10000, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)"id", (Object)-1), IndexQueryCriteriaBuilder.eq((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot, pivot + 1, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)"id", (Object)-1), IndexQueryCriteriaBuilder.between((String)fldName, (Object)lower, (Object)upper)});
        this.checkPerson((IndexQuery<Long, Person>)qry, lower, upper + 1, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"id", (Object)0), IndexQueryCriteriaBuilder.gt((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot + 1, 10000, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"id", (Object)0), IndexQueryCriteriaBuilder.between((String)fldName, (Object)lower, (Object)upper)});
        this.checkPerson((IndexQuery<Long, Person>)qry, lower, upper + 1, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"id", (Object)0), IndexQueryCriteriaBuilder.eq((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot, pivot + 1, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"id", (Object)-1, (Object)1), IndexQueryCriteriaBuilder.lt((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, pivot, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"id", (Object)-1, (Object)1), IndexQueryCriteriaBuilder.lte((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, pivot + 1, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"id", (Object)-1, (Object)1), IndexQueryCriteriaBuilder.gt((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot + 1, 10000, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"id", (Object)-1, (Object)1), IndexQueryCriteriaBuilder.gte((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot, 10000, desc);
        qry = new IndexQuery(Person.class, idxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"id", (Object)-1, (Object)1), IndexQueryCriteriaBuilder.eq((String)fldName, (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot, pivot + 1, desc);
    }

    @Test
    public void testNoRightIndexRangeDifferentCriteria() {
        this.insertData();
        int pivot = new Random().nextInt(10000);
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)1), IndexQueryCriteriaBuilder.gt((String)"secId", (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot + 1, 10000, false);
        qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)1), IndexQueryCriteriaBuilder.gte((String)"secId", (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, pivot, 10000, false);
        qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)"id", (Object)2), IndexQueryCriteriaBuilder.lt((String)"secId", (Object)pivot)});
        MultifieldIndexQueryTest.assertTrue((boolean)this.cache.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)"id", (Object)2), IndexQueryCriteriaBuilder.eq((String)"secId", (Object)pivot)});
        MultifieldIndexQueryTest.assertTrue((boolean)this.cache.query((Query)qry).getAll().isEmpty());
    }

    @Test
    public void testIncorrectBoundaryClass() {
        this.insertData();
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)"0")});
        this.cache.query((Query)qry).getAll();
    }

    @Test
    public void testQueryIndexWithKeyQuery() {
        this.insertData();
        int pivot = new Random().nextInt(10000);
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.eq((String)"id", (Object)0), IndexQueryCriteriaBuilder.lt((String)"secId", (Object)pivot), IndexQueryCriteriaBuilder.lt((String)"_KEY", (Object)pivot)});
        this.checkPerson((IndexQuery<Long, Person>)qry, 0, pivot, false);
    }

    private void insertData() {
        try (IgniteDataStreamer streamer = this.ignite.dataStreamer(this.cache.getName());){
            for (int i = 0; i < 10000; ++i) {
                streamer.addData((Object)i, (Object)new Person(i));
            }
        }
    }

    private void checkPerson(IndexQuery<Long, Person> qry, int left, int right, boolean desc) {
        boolean fullSort = qry.getCriteria().size() == 2;
        List all = this.cache.query(qry).getAll();
        if (this.qryIdx == null) {
            if (desc) {
                all.sort(Comparator.comparing(Cache.Entry::getKey, Comparator.reverseOrder()));
            } else {
                all.sort(Comparator.comparing(Cache.Entry::getKey));
            }
        }
        MultifieldIndexQueryTest.assertEquals((int)(right - left), (int)all.size());
        Set expKeys = fullSort ? null : LongStream.range(left, right).boxed().collect(Collectors.toSet());
        for (int i = 0; i < all.size(); ++i) {
            Cache.Entry entry = (Cache.Entry)all.get(i);
            if (fullSort) {
                int exp = desc ? right - 1 - i : left + i;
                MultifieldIndexQueryTest.assertEquals((int)exp, (int)((Long)entry.getKey()).intValue());
            } else {
                MultifieldIndexQueryTest.assertTrue((boolean)expKeys.remove(entry.getKey()));
            }
            MultifieldIndexQueryTest.assertEquals((Object)new Person(((Long)entry.getKey()).intValue()), (Object)((Cache.Entry)all.get(i)).getValue());
        }
    }

    private static class Person {
        @GridToStringInclude
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="TEST_IDX", order=0), @QuerySqlField.Group(name="TEST_DESC_IDX", order=0)})
        final int id;
        @GridToStringInclude
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="TEST_IDX", order=1)})
        final int secId;
        @GridToStringInclude
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="TEST_DESC_IDX", order=1, descending=true)})
        final int descId;

        Person(int secId) {
            this.id = 0;
            this.secId = secId;
            this.descId = secId;
        }

        Person(int id, int secId) {
            this.id = id;
            this.secId = secId;
            this.descId = secId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.id, person.id) && Objects.equals(this.secId, person.secId);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.secId);
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

