/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultiTableIndexQuery
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final String IDX = "PERSON_ID_IDX";
    private static final String SEC_IDX = "SECONDPERSON_ID_IDX";
    private static final int CNT = 10000;
    private static IgniteCache<Long, Object> cache;
    @Parameterized.Parameter(value=0)
    public String qryPersIdx;
    @Parameterized.Parameter(value=1)
    public String qrySecPersIdx;
    @Parameterized.Parameter(value=2)
    public String qryKeyPkIdx;

    @Parameterized.Parameters(name="IDX={0}, SEC_IDX={1}, PK={2}")
    public static Collection<Object[]> params() {
        return F.asList((Object[])new Object[][]{{null, null, null}, {IDX, SEC_IDX, "_key_PK"}});
    }

    protected void beforeTestsStarted() throws Exception {
        IgniteEx crd = this.startGrids(4);
        cache = crd.cache(CACHE);
    }

    protected void afterTest() {
        cache.clear();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Long.class, Person.class, Long.class, SecondPerson.class}).setQueryParallelism(4);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    @Test
    public void testEmptyCache() {
        IndexQuery qry = new IndexQuery(Person.class, this.qryPersIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)Integer.MAX_VALUE)});
        QueryCursor cursor = cache.query((Query)qry);
        MultiTableIndexQuery.assertTrue((boolean)cursor.getAll().isEmpty());
        IndexQuery secQry = new IndexQuery(SecondPerson.class, this.qrySecPersIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)Integer.MAX_VALUE)});
        QueryCursor secCursor = cache.query((Query)secQry);
        MultiTableIndexQuery.assertTrue((boolean)secCursor.getAll().isEmpty());
    }

    @Test
    public void testLtQuery() {
        this.insertData(cache);
        int pivot = new Random().nextInt(10000);
        IndexQuery secQry = new IndexQuery(SecondPerson.class, this.qrySecPersIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)(10000 + pivot))});
        this.checkSecondPerson((QueryCursor<Cache.Entry<Long, SecondPerson>>)cache.query((Query)secQry), 10000, 10000 + pivot);
        IndexQuery qry = new IndexQuery(Person.class, this.qryPersIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)pivot)});
        this.checkPerson((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, pivot);
        secQry = new IndexQuery(SecondPerson.class, this.qrySecPersIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)"id", (Object)(10000 + pivot))});
        this.checkSecondPerson((QueryCursor<Cache.Entry<Long, SecondPerson>>)cache.query((Query)secQry), 10000, 10000 + pivot + 1);
        qry = new IndexQuery(Person.class, this.qryPersIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)"id", (Object)pivot)});
        this.checkPerson((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, pivot + 1);
        secQry = new IndexQuery(SecondPerson.class, this.qrySecPersIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)"id", (Object)(10000 + pivot))});
        this.checkSecondPerson((QueryCursor<Cache.Entry<Long, SecondPerson>>)cache.query((Query)secQry), 10000 + pivot + 1, 20000);
        qry = new IndexQuery(Person.class, this.qryPersIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)"id", (Object)pivot)});
        this.checkPerson((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), pivot + 1, 10000);
        secQry = new IndexQuery(SecondPerson.class, this.qrySecPersIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"id", (Object)(10000 + pivot))});
        this.checkSecondPerson((QueryCursor<Cache.Entry<Long, SecondPerson>>)cache.query((Query)secQry), 10000 + pivot, 20000);
        qry = new IndexQuery(Person.class, this.qryPersIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"id", (Object)pivot)});
        this.checkPerson((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), pivot, 10000);
    }

    @Test
    public void testKeyPK() {
        this.insertData(cache);
        int pivot = new Random().nextInt(10000);
        IndexQuery secQry = new IndexQuery(SecondPerson.class, this.qryKeyPkIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"_KEY", (Object)(10000 + pivot))});
        this.checkSecondPerson((QueryCursor<Cache.Entry<Long, SecondPerson>>)cache.query((Query)secQry), 10000, 10000 + pivot);
        IndexQuery qry = new IndexQuery(Person.class, this.qryKeyPkIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"_KEY", (Object)pivot)});
        this.checkPerson((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, pivot);
        secQry = new IndexQuery(SecondPerson.class, this.qryKeyPkIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)"_KEY", (Object)(10000 + pivot))});
        this.checkSecondPerson((QueryCursor<Cache.Entry<Long, SecondPerson>>)cache.query((Query)secQry), 10000, 10000 + pivot + 1);
        qry = new IndexQuery(Person.class, this.qryKeyPkIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)"_KEY", (Object)pivot)});
        this.checkPerson((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, pivot + 1);
        secQry = new IndexQuery(SecondPerson.class, this.qryKeyPkIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)"_KEY", (Object)(10000 + pivot))});
        this.checkSecondPerson((QueryCursor<Cache.Entry<Long, SecondPerson>>)cache.query((Query)secQry), 10000 + pivot + 1, 20000);
        qry = new IndexQuery(Person.class, this.qryKeyPkIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)"_KEY", (Object)pivot)});
        this.checkPerson((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), pivot + 1, 10000);
        secQry = new IndexQuery(SecondPerson.class, this.qryKeyPkIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"_KEY", (Object)(10000 + pivot))});
        this.checkSecondPerson((QueryCursor<Cache.Entry<Long, SecondPerson>>)cache.query((Query)secQry), 10000 + pivot, 20000);
        qry = new IndexQuery(Person.class, this.qryKeyPkIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"_KEY", (Object)pivot)});
        this.checkPerson((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), pivot, 10000);
    }

    private void insertData(IgniteCache<Long, Object> cache) {
        for (int i = 0; i < 10000; ++i) {
            cache.put((Object)i, (Object)new Person(i));
            cache.put((Object)(10000L + (long)i), (Object)new SecondPerson(10000 + i));
        }
    }

    private void checkPerson(QueryCursor<Cache.Entry<Long, Person>> cursor, int left, int right) {
        List all = cursor.getAll();
        MultiTableIndexQuery.assertEquals((int)(right - left), (int)all.size());
        Set expKeys = LongStream.range(left, right).boxed().collect(Collectors.toSet());
        for (int i = 0; i < all.size(); ++i) {
            Cache.Entry entry = (Cache.Entry)all.get(i);
            MultiTableIndexQuery.assertTrue((boolean)expKeys.remove(entry.getKey()));
            MultiTableIndexQuery.assertEquals((Object)new Person(((Long)entry.getKey()).intValue()), (Object)((Cache.Entry)all.get(i)).getValue());
        }
    }

    private void checkSecondPerson(QueryCursor<Cache.Entry<Long, SecondPerson>> cursor, int left, int right) {
        List all = cursor.getAll();
        if (this.qryPersIdx == null) {
            all.sort((o1, o2) -> Long.compare((Long)o1.getKey(), (Long)o2.getKey()));
        }
        MultiTableIndexQuery.assertEquals((int)(right - left), (int)all.size());
        for (int i = 0; i < all.size(); ++i) {
            Cache.Entry entry = (Cache.Entry)all.get(i);
            MultiTableIndexQuery.assertEquals((int)(left + i), (int)((Long)entry.getKey()).intValue());
            MultiTableIndexQuery.assertEquals((Object)new SecondPerson(((Long)entry.getKey()).intValue()), (Object)((Cache.Entry)all.get(i)).getValue());
        }
    }

    private static class SecondPerson {
        @QuerySqlField(index=true)
        int id;

        SecondPerson(int id) {
            this.id = id;
        }

        public String toString() {
            return "SecondPerson[id=" + this.id + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SecondPerson person = (SecondPerson)o;
            return Objects.equals(this.id, person.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private static class Person {
        @QuerySqlField(index=true)
        int id;

        Person(int id) {
            this.id = id;
        }

        public String toString() {
            return "Person[id=" + this.id + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.id, person.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

