/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IndexQueryLimitTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final String IDX = "PERSON_ID_IDX";
    private static final int CNT = 10000;
    private Ignite crd;

    protected void beforeTest() throws Exception {
        this.crd = this.startGrids(4);
    }

    protected void afterTest() {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE).setIndexedTypes(new Class[]{Long.class, Person.class}).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.REPLICATED);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    @Test
    public void testRangeQueriesWithoutDuplicates() throws Exception {
        this.checkRangeQueries(1);
    }

    @Test
    public void testRangeQueriesWithDuplicates() throws Exception {
        this.checkRangeQueries(10);
    }

    @Test
    public void testSetLimit() {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> new IndexQuery(Person.class, IDX).setLimit(0), IllegalArgumentException.class, (String)"Limit must be positive.");
        int limit = 1 + new Random().nextInt(1000);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> new IndexQuery(Person.class, IDX).setLimit(0 - limit), IllegalArgumentException.class, (String)"Limit must be positive.");
        IndexQuery qry = new IndexQuery(Person.class, IDX);
        qry.setLimit(limit);
        IndexQueryLimitTest.assertEquals((int)limit, (int)qry.getLimit());
    }

    private void checkRangeQueries(int duplicates) throws Exception {
        this.insertData(duplicates);
        this.checkLimit(null, 0, 10000, duplicates);
        int pivot = new Random().nextInt(10000);
        this.checkLimit(IndexQueryCriteriaBuilder.lt((String)"id", (Object)pivot), 0, pivot, duplicates);
    }

    private void checkLimit(IndexQueryCriterion criterion, int left, int right, int duplicates) throws Exception {
        int rows = right - left;
        int limit = new Random().nextInt(rows) + 1;
        this.checkLimit(criterion, limit, left, left + limit, duplicates);
        if (rows > 1) {
            limit = new Random().nextInt(10002 - rows) + rows;
            this.checkLimit(criterion, limit, left, right, duplicates);
        }
    }

    private void checkLimit(IndexQueryCriterion criterion, int limit, int left, int right, int duplicates) throws Exception {
        IndexQuery qry = new IndexQuery(Person.class, IDX);
        if (criterion != null) {
            qry.setCriteria(new IndexQueryCriterion[]{criterion});
        }
        qry.setLimit(limit);
        QueryCursor cursor = this.crd.cache(CACHE).query((Query)qry);
        int expSize = (right - left) * duplicates;
        if (limit > 0 && limit < expSize) {
            expSize = limit;
        }
        HashSet<Long> expKeys = new HashSet<Long>(expSize);
        LinkedList<Integer> expOrderedValues = new LinkedList<Integer>();
        block0: for (int i = left; i != right; ++i) {
            for (int j = 0; j < duplicates; ++j) {
                expOrderedValues.add(i);
                expKeys.add(10000L * (long)j + (long)i);
                if (expOrderedValues.size() >= limit) break block0;
            }
        }
        AtomicInteger actSize = new AtomicInteger();
        ((QueryCursorEx)cursor).getAll(entry -> {
            IndexQueryLimitTest.assertEquals(expOrderedValues.remove(0), (Object)((Person)entry.getValue()).id);
            IndexQueryLimitTest.assertTrue((boolean)expKeys.remove(entry.getKey()));
            int persId = ((Long)entry.getKey()).intValue() % 10000;
            IndexQueryLimitTest.assertEquals((Object)new Person(persId), (Object)entry.getValue());
            actSize.incrementAndGet();
        });
        IndexQueryLimitTest.assertEquals((int)expSize, (int)actSize.get());
        IndexQueryLimitTest.assertTrue((boolean)expKeys.isEmpty());
    }

    private void insertData(int duplicates) {
        try (IgniteDataStreamer streamer = this.crd.dataStreamer(CACHE);){
            for (int persId = 0; persId < 10000; ++persId) {
                for (int i = 0; i < duplicates; ++i) {
                    streamer.addData((Object)(10000L * (long)i + (long)persId), (Object)new Person(persId));
                }
            }
        }
    }

    private static class Person {
        @QuerySqlField(index=true)
        final int id;

        Person(int id) {
            this.id = id;
        }

        public String toString() {
            return "Person[id=" + this.id + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.id, person.id);
        }

        public int hashCode() {
            return this.id;
        }
    }
}

