/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IndexQueryKeepBinaryTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final String IDX = "PERSON_ID_IDX";
    private static final int CNT = 10000;
    private static IgniteCache<Long, Person> cache;

    protected void beforeTestsStarted() throws Exception {
        IgniteEx crd = this.startGrids(2);
        cache = crd.cache(CACHE);
        this.insertData((Ignite)crd, cache);
    }

    protected void afterTestsStopped() {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Long.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    @Test
    public void testServerNodeReplicatedCache() {
        IndexQuery qry = new IndexQuery(Person.class, IDX).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)5000)});
        this.check(cache.withKeepBinary().query((Query)qry), 0, 5000);
    }

    @Test
    public void testBinaryFilter() {
        IndexQuery qry = new IndexQuery(Person.class, IDX).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)5000)}).setFilter((IgniteBiPredicate & Serializable)(k, v) -> (Integer)v.field("id") > 2500);
        this.check(cache.withKeepBinary().query((Query)qry), 2501, 5000);
    }

    @Test
    public void testComplexSqlPrimaryKey() {
        String valType = "MY_VALUE_TYPE";
        String tblCacheName = "MY_TABLE_CACHE";
        SqlFieldsQuery qry = new SqlFieldsQuery("create table my_table (id1 int, id2 int, id3 int, PRIMARY KEY(id1, id2)) with \"VALUE_TYPE=" + valType + ",CACHE_NAME=" + tblCacheName + "\";");
        cache.query(qry);
        qry = new SqlFieldsQuery("insert into my_table(id1, id2, id3) values(?, ?, ?);");
        for (int i = 0; i < 10000; ++i) {
            qry.setArgs(new Object[]{i, i, i});
            cache.query(qry);
        }
        int pivot = new Random().nextInt(10000);
        IgniteCache tblCache = this.grid(0).cache(tblCacheName);
        IndexQuery idxQry = new IndexQuery(valType, "_key_PK").setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id1", (Object)pivot)});
        this.checkBinary(tblCache.withKeepBinary().query((Query)idxQry), 0, pivot);
    }

    private void check(QueryCursor cursor, int left, int right) {
        List all = cursor.getAll();
        IndexQueryKeepBinaryTest.assertEquals((int)(right - left), (int)all.size());
        for (int i = 0; i < all.size(); ++i) {
            Cache.Entry entry = (Cache.Entry)all.get(i);
            IndexQueryKeepBinaryTest.assertEquals((int)(left + i), (int)((Long)entry.getKey()).intValue());
            BinaryObject o = (BinaryObject)((Cache.Entry)all.get(i)).getValue();
            IndexQueryKeepBinaryTest.assertEquals((Object)new Person(((Long)entry.getKey()).intValue()), (Object)o.deserialize());
        }
    }

    private void checkBinary(QueryCursor cursor, int left, int right) {
        List all = cursor.getAll();
        IndexQueryKeepBinaryTest.assertEquals((int)(right - left), (int)all.size());
        for (int i = 0; i < all.size(); ++i) {
            Cache.Entry entry = (Cache.Entry)all.get(i);
            IndexQueryKeepBinaryTest.assertEquals((int)(left + i), (int)((Integer)((BinaryObject)entry.getKey()).field("id1")));
            IndexQueryKeepBinaryTest.assertEquals((int)(left + i), (int)((Integer)((BinaryObject)entry.getKey()).field("id2")));
            IndexQueryKeepBinaryTest.assertEquals((int)(left + i), (int)((Integer)((BinaryObject)entry.getValue()).field("id3")));
        }
    }

    private void insertData(Ignite ignite, IgniteCache cache) {
        try (IgniteDataStreamer streamer = ignite.dataStreamer(cache.getName());){
            for (int i = 0; i < 10000; ++i) {
                streamer.addData((Object)i, (Object)new Person(i));
            }
        }
    }

    private static class Person {
        @QuerySqlField(index=true)
        final int id;

        Person(int id) {
            this.id = id;
        }

        public String toString() {
            return "Person[id=" + this.id + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.id, person.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

