/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IndexQueryInCriterionTest
extends GridCommonAbstractTest {
    private static final String IDX = "IDX";
    private static final Map<Integer, Person> data = new HashMap<Integer, Person>();

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        QueryEntity qe = new QueryEntity().setKeyType(Integer.class.getName()).setValueType(Person.class.getName()).addQueryField("age", Integer.class.getName(), null).addQueryField("cnt", Integer.class.getName(), null).setIndexes((Collection)F.asList((Object[])new QueryIndex[]{new QueryIndex().setName(IDX).setFields(new LinkedHashMap(F.asMap((Object)"age", (Object)this.asc()))), new QueryIndex().setName("IDX2").setFields(new LinkedHashMap(F.asMap((Object)"age", (Object)this.asc(), (Object)"cnt", (Object)true)))}));
        CacheConfiguration ccfg = new CacheConfiguration().setName("CACHE").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setQueryEntities(Collections.singleton(qe));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected boolean asc() {
        return true;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(3);
        try (IgniteDataStreamer stream = this.grid(0).dataStreamer("CACHE");){
            Random rnd = new Random();
            for (int i = 0; i < 10000; ++i) {
                Person p = new Person(rnd.nextInt(100), rnd.nextInt(10));
                stream.addData((Object)i, (Object)p);
                data.put(i, p);
            }
            stream.addData((Object)20000, (Object)new Person(null, null));
            data.put(20000, new Person(null, null));
        }
    }

    protected void afterTestsStopped() {
        this.stopAllGrids();
    }

    @Test
    public void testSingleValueInCriterion() {
        int i = -1;
        while (i <= 100) {
            IndexQuery qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(i))});
            int age = i++;
            this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == age);
        }
    }

    @Test
    public void testTwoValuesInCriterion() {
        for (int i = -1; i <= 100; ++i) {
            for (int j = -1; j <= 100; ++j) {
                IndexQuery qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"age", (Collection)F.asList((Object[])new Integer[]{i, j}))});
                int ageFirst = i;
                int ageSecond = j;
                this.assertExpect(i + " " + j, (IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == ageFirst || p.age == ageSecond);
            }
        }
    }

    @Test
    public void testMultipleInCriterion() {
        ArrayList<Integer> arr = new ArrayList<Integer>();
        for (int i = -1; i <= 100; ++i) {
            arr.add(i);
        }
        IndexQuery qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"age", arr)});
        this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> true);
    }

    @Test
    public void testSingleInWithSingleRangeCriterion() {
        List criteria = F.asList((Object[])new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)50), IndexQueryCriteriaBuilder.lte((String)"age", (Object)10), IndexQueryCriteriaBuilder.eq((String)"age", (Object)10), IndexQueryCriteriaBuilder.gte((String)"age", (Object)10), IndexQueryCriteriaBuilder.gt((String)"age", (Object)0)});
        for (IndexQueryCriterion c : criteria) {
            IndexQuery qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10)), c});
            this.assertExpect(c.toString(), (IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == 10);
            qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{c, IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10))});
            this.assertExpect(c.toString(), (IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == 10);
        }
    }

    @Test
    public void testSingleInWithMultipleRangeCriterion() {
        List criteria = F.asList((Object[])new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)50), IndexQueryCriteriaBuilder.lte((String)"age", (Object)10), IndexQueryCriteriaBuilder.eq((String)"age", (Object)10), IndexQueryCriteriaBuilder.gte((String)"age", (Object)10), IndexQueryCriteriaBuilder.gt((String)"age", (Object)0)});
        ArrayList<IndexQueryCriterion[]> rangeCritPair = new ArrayList<IndexQueryCriterion[]>();
        for (IndexQueryCriterion i : criteria) {
            for (IndexQueryCriterion j : criteria) {
                IndexQueryCriterion[] c = new IndexQueryCriterion[]{i, j};
                rangeCritPair.add(c);
            }
        }
        for (IndexQueryCriterion[] c : rangeCritPair) {
            IndexQuery qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10)), c[0], c[1]});
            this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == 10);
            qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{c[0], IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10)), c[1]});
            this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == 10);
            qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{c[0], IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10)), c[0], c[1]});
            this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == 10);
        }
    }

    @Test
    public void testMultipleInWithSingleRangeCriterion() {
        List criteria = F.asList((Object[])new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)50), IndexQueryCriteriaBuilder.lte((String)"age", (Object)20), IndexQueryCriteriaBuilder.between((String)"age", (Object)10, (Object)20), IndexQueryCriteriaBuilder.gte((String)"age", (Object)10), IndexQueryCriteriaBuilder.gt((String)"age", (Object)0)});
        for (IndexQueryCriterion c : criteria) {
            IndexQuery qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"age", (Collection)F.asList((Object[])new Integer[]{10, 20})), c});
            this.assertExpect(c.toString(), (IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == 10 || p.age == 20);
            qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{c, IndexQueryCriteriaBuilder.in((String)"age", (Collection)F.asList((Object[])new Integer[]{10, 20}))});
            this.assertExpect(c.toString(), (IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == 10 || p.age == 20);
        }
    }

    @Test
    public void testMultipleInWithSingleRangeCriterionCrossing() {
        List firstOnlyCriteria = F.asList((Object[])new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)"age", (Object)10), IndexQueryCriteriaBuilder.lte((String)"age", (Object)15), IndexQueryCriteriaBuilder.lt((String)"age", (Object)15), IndexQueryCriteriaBuilder.lt((String)"age", (Object)20), IndexQueryCriteriaBuilder.between((String)"age", (Object)5, (Object)15), IndexQueryCriteriaBuilder.between((String)"age", (Object)10, (Object)15), IndexQueryCriteriaBuilder.between((String)"age", (Object)5, (Object)10), IndexQueryCriteriaBuilder.eq((String)"age", (Object)10)});
        for (IndexQueryCriterion c : firstOnlyCriteria) {
            IndexQuery qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"age", (Collection)F.asList((Object[])new Integer[]{10, 20})), c});
            this.assertExpect(c.toString(), (IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == 10);
            qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{c, IndexQueryCriteriaBuilder.in((String)"age", (Collection)F.asList((Object[])new Integer[]{10, 20}))});
            this.assertExpect(c.toString(), (IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == 10);
        }
        List secondOnlyCriteria = F.asList((Object[])new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"age", (Object)15), IndexQueryCriteriaBuilder.gte((String)"age", (Object)20), IndexQueryCriteriaBuilder.gt((String)"age", (Object)10), IndexQueryCriteriaBuilder.gt((String)"age", (Object)15), IndexQueryCriteriaBuilder.between((String)"age", (Object)15, (Object)25), IndexQueryCriteriaBuilder.between((String)"age", (Object)20, (Object)30), IndexQueryCriteriaBuilder.between((String)"age", (Object)15, (Object)20), IndexQueryCriteriaBuilder.eq((String)"age", (Object)20)});
        for (IndexQueryCriterion c : secondOnlyCriteria) {
            IndexQuery qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"age", (Collection)F.asList((Object[])new Integer[]{10, 20})), c});
            this.assertExpect(c.toString(), (IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == 20);
            qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{c, IndexQueryCriteriaBuilder.in((String)"age", (Collection)F.asList((Object[])new Integer[]{10, 20}))});
            this.assertExpect(c.toString(), (IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == 20);
        }
    }

    @Test
    public void testExplcitiInCriterionWithNullVal() {
        IndexQuery qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(null))});
        this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == null, true);
        qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"age", (Collection)F.asList((Object[])new Integer[]{null, 10}))});
        this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> p.age == null || p.age == 10, true);
        IgniteCache cache = this.grid(0).cache("CACHE");
        qry = new IndexQuery(Person.class, "_key_PK").setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"_KEY", Collections.singleton(null))});
        IndexQueryInCriterionTest.assertEquals((int)0, (int)cache.query((Query)qry).getAll().size());
        qry = new IndexQuery(Person.class, "_key_PK").setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"_KEY", (Collection)F.asList((Object[])new Integer[]{0, null, 1}))});
        IndexQueryInCriterionTest.assertEquals((int)2, (int)cache.query((Query)qry).getAll().size());
    }

    @Test
    public void testDuplicatedInCriterion() {
        List criteria = F.asList((Object[])new IndexQueryCriterion[][]{{IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10)), IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(20))}, {IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10)), IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10))}, {IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10)), IndexQueryCriteriaBuilder.lt((String)"age", (Object)100), IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(20))}, {IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10)), IndexQueryCriteriaBuilder.lt((String)"age", (Object)100), IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10))}, {IndexQueryCriteriaBuilder.lt((String)"age", (Object)100), IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10)), IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(20))}, {IndexQueryCriteriaBuilder.lt((String)"age", (Object)100), IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10)), IndexQueryCriteriaBuilder.in((String)"age", Collections.singleton(10))}});
        for (IndexQueryCriterion[] c : criteria) {
            IndexQuery qry = new IndexQuery(Person.class).setCriteria(c);
            this.grid(0).cache("CACHE").query((Query)qry).getAll();
        }
    }

    @Test
    public void testSingleInCriterionOnSecondField() {
        for (int i = -1; i <= 100; ++i) {
            int key = i;
            IndexQuery qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"age", (Object)0), IndexQueryCriteriaBuilder.in((String)"_KEY", Collections.singleton(i))});
            this.assertExpect(String.valueOf(key), (IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == key);
            qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"_KEY", Collections.singleton(i)), IndexQueryCriteriaBuilder.gte((String)"age", (Object)0)});
            this.assertExpect(String.valueOf(key), (IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == key);
        }
    }

    @Test
    public void testMultipleInCriterionOnSecondField() {
        for (int i = -1; i < 10; ++i) {
            for (int j = -1; j < 10; ++j) {
                int firstKey = i;
                int secondKey = j;
                IndexQuery qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"age", (Object)0), IndexQueryCriteriaBuilder.in((String)"_KEY", (Collection)F.asList((Object[])new Integer[]{i, j}))});
                this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == firstKey || k == secondKey);
                qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"_KEY", (Collection)F.asList((Object[])new Integer[]{i, j})), IndexQueryCriteriaBuilder.gte((String)"age", (Object)0)});
                this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == firstKey || k == secondKey);
            }
        }
    }

    @Test
    public void testMultipleInWithRangeCrossCriterionOnSecondField() {
        Random rnd = new Random();
        int keyFirst = 0;
        int keySecond = 0;
        int ageFirst = 0;
        int ageSecond = 0;
        while (ageFirst >= ageSecond) {
            keyFirst = rnd.nextInt(10000);
            keySecond = rnd.nextInt(10000);
            ageFirst = IndexQueryInCriterionTest.data.get((Object)Integer.valueOf((int)keyFirst)).age;
            ageSecond = IndexQueryInCriterionTest.data.get((Object)Integer.valueOf((int)keySecond)).age;
        }
        int firstKey = keyFirst;
        int secondKey = keySecond;
        IndexQuery qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"age", (Object)ageSecond), IndexQueryCriteriaBuilder.in((String)"_KEY", (Collection)F.asList((Object[])new Integer[]{keyFirst, keySecond}))});
        this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == firstKey);
        qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)"age", (Object)ageSecond), IndexQueryCriteriaBuilder.in((String)"_KEY", (Collection)F.asList((Object[])new Integer[]{keyFirst, keySecond}))});
        this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == firstKey || k == secondKey);
        qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)"age", (Object)ageFirst), IndexQueryCriteriaBuilder.in((String)"_KEY", (Collection)F.asList((Object[])new Integer[]{keyFirst, keySecond}))});
        this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == firstKey);
        qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)"age", (Object)ageFirst), IndexQueryCriteriaBuilder.in((String)"_KEY", (Collection)F.asList((Object[])new Integer[]{keyFirst, keySecond}))});
        this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == secondKey);
        qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"age", (Object)ageFirst), IndexQueryCriteriaBuilder.in((String)"_KEY", (Collection)F.asList((Object[])new Integer[]{keyFirst, keySecond}))});
        this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == firstKey || k == secondKey);
        qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"age", (Object)ageSecond), IndexQueryCriteriaBuilder.in((String)"_KEY", (Collection)F.asList((Object[])new Integer[]{keyFirst, keySecond}))});
        this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == secondKey);
        qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"age", (Object)ageFirst, (Object)ageSecond), IndexQueryCriteriaBuilder.in((String)"_KEY", (Collection)F.asList((Object[])new Integer[]{keyFirst, keySecond}))});
        this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == firstKey || k == secondKey);
        qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"age", (Object)(ageFirst + 1), (Object)ageSecond), IndexQueryCriteriaBuilder.in((String)"_KEY", (Collection)F.asList((Object[])new Integer[]{keyFirst, keySecond}))});
        this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == secondKey);
        qry = new IndexQuery(Person.class).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"age", (Object)ageFirst, (Object)(ageSecond - 1)), IndexQueryCriteriaBuilder.in((String)"_KEY", (Collection)F.asList((Object[])new Integer[]{keyFirst, keySecond}))});
        this.assertExpect((IndexQuery<Integer, Person>)qry, (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k == firstKey);
    }

    @Test
    public void testMultipleInsCriteria() {
        T2[] fields = new T2[]{new T2((Object)"age", (Object)50), new T2((Object)"cnt", (Object)5), new T2((Object)"_KEY", (Object)1000)};
        for (int lteIdx = 0; lteIdx < 4; ++lteIdx) {
            IndexQueryCriterion[] crit = new IndexQueryCriterion[fields.length];
            for (int fldIdx = 0; fldIdx < fields.length; ++fldIdx) {
                crit[fldIdx] = lteIdx == fldIdx ? IndexQueryCriteriaBuilder.lte((String)((String)fields[fldIdx].getKey()), (Object)fields[fldIdx].getValue()) : IndexQueryCriteriaBuilder.in((String)((String)fields[fldIdx].getKey()), (Collection)IntStream.rangeClosed(0, (Integer)fields[fldIdx].getValue()).boxed().collect(Collectors.toSet()));
            }
            this.assertExpect((IndexQuery<Integer, Person>)new IndexQuery(Person.class).setCriteria(crit), (IgniteBiPredicate<Integer, Person>)(IgniteBiPredicate & Serializable)(k, p) -> k <= 1000 && p.age <= 50 && p.cnt <= 5);
        }
    }

    private void assertExpect(IndexQuery<Integer, Person> qry, IgniteBiPredicate<Integer, Person> expectFunc) {
        this.assertExpect(qry, expectFunc, false);
    }

    private void assertExpect(String msg, IndexQuery<Integer, Person> qry, IgniteBiPredicate<Integer, Person> expectFunc) {
        this.assertExpect(msg, qry, expectFunc, false);
    }

    private void assertExpect(IndexQuery<Integer, Person> qry, IgniteBiPredicate<Integer, Person> expectFunc, boolean checkNull) {
        this.assertExpect("", qry, expectFunc, checkNull);
    }

    private void assertExpect(String msg, IndexQuery<Integer, Person> qry, IgniteBiPredicate<Integer, Person> expectFunc, boolean checkNull) {
        HashMap expect = new HashMap();
        data.forEach((k, v) -> {
            if ((checkNull || v.age != null) && expectFunc.apply(k, v)) {
                expect.put(k, v);
            }
        });
        int expSize = expect.size();
        this.grid(0).cache("CACHE").query(qry).getAll().forEach(e -> IndexQueryInCriterionTest.assertTrue((String)(msg + " : " + e.toString() + " expSize=" + expSize + " currSize=" + expect.size()), (boolean)expect.remove(e.getKey(), e.getValue())));
        IndexQueryInCriterionTest.assertTrue((String)((Object)expect).toString(), (boolean)expect.isEmpty());
    }

    private static class Person {
        @GridToStringInclude
        final Integer age;
        @GridToStringInclude
        final Integer cnt;

        Person(Integer age, Integer cnt) {
            this.age = age;
            this.cnt = cnt;
        }

        public boolean equals(Object o) {
            return Objects.equals(this.age, ((Person)o).age) && Objects.equals(this.cnt, ((Person)o).cnt);
        }

        public int hashCode() {
            return Objects.hash(this.age, this.cnt);
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

