/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexQueryFailoverTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final String IDX = "TEST_IDX";
    private static final int CNT = 10000;
    private static IgniteCache<Long, Person> cache;
    @Parameterized.Parameter
    public String qryIdx;

    @Parameterized.Parameters(name="qryIdx={0}")
    public static List<String> params() {
        return F.asList((Object[])new String[]{null, IDX});
    }

    protected void beforeTest() throws Exception {
        IgniteEx crd = this.startGrids(2);
        cache = crd.cache(CACHE);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Long.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    @Test
    public void testQueryWithWrongCriteria() {
        GridTestUtils.assertThrowsAnyCause(null, () -> {
            IndexQuery qryNullCriteria = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt(null, (Object)12)});
            return cache.query((Query)qryNullCriteria);
        }, NullPointerException.class, (String)"Ouch! Argument cannot be null: field");
    }

    @Test
    public void testQueryWrongType() {
        GridTestUtils.assertThrows(null, () -> new IndexQuery((String)null, this.qryIdx), NullPointerException.class, (String)"Ouch! Argument cannot be null: valType");
        GridTestUtils.assertThrows(null, () -> new IndexQuery("", this.qryIdx), IllegalArgumentException.class, (String)"Ouch! Argument is invalid: valType must not be null or empty");
        GridTestUtils.assertThrowsAnyCause(null, () -> {
            IndexQuery qry = new IndexQuery(Integer.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)Integer.MAX_VALUE)});
            return cache.query((Query)qry).getAll();
        }, IgniteException.class, (String)("Failed to find SQL table for type: " + Integer.class.getSimpleName()));
    }

    @Test
    public void testQueryWrongIndexName() {
        GridTestUtils.assertThrowsAnyCause(null, () -> {
            IndexQuery qry = new IndexQuery(Person.class, "").setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)Integer.MAX_VALUE)});
            return cache.query((Query)qry).getAll();
        }, IllegalArgumentException.class, (String)"Ouch! Argument is invalid: idxName must not be empty.");
        GridTestUtils.assertThrowsAnyCause(null, () -> {
            IndexQuery qry = new IndexQuery(Person.class, "DUMMY").setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)Integer.MAX_VALUE)});
            return cache.query((Query)qry).getAll();
        }, CacheException.class, (String)"Index \"DUMMY\" not found");
    }

    @Test
    public void testQueryWrongQuery() {
        GridTestUtils.assertThrowsAnyCause(null, () -> {
            IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"dummy", (Object)Integer.MAX_VALUE)});
            return cache.query((Query)qry).getAll();
        }, CacheException.class, (String)"Column \"DUMMY\" not found.");
        GridTestUtils.assertThrowsAnyCause(null, () -> {
            IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)Integer.MAX_VALUE), IndexQueryCriteriaBuilder.lt((String)"nonExistedField", (Object)Integer.MAX_VALUE)});
            return cache.query((Query)qry).getAll();
        }, IgniteException.class, (String)"Column \"NONEXISTEDFIELD\" not found.");
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"id", (Object)432, (Object)40)});
        cache.query((Query)qry).getAll();
        Stream.of(Arrays.asList(IndexQueryCriteriaBuilder.lt((String)"id", (Object)100), IndexQueryCriteriaBuilder.gt((String)"id", (Object)101)), Arrays.asList(IndexQueryCriteriaBuilder.eq((String)"id", (Object)100), IndexQueryCriteriaBuilder.eq((String)"id", (Object)101)), Arrays.asList(IndexQueryCriteriaBuilder.eq((String)"id", (Object)101), IndexQueryCriteriaBuilder.eq((String)"id", (Object)100)), Arrays.asList(IndexQueryCriteriaBuilder.eq((String)"id", (Object)101), IndexQueryCriteriaBuilder.between((String)"id", (Object)19, (Object)40))).forEach(crit -> {
            String msg = "Failed to merge criterion " + ((IndexQueryCriterion)crit.get(1)).toString().replace("id", "ID") + " with previous criteria range " + ((IndexQueryCriterion)crit.get(0)).toString().replace("id", "ID");
            IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(crit);
            cache.query((Query)qry).getAll();
        });
    }

    @Test
    public void testConcurrentUpdateIndex() {
        Assume.assumeThat((String)"Concurrent update is not supported with index ordering", (Object)this.qryIdx, (Matcher)Matchers.nullValue());
        this.insertData(0, 10000);
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"id", (Object)5000, (Object)15000)});
        Iterator cursor = cache.query((Query)qry).iterator();
        for (int i = 0; i < 1000; ++i) {
            cursor.next();
        }
        this.insertData(10000, 20000);
        int size = 1000;
        while (cursor.hasNext()) {
            cursor.next();
            ++size;
        }
        IndexQueryFailoverTest.assertEquals((int)10001, (int)size);
    }

    private void insertData(int from, int to) {
        for (int i = from; i < to; ++i) {
            cache.put((Object)i, (Object)new Person(i));
        }
    }

    private static class Person {
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="TEST_IDX", order=0)})
        final int id;
        @QuerySqlField
        final int descId;

        Person(int id) {
            this.id = id;
            this.descId = id;
        }

        public String toString() {
            return "Person[id=" + this.id + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.id, person.id) && Objects.equals(this.descId, person.descId);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.descId);
        }
    }
}

