/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexQueryAllTypesTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final int CNT = 10000;
    private static IgniteCache<Long, Person> cache;
    @Parameterized.Parameter
    public boolean useIdxName;

    @Parameterized.Parameters(name="useIdxName={0}")
    public static List<Boolean> params() {
        return F.asList((Object[])new Boolean[]{false, true});
    }

    protected void beforeTestsStarted() throws Exception {
        IgniteEx crd = this.startGrids(2);
        cache = crd.cache(CACHE);
    }

    protected void afterTest() throws Exception {
        cache.clear();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Long.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    @Test
    public void testRangeWithNulls() {
        Function<Integer, Person> persGen = i -> {
            Integer val = i < 1000 ? null : i;
            return this.person("intNullId", val);
        };
        this.insertData(i -> i, persGen, 10000);
        int pivot = 2000;
        String intNullIdx = this.idxName("intNullId", false);
        IndexQuery qry = new IndexQuery(Person.class, intNullIdx);
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, 10000, i -> i, persGen);
        qry = new IndexQuery(Person.class, intNullIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"intNullId", (Object)pivot)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 1000, 2000, i -> i, persGen);
        qry = new IndexQuery(Person.class, intNullIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"intNullId", (Object)0)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 1000, 10000, i -> i, persGen);
        qry = new IndexQuery(Person.class, intNullIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"intNullId", (Object)0)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, 0, i -> i, persGen);
        GridTestUtils.assertThrows(null, () -> new IndexQuery(Person.class, intNullIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)"intNullId", null)}), NullPointerException.class, (String)"Ouch! Argument cannot be null: val");
        GridTestUtils.assertThrows(null, () -> new IndexQuery(Person.class, intNullIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)"intNullId", null)}), NullPointerException.class, (String)"Ouch! Argument cannot be null: val");
        GridTestUtils.assertThrows(null, () -> new IndexQuery(Person.class, intNullIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gte((String)"intNullId", null)}), NullPointerException.class, (String)"Ouch! Argument cannot be null: val");
        GridTestUtils.assertThrows(null, () -> new IndexQuery(Person.class, intNullIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"intNullId", null)}), NullPointerException.class, (String)"Ouch! Argument cannot be null: val");
        GridTestUtils.assertThrows(null, () -> new IndexQuery(Person.class, intNullIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"intNullId", null, (Object)0)}), NullPointerException.class, (String)"Ouch! Argument cannot be null: lower");
        GridTestUtils.assertThrows(null, () -> new IndexQuery(Person.class, intNullIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.between((String)"intNullId", (Object)0, null)}), NullPointerException.class, (String)"Ouch! Argument cannot be null: upper");
        qry = new IndexQuery(Person.class, intNullIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"intNullId", Collections.singleton(null))});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, 1000, i -> i, persGen);
    }

    @Test
    public void testRangeByteField() {
        this.testRangeField(Integer::byteValue, "byteId", 127);
    }

    @Test
    public void testInByteField() {
        this.testInSecondField(Integer::byteValue, "byteId", 127);
    }

    @Test
    public void testRangeShortField() {
        this.testRangeField(Integer::shortValue, "shortId");
    }

    @Test
    public void testInShortField() {
        this.testInSecondField(Integer::shortValue, "shortId");
    }

    @Test
    public void testRangeIntField() {
        this.testRangeField(i -> i, "intId");
    }

    @Test
    public void testRangeLongField() {
        this.testRangeField(Integer::longValue, "longId");
    }

    @Test
    public void testInLongField() {
        this.testInSecondField(Integer::longValue, "longId");
    }

    @Test
    public void testRangeDecimalField() {
        this.testRangeField(BigDecimal::valueOf, "decimalId");
    }

    @Test
    public void testInDecimalField() {
        this.testInSecondField(BigDecimal::valueOf, "decimalId");
    }

    @Test
    public void testRangeDoubleField() {
        this.testRangeField(Integer::doubleValue, "doubleId");
    }

    @Test
    public void testInDoubleField() {
        this.testInSecondField(Integer::doubleValue, "doubleId");
    }

    @Test
    public void testRangeFloatField() {
        this.testRangeField(Integer::floatValue, "floatId");
    }

    @Test
    public void testInFloatField() {
        this.testInSecondField(Integer::floatValue, "floatId");
    }

    @Test
    public void testRangeTimeField() {
        this.testRangeField(i -> new Time(i.longValue()), "timeId");
    }

    @Test
    public void testInTimeField() {
        this.testInSecondField(i -> new Time(i.longValue()), "timeId");
    }

    @Test
    public void testRangeDateField() {
        this.testRangeField(i -> new java.util.Date(i.longValue()), "dateId");
    }

    @Test
    public void testInDateField() {
        this.testInSecondField(i -> new java.util.Date(i.longValue()), "dateId");
    }

    @Test
    public void testRangePojoField() {
        this.testRangeField(PojoField::new, "pojoId");
    }

    @Test
    public void testInPojoField() {
        this.testInSecondField(PojoField::new, "pojoId");
    }

    @Test
    public void testRangeSqlDateField() {
        long dayMs = 86400000L;
        this.testRangeField(i -> new Date(dayMs * (long)i.intValue()), "sqlDateId");
    }

    @Test
    public void testRangeTimestampField() {
        this.testRangeField(i -> new Timestamp(i.longValue()), "timestampId");
    }

    @Test
    public void testInTimestampField() {
        this.testInSecondField(i -> new Timestamp(i.longValue()), "timestampId");
    }

    @Test
    public void testRangeBytesField() {
        this.testRangeField(i -> ByteBuffer.allocate(4).putInt((int)i).array(), "bytesId", 4);
    }

    @Test
    public void testInBytesField() {
        this.testInSecondField(i -> ByteBuffer.allocate(4).putInt((int)i).array(), "bytesId", 4);
    }

    @Test
    public void testRangeUuidField() {
        this.testRangeField(i -> {
            String formatted = String.format("%04d", i);
            String uuid = "2af83a15-" + formatted + "-4c13-871d-b14f0d37fe2e";
            return UUID.fromString(uuid);
        }, "uuidId");
    }

    @Test
    public void testInUuidField() {
        this.testInSecondField(i -> {
            String formatted = String.format("%04d", i);
            String uuid = "2af83a15-" + formatted + "-4c13-871d-b14f0d37fe2e";
            return UUID.fromString(uuid);
        }, "uuidId");
    }

    @Test
    public void testRangeStringField() {
        this.testRangeField(i -> String.format("%04d", i), "strId");
    }

    @Test
    public void testInStringField() {
        this.testInSecondField(i -> String.format("%04d", i), "strId");
    }

    @Test
    public void testBoolField() {
        Function<Integer, Boolean> valGen = i -> i > 5000;
        Function<Boolean, Person> persGen = i -> this.person("boolId", i);
        this.insertData(valGen, persGen, 10000);
        String boolIdx = this.idxName("boolId", false);
        IndexQuery qry = new IndexQuery(Person.class, boolIdx);
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, 10000, valGen, persGen);
        qry = new IndexQuery(Person.class, boolIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.eq((String)"boolId", (Object)true)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 5001, 10000, valGen, persGen);
        qry = new IndexQuery(Person.class, boolIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.eq((String)"boolId", (Object)false)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, 5001, valGen, persGen);
        qry = new IndexQuery(Person.class, boolIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)"boolId", Collections.singleton(false))});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, 5001, valGen, persGen);
    }

    @Test
    public void testRangeCrossTypeConvertion() {
        int cnt = 100;
        HashMap<String, Function<Integer, Object>> funcs = new HashMap<String, Function<Integer, Object>>();
        funcs.put("byte", Integer::byteValue);
        funcs.put("short", Integer::shortValue);
        funcs.put("int", Integer::intValue);
        funcs.put("long", Integer::longValue);
        funcs.put("float", Integer::floatValue);
        funcs.put("double", Integer::doubleValue);
        funcs.put("decimal", BigDecimal::valueOf);
        for (Map.Entry cacheRow : funcs.entrySet()) {
            for (Map.Entry searchRow : funcs.entrySet()) {
                log.info("Checking " + (String)cacheRow.getKey() + " cache row type with " + (String)searchRow.getKey() + " search row type");
                this.testRangeField((Function)cacheRow.getValue(), (Function)searchRow.getValue(), (String)cacheRow.getKey() + "Id", cnt);
            }
        }
        funcs.clear();
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        funcs.put("sqlDate", i -> {
            cal.clear();
            cal.set(2000 + i / 100, i / 10 % 10, i % 10);
            return new Date(cal.getTimeInMillis());
        });
        funcs.put("timestamp", i -> {
            cal.clear();
            cal.set(2000 + i / 100, i / 10 % 10, i % 10);
            return new Timestamp(cal.getTimeInMillis());
        });
        for (Map.Entry cacheRow : funcs.entrySet()) {
            for (Map.Entry searchRow : funcs.entrySet()) {
                log.info("Checking " + (String)cacheRow.getKey() + " cache row type with " + (String)searchRow.getKey() + " search row type");
                this.testRangeField((Function)cacheRow.getValue(), (Function)searchRow.getValue(), (String)cacheRow.getKey() + "Id", cnt);
            }
        }
    }

    @Test
    public void testCrossTypeComparisonWithOutOfBoundsFilter() {
        int cnt = 100;
        HashMap<String, Function<Integer, Object>> funcs = new HashMap<String, Function<Integer, Object>>();
        funcs.put("bool", i -> i != 0);
        funcs.put("byte", Integer::byteValue);
        for (Map.Entry func : funcs.entrySet()) {
            String fieldName = (String)func.getKey() + "Id";
            Function<Object, Person> persGen = i -> this.person(fieldName, i);
            this.insertData((Function)func.getValue(), persGen, cnt);
            for (Object filterVal : F.asList((Object[])new Number[]{1000, 1000L, 1000.0, 1000.0, BigDecimal.valueOf(1000L)})) {
                log.info("Checking " + (String)func.getKey() + " cache row type with " + filterVal.getClass().getSimpleName() + " search row type");
                IndexQuery qry = new IndexQuery(Person.class, this.idxName(fieldName, false)).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)fieldName, filterVal)});
                this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, cnt, (Function)func.getValue(), persGen);
                qry = new IndexQuery(Person.class, this.idxName(fieldName, false)).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.gt((String)fieldName, filterVal)});
                IndexQueryAllTypesTest.assertTrue((boolean)cache.query((Query)qry).getAll().isEmpty());
            }
        }
    }

    private <T> void testRangeField(Function<Integer, T> valGen, String fieldName) {
        this.testRangeField(valGen, fieldName, 10000);
    }

    private <T> void testRangeField(Function<Integer, T> valGen, String fieldName, int cnt) {
        this.testRangeField(valGen, valGen, fieldName, cnt);
    }

    private <T, S> void testRangeField(Function<Integer, T> valGen, Function<Integer, S> searchRowGen, String fieldName, int cnt) {
        Function<Object, Person> persGen = i -> this.person(fieldName, i);
        this.insertData(valGen, persGen, cnt);
        int pivot = new Random().nextInt(cnt);
        S val = searchRowGen.apply(pivot);
        IndexQuery qry = new IndexQuery(Person.class, this.idxName(fieldName, false));
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, cnt, valGen, persGen);
        qry = new IndexQuery(Person.class, this.idxName(fieldName, false)).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)fieldName, val)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, pivot, valGen, persGen);
        qry = new IndexQuery(Person.class, this.idxName(fieldName, false)).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)fieldName, val)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, pivot + 1, valGen, persGen);
        qry = new IndexQuery(Person.class, this.idxName(fieldName, false)).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.in((String)fieldName, Collections.singleton(val))});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), pivot, pivot + 1, valGen, persGen);
    }

    private <T, S> void testInSecondField(Function<Integer, T> valGen, String fieldName) {
        this.testInSecondField(valGen, valGen, fieldName, 10000);
    }

    private <T, S> void testInSecondField(Function<Integer, T> valGen, String fieldName, int cnt) {
        this.testInSecondField(valGen, valGen, fieldName, cnt);
    }

    private <T, S> void testInSecondField(Function<Integer, T> valGen, Function<Integer, S> searchRowGen, String fieldName, int cnt) {
        Function<Object, Person> persGen = i -> {
            Person p = this.person(fieldName, i);
            p.intId = 0;
            return p;
        };
        this.insertData(valGen, persGen, cnt);
        cache.query(new SqlFieldsQuery("create index if not exists IDX_intid_" + fieldName + " on Person(intId, " + fieldName + ");")).getAll();
        int pivot = new Random().nextInt(cnt);
        S val = searchRowGen.apply(pivot);
        IndexQuery qry = new IndexQuery(Person.class, this.idxName(fieldName, true)).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.eq((String)"intId", (Object)0), IndexQueryCriteriaBuilder.in((String)fieldName, Collections.singleton(val))});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), pivot, pivot + 1, valGen, persGen);
    }

    private String idxName(String field, boolean inTest) {
        if (!this.useIdxName) {
            return null;
        }
        return inTest ? "IDX_intid_" + field : ("Person_" + field + "_idx").toUpperCase();
    }

    private Person person(String field, Object val) {
        try {
            Field f = Person.class.getField(field);
            Person p = new Person();
            f.set(p, val);
            return p;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void check(QueryCursor<Cache.Entry<Long, Person>> cursor, int left, int right, Function<Integer, T> valGen, Function<T, Person> persGen) {
        List all = cursor.getAll();
        IndexQueryAllTypesTest.assertEquals((int)(right - left), (int)all.size());
        Set expKeys = LongStream.range(left, right).boxed().collect(Collectors.toSet());
        for (int i = 0; i < all.size(); ++i) {
            Cache.Entry entry = (Cache.Entry)all.get(i);
            IndexQueryAllTypesTest.assertTrue((boolean)expKeys.remove(entry.getKey()));
            if (this.useIdxName) {
                IndexQueryAllTypesTest.assertEquals((Object)persGen.apply(valGen.apply(left + i)), (Object)((Cache.Entry)all.get(i)).getValue());
                continue;
            }
            IndexQueryAllTypesTest.assertEquals((Object)persGen.apply(valGen.apply((int)((Long)entry.getKey()).longValue())), (Object)entry.getValue());
        }
        IndexQueryAllTypesTest.assertTrue((boolean)expKeys.isEmpty());
    }

    private <T> void insertData(Function<Integer, T> valGen, Function<T, Person> persGen, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            cache.put((Object)i, (Object)persGen.apply(valGen.apply(i)));
        }
    }

    public static class PojoField
    implements Serializable {
        private int intVal;
        private String strVal;
        private Timestamp tsVal;

        PojoField(int i) {
            this.intVal = i;
            this.strVal = String.valueOf(i);
            this.tsVal = new Timestamp(i);
        }

        public int hashCode() {
            return Objects.hash(this.intVal, this.strVal, this.tsVal);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            PojoField pojo = (PojoField)other;
            return this.intVal == pojo.intVal && Objects.equals(this.strVal, pojo.strVal) && Objects.equals(this.tsVal, pojo.tsVal);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(this.intVal);
            out.writeInt(this.strVal.length());
            for (int i = 0; i < this.strVal.length(); ++i) {
                out.writeChar(this.strVal.charAt(i));
            }
            out.writeObject(this.tsVal);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.intVal = in.readInt();
            int strLen = in.readInt();
            StringBuilder bld = new StringBuilder();
            for (int i = 0; i < strLen; ++i) {
                bld.append(in.readChar());
            }
            this.strVal = bld.toString();
            this.tsVal = (Timestamp)in.readObject();
        }
    }

    private static class Person {
        @QuerySqlField(index=true)
        public boolean boolId;
        @QuerySqlField(index=true)
        public byte byteId;
        @QuerySqlField(index=true)
        public short shortId;
        @QuerySqlField(index=true)
        public int intId;
        @QuerySqlField(index=true)
        public long longId;
        @QuerySqlField(index=true)
        public BigDecimal decimalId;
        @QuerySqlField(index=true)
        public double doubleId;
        @QuerySqlField(index=true)
        public float floatId;
        @QuerySqlField(index=true)
        public Time timeId;
        @QuerySqlField(index=true)
        public java.util.Date dateId;
        @QuerySqlField(index=true)
        public Date sqlDateId;
        @QuerySqlField(index=true)
        public Timestamp timestampId;
        @QuerySqlField(index=true)
        public byte[] bytesId;
        @QuerySqlField(index=true)
        public String strId;
        @QuerySqlField(index=true)
        public PojoField pojoId;
        @QuerySqlField(index=true)
        public UUID uuidId;
        @QuerySqlField(index=true)
        public Integer intNullId;

        private Person() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.boolId == person.boolId && this.byteId == person.byteId && this.shortId == person.shortId && this.intId == person.intId && this.longId == person.longId && Double.compare(person.doubleId, this.doubleId) == 0 && Float.compare(person.floatId, this.floatId) == 0 && Objects.equals(this.decimalId, person.decimalId) && Objects.equals(this.timeId, person.timeId) && Objects.equals(this.dateId, person.dateId) && Objects.equals(this.sqlDateId, person.sqlDateId) && Objects.equals(this.timestampId, person.timestampId) && Arrays.equals(this.bytesId, person.bytesId) && Objects.equals(this.strId, person.strId) && Objects.equals(this.pojoId, person.pojoId) && Objects.equals(this.uuidId, person.uuidId);
        }

        public int hashCode() {
            int result = Objects.hash(this.boolId, this.byteId, this.shortId, this.intId, this.longId, this.decimalId, this.doubleId, Float.valueOf(this.floatId), this.timeId, this.dateId, this.sqlDateId, this.timestampId, this.strId, this.pojoId, this.uuidId);
            result = 31 * result + Arrays.hashCode(this.bytesId);
            return result;
        }
    }
}

