/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.io;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.io.H2IOUtils;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;

public abstract class AbstractH2LeafIO
extends BPlusLeafIO<H2Row>
implements H2RowLinkIO {
    AbstractH2LeafIO(int type, int ver, int itemSize) {
        super(type, ver, itemSize);
    }

    public final void storeByOffset(long pageAddr, int off, H2Row row) {
        this.assertPageType(pageAddr);
        H2CacheRow row0 = (H2CacheRow)row;
        H2IOUtils.storeRow(row0, pageAddr, off, this.storeMvccInfo());
    }

    public final void store(long dstPageAddr, int dstIdx, BPlusIO<H2Row> srcIo, long srcPageAddr, int srcIdx) {
        assert (srcIo == this);
        this.assertPageType(dstPageAddr);
        H2IOUtils.store(dstPageAddr, this.offset(dstIdx), srcIo, srcPageAddr, srcIdx, this.storeMvccInfo());
    }

    public H2Row getLookupRow(BPlusTree<H2Row, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
        long link = this.getLink(pageAddr, idx);
        if (this.storeMvccInfo()) {
            long mvccCrdVer = this.getMvccCoordinatorVersion(pageAddr, idx);
            long mvccCntr = this.getMvccCounter(pageAddr, idx);
            int mvccOpCntr = this.getMvccOperationCounter(pageAddr, idx);
            return ((H2Tree)tree).createMvccRow(link, mvccCrdVer, mvccCntr, mvccOpCntr);
        }
        return ((H2Tree)tree).createRow(link);
    }

    @Override
    public long getLink(long pageAddr, int idx) {
        return PageUtils.getLong((long)pageAddr, (int)this.offset(idx));
    }

    @Override
    public int getPayloadSize() {
        return 0;
    }
}

